/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.GTDModelAdapter;
import org.gtdfree.model.Project;
import org.gtdfree.model.StatusActionFilter;

public class SelectionModel {
    public static final String PROP_CUSTOM_FOLDERS = "customFolders";
    public static final String PROP_CUSTOM_PROJECTS = "customFolders";
    public static final String PROP_CUSTOM_ACTIONS = "customActions";
    public static final String PROP_ACTION_CRITERIA = "actionCriteria";
    public static final String PROP_PROJECT_CRITERIA = "projectCriteria";
    public static final String PROP_FOLDER_CRITERIA = "folderCriteria";
    public static final String PROP_SELECTED_FOLDERS = "selectedFolders";
    public static final String PROP_SELECTED_PROJECTS = "selectedProjects";
    public static final String PROP_INCLUDE_RESOLVED = "includeResolves";
    public static final String PROP_INCLUDE_DELETED = "includeResolves";
    public static final String PROP_INCLUDE_EMPTY_FOLDERS = "exportEmptyFolders";
    public static final String PROP_INCLUDE_EMPTY_PROJECTS = "exportEmptyProjects";
    public static final String PROP_INCLUDE_WITHOUT_PROJECT = "exportWithoutProject";
    private GTDModel gtdModel;
    private List<Folder> customFolders = new ArrayList<Folder>();
    private List<Project> customProjects = new ArrayList<Project>();
    private List<Action> customActions = new ArrayList<Action>();
    private List<Folder> selectedFolders = new ArrayList<Folder>();
    private List<Project> selectedProjects = new ArrayList<Project>();
    private boolean selectionDirty = true;
    private SelectionCriteria folderCriteria = SelectionCriteria.ALL;
    private SelectionCriteria projectCriteria = SelectionCriteria.ALL;
    private SelectionCriteria actionCriteria = SelectionCriteria.ALL;
    private PropertyChangeSupport prop = new PropertyChangeSupport(this);
    private boolean includeResolved;
    private boolean includeDeleted;
    private boolean includeEmptyFolders;
    private boolean includeEmptyProjects;
    private boolean includeWithoutProject;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.prop.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.prop.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String p, PropertyChangeListener l) {
        this.prop.addPropertyChangeListener(p, l);
    }

    public void removePropertyChangeListener(String p, PropertyChangeListener l) {
        this.prop.removePropertyChangeListener(p, l);
    }

    public void setGtdModel(GTDModel model) {
        this.gtdModel = model;
        model.addGTDModelListener(new GTDModelAdapter(){

            @Override
            public void elementRemoved(FolderEvent a) {
                SelectionModel.this.removeCustomAction(a.getAction());
            }

            @Override
            public void elementModified(ActionEvent a) {
            }

            @Override
            public void folderRemoved(Folder folder) {
                SelectionModel.this.removeCustomFolder(folder);
            }

            @Override
            public void folderModified(FolderEvent folder) {
            }
        });
    }

    public GTDModel getGtdModel() {
        return this.gtdModel;
    }

    private void firePropertyChangeEvent(String p, Object val) {
        this.prop.firePropertyChange(p, null, val);
    }

    protected void removeCustomFolder(Folder folder) {
        if (this.customFolders.remove(folder)) {
            this.firePropertyChangeEvent("customFolders", this.customFolders);
        }
    }

    protected void removeCustomProject(Project folder) {
        if (this.customProjects.remove(folder)) {
            this.firePropertyChangeEvent("customFolders", this.customProjects);
        }
    }

    protected void removeCustomAction(Action action) {
        if (this.customActions.remove(action)) {
            this.firePropertyChangeEvent(PROP_CUSTOM_ACTIONS, this.customActions);
        }
    }

    public SelectionCriteria getFolderCriteria() {
        return this.folderCriteria;
    }

    public void setFolderCriteria(SelectionCriteria folderCriteria) {
        if (this.folderCriteria == folderCriteria) {
            return;
        }
        this.folderCriteria = folderCriteria;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_FOLDER_CRITERIA, (Object)folderCriteria);
        this.firePropertyChangeEvent(PROP_SELECTED_FOLDERS, 1);
    }

    public SelectionCriteria getProjectCriteria() {
        return this.projectCriteria;
    }

    public void setProjectCriteria(SelectionCriteria projectCriteria) {
        if (this.projectCriteria == projectCriteria) {
            return;
        }
        this.projectCriteria = projectCriteria;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_PROJECT_CRITERIA, (Object)projectCriteria);
        this.firePropertyChangeEvent(PROP_SELECTED_PROJECTS, 1);
    }

    public SelectionCriteria getActionCriteria() {
        return this.actionCriteria;
    }

    public void setActionCriteria(SelectionCriteria actionCriteria) {
        if (this.actionCriteria == actionCriteria) {
            return;
        }
        this.actionCriteria = actionCriteria;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_ACTION_CRITERIA, (Object)actionCriteria);
    }

    public void setCustomFolders(Folder[] f) {
        this.customFolders.clear();
        for (Folder folder : f) {
            this.customFolders.add(folder);
        }
        this.selectionDirty = true;
        this.firePropertyChangeEvent("customFolders", this.customFolders);
        if (this.selectionDirty) {
            this.firePropertyChangeEvent(PROP_SELECTED_FOLDERS, 1);
        }
    }

    public void setCustomProjects(Folder[] f) {
        this.customProjects.clear();
        for (Folder folder : f) {
            this.customProjects.add((Project)folder);
        }
        this.selectionDirty = true;
        this.firePropertyChangeEvent("customFolders", this.customProjects);
        if (this.selectionDirty) {
            this.firePropertyChangeEvent(PROP_SELECTED_PROJECTS, 1);
        }
    }

    public Folder[] getSelectedFolders() {
        this.updateSeletion();
        return this.selectedFolders.toArray(new Folder[this.selectedFolders.size()]);
    }

    public int getSelectedFoldersCount() {
        this.updateSeletion();
        return this.selectedFolders.size();
    }

    public Iterator<Folder> selectedFolders() {
        this.updateSeletion();
        return this.selectedFolders.iterator();
    }

    public Folder[] getSelectedProjects() {
        this.updateSeletion();
        return this.selectedProjects.toArray(new Folder[this.selectedProjects.size()]);
    }

    public int getSelectedProjectsCount() {
        this.updateSeletion();
        return this.selectedProjects.size();
    }

    public Iterator<Project> selectedProjects() {
        this.updateSeletion();
        return this.selectedProjects.iterator();
    }

    private void updateSeletion() {
        if (!this.selectionDirty) {
            return;
        }
        if (this.gtdModel == null) {
            return;
        }
        this.selectionDirty = false;
        this.selectedFolders.clear();
        this.selectedProjects.clear();
        boolean done = true;
        if (this.folderCriteria == SelectionCriteria.CUSTOM) {
            for (Folder folder : this.customFolders) {
                if (!this.includeEmptyFolders && folder.getOpenCount() <= 0 && (folder.size() <= 0 || !this.includeDeleted && !this.includeResolved)) continue;
                this.selectedFolders.add(folder);
            }
        } else {
            done = false;
        }
        if (this.projectCriteria == SelectionCriteria.CUSTOM) {
            for (Project project : this.customProjects) {
                if (!this.includeEmptyProjects && project.getOpenCount() <= 0 && (project.size() <= 0 || !this.includeDeleted && !this.includeResolved)) continue;
                this.selectedProjects.add(project);
            }
        } else {
            done = false;
        }
        if (!done) {
            for (Folder folder : this.gtdModel) {
                if (folder.isProject()) {
                    if (this.projectCriteria != SelectionCriteria.ALL || !this.includeEmptyProjects && folder.getOpenCount() <= 0 && (folder.size() <= 0 || !this.includeDeleted && !this.includeResolved)) continue;
                    this.selectedProjects.add((Project)folder);
                    continue;
                }
                if (this.folderCriteria != SelectionCriteria.ALL || !this.includeEmptyFolders && folder.getOpenCount() <= 0 && (folder.size() <= 0 || !this.includeDeleted && !this.includeResolved)) continue;
                this.selectedFolders.add(folder);
            }
        }
        Collections.sort(this.selectedFolders, new Comparator<Folder>(){

            @Override
            public int compare(Folder o1, Folder o2) {
                int i = o1.getName().compareTo(o2.getName());
                if (i == 0) {
                    return o1.getId() - o2.getId();
                }
                return i;
            }
        });
        Collections.sort(this.selectedProjects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                int i = o1.getName().compareTo(o2.getName());
                if (i == 0) {
                    return o1.getId() - o2.getId();
                }
                return i;
            }
        });
    }

    public ActionsCollection getSelection() {
        this.updateSeletion();
        return new ActionsCollection(this.selectedFolders, this.selectedProjects, this.includeEmptyFolders, this.includeEmptyProjects, this.includeWithoutProject, new StatusActionFilter(this.includeResolved, this.includeDeleted));
    }

    public void setIncludeResolved(boolean selected) {
        this.includeResolved = selected;
        this.firePropertyChangeEvent("includeResolves", this.includeResolved);
    }

    public boolean isIncludeResolved() {
        return this.includeResolved;
    }

    public void setIncludeDeleted(boolean selected) {
        this.includeDeleted = selected;
        this.firePropertyChangeEvent("includeResolves", this.includeDeleted);
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeEmptyFolders(boolean selected) {
        if (this.includeEmptyFolders == selected) {
            return;
        }
        this.includeEmptyFolders = selected;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_INCLUDE_EMPTY_FOLDERS, this.includeEmptyFolders);
        this.firePropertyChangeEvent(PROP_SELECTED_PROJECTS, 1);
    }

    public boolean isIncludeEmptyFolders() {
        return this.includeEmptyFolders;
    }

    public void setIncludeEmptyProjects(boolean selected) {
        if (this.includeEmptyProjects == selected) {
            return;
        }
        this.includeEmptyProjects = selected;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_INCLUDE_EMPTY_PROJECTS, this.includeEmptyProjects);
        this.firePropertyChangeEvent(PROP_SELECTED_PROJECTS, 1);
    }

    public boolean isIncludeEmptyProjects() {
        return this.includeEmptyProjects;
    }

    public void setIncludeWithoutProject(boolean b) {
        if (this.includeWithoutProject == b) {
            return;
        }
        this.includeWithoutProject = b;
        this.selectionDirty = true;
        this.firePropertyChangeEvent(PROP_INCLUDE_WITHOUT_PROJECT, this.includeWithoutProject);
        this.firePropertyChangeEvent(PROP_SELECTED_PROJECTS, 1);
    }

    public boolean isIncludeWithoutProject() {
        return this.includeWithoutProject;
    }

    public static enum SelectionCriteria {
        ALL,
        CUSTOM;

    }

    public static enum SelectionMode {
        Lists,
        Projects,
        Lists_and_projects,
        Actions;

    }
}

