/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gtdfree.Messages;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.gui.ActionTable;
import org.gtdfree.model.ANDActionFilter;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.Folder;
import org.gtdfree.model.Project;
import org.gtdfree.model.ProjectFilter;

public class ActionsCollection {
    public static final String ACTIONS_WITHOUT_PROJECT = Messages.getString("ActionsCollection.Actions");
    private List<Folder> folders;
    private List<Project> projects;
    private Map<Integer, Integer> folderKeys;
    private Map<Integer, Integer> projectKeys;
    private ActionFilter filter;
    private boolean includeEmptyFolders = false;
    private boolean includeEmptyProjects = false;
    private boolean includeWithoutProject = false;
    private ActionTable actionTable;

    public ActionsCollection(ActionTable at) {
        this.actionTable = at;
    }

    public ActionsCollection(List<Folder> folders, List<Project> projects, boolean includeEmptyFolders, boolean includeEmptyProjects, boolean includeWithoutProject, ActionFilter filter) {
        this.folders = folders;
        this.projects = projects;
        this.filter = filter;
        this.includeEmptyFolders = includeEmptyFolders;
        this.includeEmptyProjects = includeEmptyProjects;
        this.includeWithoutProject = includeWithoutProject;
    }

    public boolean isInRange(Folder f, Action a) {
        if (a.getProject() != null) {
            if (this.includeWithoutProject) {
                return this.getFoldersKeys().contains(f.getId());
            }
            return this.getProjectKeys().contains(a.getProject()) && this.getFoldersKeys().contains(f.getId());
        }
        return this.includeWithoutProject && this.getFoldersKeys().contains(f.getId());
    }

    public ActionFilter getFilter() {
        return this.filter;
    }

    public List<Folder> getFolders() {
        return this.folders;
    }

    public Map<Integer, Integer> getProjectKey2Index() {
        if (this.projectKeys == null) {
            this.projectKeys = new HashMap<Integer, Integer>(this.projects.size());
            for (int i = 0; i < this.projects.size(); ++i) {
                this.projectKeys.put(this.projects.get(i).getId(), i);
            }
        }
        return this.projectKeys;
    }

    public Set<Integer> getProjectKeys() {
        return this.getProjectKey2Index().keySet();
    }

    public Map<Integer, Integer> getFoldersKeys2Index() {
        if (this.folderKeys == null) {
            this.folderKeys = new HashMap<Integer, Integer>(this.folders.size());
            for (int i = 0; i < this.folders.size(); ++i) {
                this.folderKeys.put(this.folders.get(i).getId(), i);
            }
        }
        return this.folderKeys;
    }

    public Set<Integer> getFoldersKeys() {
        return this.getFoldersKeys2Index().keySet();
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Iterator<Object> iterator(ExportAddOn.ExportOrder order) {
        if (this.actionTable != null) {
            return new ActionTableIterator();
        }
        if (order == ExportAddOn.ExportOrder.FoldersActions) {
            return new FoldersActionsIterator(this.filter);
        }
        if (order == ExportAddOn.ExportOrder.FoldersProjectsActions) {
            return new FoldersProjectsActionsIterator();
        }
        if (order == ExportAddOn.ExportOrder.ProjectsFoldersActions) {
            return new ProjectsFoldersActionsIterator();
        }
        if (order == ExportAddOn.ExportOrder.ProjectsActions) {
            return new ProjectsActionsIterator();
        }
        if (order == ExportAddOn.ExportOrder.Actions) {
            return new ActionsIterator(this.filter);
        }
        return new ActionsIterator(this.filter);
    }

    private final void addNode(Object a, int i, Node[] first, Node[] last) {
        if (first[i] == null) {
            first[i] = last[i] = new Node(a);
        } else {
            last[i] = last[i].add(a);
        }
    }

    private final Node joinNodes(Node[] first, Node[] last) {
        Node n = null;
        Node nn = null;
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == null) continue;
            if (first[i].next == null && first[i].obj != null) {
                Folder f = (Folder)first[i].obj;
                if (!this.includeEmptyFolders && !f.isProject() || !this.includeEmptyProjects && f.isProject()) continue;
            }
            if (n == null) {
                n = first[i];
                nn = last[i];
                continue;
            }
            nn.next = first[i];
            nn = last[i];
        }
        return n;
    }

    class FoldersInProjectIterator
    implements Iterator<Object> {
        Node node;

        public FoldersInProjectIterator(int project) {
            Node[] first = new Node[ActionsCollection.this.folders.size()];
            Node[] last = new Node[first.length];
            Folder f = (Folder)ActionsCollection.this.projects.get(project);
            for (Action a : f) {
                Integer i;
                if (!ActionsCollection.this.filter.isAcceptable(a.getParent(), a) || (i = ActionsCollection.this.getFoldersKeys2Index().get(a.getParent().getId())) == null) continue;
                if (first[i] == null) {
                    ActionsCollection.this.addNode(a.getParent(), i, first, last);
                }
                ActionsCollection.this.addNode(a, i, first, last);
            }
            this.node = ActionsCollection.this.joinNodes(first, last);
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            Node n = this.node;
            this.node = this.node.next;
            return n.obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ProjectsInFolderIterator
    implements Iterator<Object> {
        Node node;

        public ProjectsInFolderIterator(int folder) {
            Node[] first = new Node[ActionsCollection.this.projects.size() + 1];
            Node[] last = new Node[first.length];
            Folder f = (Folder)ActionsCollection.this.folders.get(folder);
            for (Action a : f) {
                if (!ActionsCollection.this.filter.isAcceptable(f, a)) continue;
                Integer i = null;
                if (a.getProject() == null) {
                    if (ActionsCollection.this.includeWithoutProject && first[i = Integer.valueOf(ActionsCollection.this.projects.size())] == null) {
                        ActionsCollection.this.addNode(ACTIONS_WITHOUT_PROJECT, i, first, last);
                    }
                } else {
                    i = ActionsCollection.this.getProjectKey2Index().get(a.getProject());
                }
                if (i == null) continue;
                if (first[i] == null) {
                    ActionsCollection.this.addNode(ActionsCollection.this.projects.get(i), i, first, last);
                }
                ActionsCollection.this.addNode(a, i, first, last);
            }
            this.node = ActionsCollection.this.joinNodes(first, last);
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            Node n = this.node;
            this.node = this.node.next;
            return n.obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class Node {
        public Object obj;
        public Node next;

        public Node(Object obj) {
            this.obj = obj;
        }

        public Node add(Object obj) {
            if (this.next != null) {
                return this.next.add(obj);
            }
            this.next = new Node(obj);
            return this.next;
        }
    }

    class ProjectsFoldersActionsIterator
    implements Iterator<Object> {
        int projectIndex = 0;
        FoldersInProjectIterator byFolders;
        boolean nextProjectReady = true;
        Iterator<Object> noProject;

        ProjectsFoldersActionsIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.projectIndex >= ActionsCollection.this.projects.size()) {
                if (this.noProject == null) {
                    this.nextProjectReady = true;
                    this.noProject = new FoldersActionsIterator(new ANDActionFilter(new ProjectFilter(null), ActionsCollection.this.filter));
                }
                return this.noProject.hasNext();
            }
            Folder f = (Folder)ActionsCollection.this.projects.get(this.projectIndex);
            if (!ActionsCollection.this.filter.isAcceptable(f, null)) {
                ++this.projectIndex;
                this.nextProjectReady = true;
                this.byFolders = null;
                return this.hasNext();
            }
            if (this.byFolders == null) {
                this.byFolders = new FoldersInProjectIterator(this.projectIndex);
            }
            if (!this.byFolders.hasNext()) {
                if (this.nextProjectReady && ActionsCollection.this.includeEmptyProjects) {
                    return true;
                }
                ++this.projectIndex;
                this.nextProjectReady = true;
                this.byFolders = null;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.noProject != null) {
                if (this.nextProjectReady) {
                    this.nextProjectReady = false;
                    return ACTIONS_WITHOUT_PROJECT;
                }
                return this.noProject.next();
            }
            if (this.nextProjectReady) {
                this.nextProjectReady = false;
                return ActionsCollection.this.projects.get(this.projectIndex);
            }
            return this.byFolders.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ProjectsActionsIterator
    implements Iterator<Object> {
        int projectIndex = 0;
        int actionIndex = 0;
        boolean nextProjectReady = true;
        ActionsIterator noProject;

        ProjectsActionsIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.projectIndex >= ActionsCollection.this.projects.size()) {
                if (this.noProject == null) {
                    this.nextProjectReady = true;
                    this.noProject = new ActionsIterator(new ANDActionFilter(new ProjectFilter(null), ActionsCollection.this.filter));
                }
                return this.noProject.hasNext();
            }
            Project f = (Project)ActionsCollection.this.projects.get(this.projectIndex);
            if (!ActionsCollection.this.filter.isAcceptable(f, null)) {
                ++this.projectIndex;
                this.nextProjectReady = true;
                this.actionIndex = 0;
                return this.hasNext();
            }
            if (this.actionIndex >= f.size()) {
                if (this.nextProjectReady && ActionsCollection.this.includeEmptyFolders) {
                    return true;
                }
                ++this.projectIndex;
                this.nextProjectReady = true;
                this.actionIndex = 0;
                return this.hasNext();
            }
            Action a = f.get(this.actionIndex);
            if (!ActionsCollection.this.filter.isAcceptable(f, a) || !ActionsCollection.this.isInRange(a.getParent(), a)) {
                ++this.actionIndex;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.noProject != null) {
                if (this.nextProjectReady) {
                    this.nextProjectReady = false;
                    return ACTIONS_WITHOUT_PROJECT;
                }
                return this.noProject.next();
            }
            if (this.nextProjectReady) {
                this.nextProjectReady = false;
                return ActionsCollection.this.projects.get(this.projectIndex);
            }
            return ((Project)ActionsCollection.this.projects.get(this.projectIndex)).get(this.actionIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class FoldersProjectsActionsIterator
    implements Iterator<Object> {
        int folderIndex = 0;
        ProjectsInFolderIterator byProjects;
        boolean nextFolderReady = true;

        FoldersProjectsActionsIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.folderIndex >= ActionsCollection.this.folders.size()) {
                return false;
            }
            Folder f = (Folder)ActionsCollection.this.folders.get(this.folderIndex);
            if (!ActionsCollection.this.filter.isAcceptable(f, null)) {
                ++this.folderIndex;
                this.nextFolderReady = true;
                this.byProjects = null;
                return this.hasNext();
            }
            if (this.byProjects == null) {
                this.byProjects = new ProjectsInFolderIterator(this.folderIndex);
            }
            if (!this.byProjects.hasNext()) {
                if (this.nextFolderReady && ActionsCollection.this.includeEmptyFolders) {
                    return true;
                }
                ++this.folderIndex;
                this.nextFolderReady = true;
                this.byProjects = null;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.nextFolderReady) {
                this.nextFolderReady = false;
                return ActionsCollection.this.folders.get(this.folderIndex);
            }
            return this.byProjects.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ActionsIterator
    implements Iterator<Object> {
        int folderIndex = 0;
        int actionIndex = 0;
        ActionFilter filter;

        public ActionsIterator(ActionFilter f) {
            this.filter = f;
        }

        @Override
        public boolean hasNext() {
            if (this.folderIndex >= ActionsCollection.this.folders.size()) {
                return false;
            }
            Folder f = (Folder)ActionsCollection.this.folders.get(this.folderIndex);
            if (!this.filter.isAcceptable(f, null)) {
                ++this.folderIndex;
                return this.hasNext();
            }
            if (this.actionIndex >= f.size()) {
                ++this.folderIndex;
                this.actionIndex = 0;
                return this.hasNext();
            }
            if (!this.filter.isAcceptable(f, f.get(this.actionIndex)) || !ActionsCollection.this.isInRange(f, f.get(this.actionIndex))) {
                ++this.actionIndex;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            return ((Folder)ActionsCollection.this.folders.get(this.folderIndex)).get(this.actionIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class FoldersActionsIterator
    implements Iterator<Object> {
        int folderIndex = 0;
        int actionIndex = 0;
        ActionFilter filter;
        boolean nextFolderReady = true;

        public FoldersActionsIterator(ActionFilter f) {
            this.filter = f;
        }

        @Override
        public boolean hasNext() {
            if (this.folderIndex >= ActionsCollection.this.folders.size()) {
                return false;
            }
            Folder f = (Folder)ActionsCollection.this.folders.get(this.folderIndex);
            if (!this.filter.isAcceptable(f, null)) {
                ++this.folderIndex;
                this.nextFolderReady = true;
                this.actionIndex = 0;
                return this.hasNext();
            }
            if (this.actionIndex >= f.size()) {
                if (this.nextFolderReady && ActionsCollection.this.includeEmptyFolders) {
                    return true;
                }
                ++this.folderIndex;
                this.nextFolderReady = true;
                this.actionIndex = 0;
                return this.hasNext();
            }
            if (!this.filter.isAcceptable(f, f.get(this.actionIndex)) || !ActionsCollection.this.isInRange(f, f.get(this.actionIndex))) {
                ++this.actionIndex;
                return this.hasNext();
            }
            return true;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.nextFolderReady) {
                this.nextFolderReady = false;
                return ActionsCollection.this.folders.get(this.folderIndex);
            }
            return ((Folder)ActionsCollection.this.folders.get(this.folderIndex)).get(this.actionIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ActionTableIterator
    implements Iterator<Object> {
        int index = -1;

        ActionTableIterator() {
        }

        @Override
        public boolean hasNext() {
            return ActionsCollection.this.actionTable != null && ActionsCollection.this.actionTable.getFolder() != null && this.index < ActionsCollection.this.actionTable.getRowCount();
        }

        @Override
        public Object next() {
            if (this.index < 0) {
                this.index = 0;
                return ActionsCollection.this.actionTable.getFolder();
            }
            return ActionsCollection.this.actionTable.getActionAtView(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

