/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import org.gtdfree.model.Action;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.Folder;

public class DescriptionFilter
implements ActionFilter {
    private String criterion;
    private boolean caseSensitive = false;

    public DescriptionFilter(String s, boolean b) {
        this.criterion = s;
        this.caseSensitive = b;
        if (!this.caseSensitive) {
            this.criterion = this.criterion.toLowerCase();
        }
    }

    @Override
    public boolean isAcceptable(Folder f, Action a) {
        if (this.criterion == null) {
            return true;
        }
        if (this.caseSensitive) {
            return a != null && a.getDescription() != null && a.getDescription().contains(this.criterion);
        }
        return a != null && a.getDescription() != null && a.getDescription().toLowerCase().contains(this.criterion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DescriptionFilter) {
            DescriptionFilter f = (DescriptionFilter)obj;
            return f.caseSensitive == this.caseSensitive && f.criterion == this.criterion;
        }
        return false;
    }
}

