/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.tool;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IKeyAndValue;

public class BTreeDisplay {
    private StringBuffer[] lines;
    private StringBuffer result;

    public StringBuffer build(IBTree btree, boolean withIds) {
        this.lines = new StringBuffer[btree.getHeight()];
        for (int i = 0; i < btree.getHeight(); ++i) {
            this.lines[i] = new StringBuffer();
        }
        this.buildDisplay(btree.getRoot(), 0, 0, "0", withIds);
        this.buildRepresentation();
        return this.result;
    }

    public StringBuffer build(IBTreeNode node, int height, boolean withIds) {
        this.lines = new StringBuffer[height];
        for (int i = 0; i < height; ++i) {
            this.lines[i] = new StringBuffer();
        }
        this.buildDisplay(node, 0, 0, "0", withIds);
        this.buildRepresentation();
        return this.result;
    }

    private void buildRepresentation() {
        int maxLineSize = this.lines[this.lines.length - 1].length();
        this.result = new StringBuffer();
        for (int i = 0; i < this.lines.length; ++i) {
            this.result.append(this.format(this.lines[i], i, maxLineSize)).append("\n");
        }
    }

    public StringBuffer getResult() {
        return this.result;
    }

    private StringBuffer format(StringBuffer line, int height, int maxLineSize) {
        int diff = maxLineSize - line.length();
        StringBuffer lineResult = new StringBuffer();
        lineResult.append("h=").append(height + 1).append(":");
        lineResult.append(this.fill(diff / 2, ' '));
        lineResult.append(line);
        lineResult.append(this.fill(diff / 2, ' '));
        return lineResult;
    }

    private StringBuffer fill(int size, char c) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buffer.append(c);
        }
        return buffer;
    }

    private void buildDisplay(IBTreeNode node, int currentHeight, int childIndex, Object parentId, boolean withIds) {
        int i;
        if (currentHeight > this.lines.length - 1) {
            return;
        }
        StringBuffer line = this.lines[currentHeight];
        if (withIds) {
            line.append(node.getId()).append(":[");
        } else {
            line.append("[");
        }
        for (i = 0; i < node.getNbKeys(); ++i) {
            if (i > 0) {
                line.append(" , ");
            }
            IKeyAndValue kav = node.getKeyAndValueAt(i);
            line.append(kav.getKey());
        }
        if (withIds) {
            line.append("]:").append(node.getParentId()).append("/").append(parentId).append("    ");
        } else {
            line.append("]  ");
        }
        for (i = 0; i < node.getNbChildren(); ++i) {
            IBTreeNode child = node.getChildAt(i, false);
            if (child != null) {
                this.buildDisplay(child, currentHeight + 1, i, node.getId(), withIds);
                continue;
            }
            this.lines[currentHeight + 1].append("[Child " + (i + 1) + " null!] ");
        }
    }
}

