/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.CIZoneInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoCompareResult;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.CommittedCIZoneInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
implements Serializable {
    public static final byte CATEGORY_SYSTEM_CLASS = 1;
    public static final byte CATEGORY_USER_CLASS = 2;
    private static final long serialVersionUID = 1L;
    private byte classCategory;
    private String fullClassName;
    private String extraInfo;
    private IOdbList<ClassAttributeInfo> attributes;
    private Map<String, ClassAttributeInfo> attributesByName;
    private Map<Integer, ClassAttributeInfo> attributesById;
    private CommittedCIZoneInfo original = new CommittedCIZoneInfo(this, null, null, 0L);
    private CommittedCIZoneInfo committed = new CommittedCIZoneInfo(this, null, null, 0L);
    private CIZoneInfo uncommitted = new CIZoneInfo(this, null, null, 0L);
    private long position = -1L;
    private OID id;
    private OID previousClassOID = null;
    private OID nextClassOID = null;
    private long attributesDefinitionPosition;
    private int blockSize = -1;
    private ObjectInfoHeader lastObjectInfoHeader;
    private int maxAttributeId = -1;
    private IOdbList<ClassInfoIndex> indexes;
    private transient IOdbList<Object> history;

    public ClassInfo() {
        this.classCategory = (byte)2;
        this.history = new OdbArrayList<Object>();
    }

    public ClassInfo(String className) {
        this(className, "", null);
    }

    public ClassInfo(String className, String extraInfo) {
        this(className, extraInfo, null);
    }

    protected ClassInfo(String fullClassName, String extraInfo, IOdbList<ClassAttributeInfo> attributes) {
        this();
        this.fullClassName = fullClassName;
        this.extraInfo = extraInfo;
        this.attributes = attributes;
        this.attributesByName = new OdbHashMap<String, ClassAttributeInfo>();
        this.attributesById = new OdbHashMap<Integer, ClassAttributeInfo>();
        if (attributes != null) {
            this.fillAttributesMap();
        }
        this.maxAttributeId = attributes == null ? 1 : attributes.size() + 1;
    }

    private void fillAttributesMap() {
        ClassAttributeInfo cai = null;
        if (this.attributesByName == null) {
            this.attributesByName = new OdbHashMap<String, ClassAttributeInfo>();
            this.attributesById = new OdbHashMap<Integer, ClassAttributeInfo>();
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            cai = this.attributes.get(i);
            this.attributesByName.put(cai.getName(), cai);
            this.attributesById.put(new Integer(cai.getId()), cai);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ClassInfo.class) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)obj;
        return classInfo.fullClassName.equals(this.fullClassName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" [ ").append(this.fullClassName).append(" - id=").append(this.id);
        buffer.append(" - previousClass=").append(this.previousClassOID).append(" - nextClass=").append(this.nextClassOID).append(" - attributes=(");
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                ClassAttributeInfo cai = this.attributes.get(i);
                buffer.append(cai.getName()).append(",");
            }
        } else {
            buffer.append("not yet defined");
        }
        buffer.append(") ]");
        return buffer.toString();
    }

    public IOdbList<ClassAttributeInfo> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IOdbList<ClassAttributeInfo> attributes) {
        this.attributes = attributes;
        this.maxAttributeId = Math.max(this.maxAttributeId, attributes.size());
        this.fillAttributesMap();
    }

    public CommittedCIZoneInfo getCommitedZoneInfo() {
        return this.committed;
    }

    public long getAttributesDefinitionPosition() {
        return this.attributesDefinitionPosition;
    }

    public void setAttributesDefinitionPosition(long definitionPosition) {
        this.attributesDefinitionPosition = definitionPosition;
    }

    public OID getNextClassOID() {
        return this.nextClassOID;
    }

    public void setNextClassOID(OID nextClassOID) {
        this.nextClassOID = nextClassOID;
    }

    public OID getPreviousClassOID() {
        return this.previousClassOID;
    }

    public void setPreviousClassOID(OID previousClassOID) {
        this.previousClassOID = previousClassOID;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public IOdbList<ClassAttributeInfo> getAllNonNativeAttributes() {
        OdbArrayList<ClassAttributeInfo> result = new OdbArrayList<ClassAttributeInfo>(this.attributes.size());
        ClassAttributeInfo cai = null;
        for (int i = 0; i < this.attributes.size(); ++i) {
            cai = this.attributes.get(i);
            if (!cai.isNative() || cai.getAttributeType().isEnum()) {
                result.add(cai);
                continue;
            }
            if (!cai.getAttributeType().isArray() || cai.getAttributeType().getSubType().isNative()) continue;
            result.add(new ClassAttributeInfo(-1, "subtype", cai.getAttributeType().getSubType().getName(), null));
        }
        return result;
    }

    public OID getId() {
        return this.id;
    }

    public void setId(OID id) {
        this.id = id;
    }

    public ClassAttributeInfo getAttributeInfoFromId(int id) {
        return this.attributesById.get(new Integer(id));
    }

    public int getAttributeId(String name) {
        ClassAttributeInfo cai = this.attributesByName.get(name);
        if (cai == null) {
            return -1;
        }
        return cai.getId();
    }

    public ClassAttributeInfo getAttributeInfoFromName(String name) {
        return this.attributesByName.get(name);
    }

    public ClassAttributeInfo getAttributeInfo(int index) {
        return this.attributes.get(index);
    }

    public int getMaxAttributeId() {
        return this.maxAttributeId;
    }

    public void setMaxAttributeId(int maxAttributeId) {
        this.maxAttributeId = maxAttributeId;
    }

    public ClassInfoCompareResult extractDifferences(ClassInfo newCI, boolean update) {
        String attributeName = null;
        ClassAttributeInfo cai1 = null;
        ClassAttributeInfo cai2 = null;
        ClassInfoCompareResult result = new ClassInfoCompareResult(this.getFullClassName());
        boolean isCompatible = true;
        OdbArrayList<ClassAttributeInfo> attributesToRemove = new OdbArrayList<ClassAttributeInfo>(10);
        OdbArrayList<ClassAttributeInfo> attributesToAdd = new OdbArrayList<ClassAttributeInfo>(10);
        int nbAttributes = this.attributes.size();
        for (int id = 0; id < nbAttributes; ++id) {
            cai1 = this.attributes.get(id);
            if (cai1 == null) continue;
            attributeName = cai1.getName();
            cai2 = newCI.getAttributeInfoFromId(cai1.getId());
            if (cai2 == null) {
                result.addCompatibleChange("Field '" + attributeName + "' (type=" + cai1.getFullClassname() + ") has been removed");
                if (!update) continue;
                attributesToRemove.add(cai1);
                continue;
            }
            if (ODBType.typesAreCompatible(cai1.getAttributeType(), cai2.getAttributeType())) continue;
            result.addIncompatibleChange("Type of Field '" + attributeName + "' has changed : old='" + cai1.getFullClassname() + "' - new='" + cai2.getFullClassname() + "'");
            isCompatible = false;
        }
        int nbNewAttributes = newCI.attributes.size();
        for (int id = 0; id < nbNewAttributes; ++id) {
            cai2 = newCI.attributes.get(id);
            if (cai2 == null) continue;
            attributeName = cai2.getName();
            cai1 = this.getAttributeInfoFromId(cai2.getId());
            if (cai1 != null) continue;
            result.addCompatibleChange("Field '" + attributeName + "' (type=" + cai2.getFullClassname() + ") has been added");
            if (!update) continue;
            cai2.setId(this.maxAttributeId + 1);
            ++this.maxAttributeId;
            attributesToAdd.add(cai2);
        }
        this.attributes.removeAll(attributesToRemove);
        this.attributes.addAll(attributesToAdd);
        this.fillAttributesMap();
        return result;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public ClassInfoIndex addIndexOn(String name, String[] indexFields, boolean acceptMultipleValuesForSameKey) {
        if (this.indexes == null) {
            this.indexes = new OdbArrayList<ClassInfoIndex>();
        }
        ClassInfoIndex cii = new ClassInfoIndex();
        cii.setClassInfoId(this.id);
        cii.setCreationDate(OdbTime.getCurrentTimeInMs());
        cii.setLastRebuild(cii.getCreationDate());
        cii.setName(name);
        cii.setStatus((byte)1);
        cii.setUnique(!acceptMultipleValuesForSameKey);
        int[] attributeIds = new int[indexFields.length];
        for (int i = 0; i < indexFields.length; ++i) {
            attributeIds[i] = this.getAttributeId(indexFields[i]);
            if (attributeIds[i] != -1) continue;
            throw new ODBRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getFullClassName()).addParameter(indexFields[i]));
        }
        cii.setAttributeIds(attributeIds);
        this.indexes.add(cii);
        return cii;
    }

    public void removeIndex(ClassInfoIndex cii) {
        this.indexes.remove(cii);
    }

    public int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.size();
    }

    public ClassInfoIndex getIndex(int index) {
        if (this.indexes == null || index >= this.indexes.size()) {
            throw new ODBRuntimeException(NeoDatisError.INDEX_NOT_FOUND.addParameter(this.getFullClassName()).addParameter(index));
        }
        return this.indexes.get(index);
    }

    public void setIndexes(IOdbList<ClassInfoIndex> indexes2) {
        this.indexes = indexes2;
    }

    public boolean hasCyclicReference() {
        return this.hasCyclicReference(new OdbHashMap<String, ClassInfo>());
    }

    private boolean hasCyclicReference(Map<String, ClassInfo> alreadyVisitedClasses) {
        ClassAttributeInfo cai = null;
        boolean hasCyclicRef = false;
        if (alreadyVisitedClasses.get(this.fullClassName) != null) {
            return true;
        }
        OdbHashMap<String, ClassInfo> localMap = new OdbHashMap();
        alreadyVisitedClasses.put(this.fullClassName, this);
        for (int i = 0; i < this.attributes.size(); ++i) {
            cai = this.getAttributeInfo(i);
            if (cai.isNative()) continue;
            localMap = new OdbHashMap<String, ClassInfo>(alreadyVisitedClasses);
            hasCyclicRef = cai.getClassInfo().hasCyclicReference(localMap);
            if (!hasCyclicRef) continue;
            return true;
        }
        return false;
    }

    public byte getClassCategory() {
        return this.classCategory;
    }

    public void setClassCategory(byte classInfoType) {
        this.classCategory = classInfoType;
    }

    public ObjectInfoHeader getLastObjectInfoHeader() {
        return this.lastObjectInfoHeader;
    }

    public void setLastObjectInfoHeader(ObjectInfoHeader lastObjectInfoHeader) {
        this.lastObjectInfoHeader = lastObjectInfoHeader;
    }

    public CIZoneInfo getUncommittedZoneInfo() {
        return this.uncommitted;
    }

    public long getNumberOfObjects() {
        return this.committed.getNbObjects() + this.uncommitted.getNbObjects();
    }

    public CommittedCIZoneInfo getOriginalZoneInfo() {
        return this.original;
    }

    public boolean isSystemClass() {
        return this.classCategory == 1;
    }

    public ClassInfoIndex getIndexWithName(String name) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!cii.getName().equals(name)) continue;
            return cii;
        }
        return null;
    }

    public ClassInfoIndex getIndexForAttributeId(int attributeId) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (cii.getAttributeIds().length != 1 || cii.getAttributeId(0) != attributeId) continue;
            return cii;
        }
        return null;
    }

    public ClassInfoIndex getIndexForAttributeIds(int[] attributeIds) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!cii.matchAttributeIds(attributeIds)) continue;
            return cii;
        }
        return null;
    }

    public String[] getAttributeNames(int[] attributeIds) {
        int nbIds = attributeIds.length;
        String[] names = new String[nbIds];
        for (int i = 0; i < nbIds; ++i) {
            names[i] = this.getAttributeInfoFromId(attributeIds[i]).getName();
        }
        return names;
    }

    public List<String> getAttributeNamesAsList(int[] attributeIds) {
        int nbIds = attributeIds.length;
        ArrayList<String> names = new ArrayList<String>(attributeIds.length);
        for (int i = 0; i < nbIds; ++i) {
            names.add(this.getAttributeInfoFromId(attributeIds[i]).getName());
        }
        return names;
    }

    public IOdbList<ClassInfoIndex> getIndexes() {
        if (this.indexes == null) {
            return new OdbArrayList<ClassInfoIndex>();
        }
        return this.indexes;
    }

    public void removeAttribute(ClassAttributeInfo cai) {
        this.attributes.remove(cai);
        this.attributesByName.remove(cai.getName());
    }

    public void addAttribute(ClassAttributeInfo cai) {
        cai.setId(this.maxAttributeId++);
        this.attributes.add(cai);
        this.attributesByName.put(cai.getName(), cai);
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }

    public void addHistory(Object o) {
        if (this.history == null) {
            this.history = new OdbArrayList<Object>(1);
        }
        this.history.add(o);
    }

    public IOdbList<? extends Object> getHistory() {
        return this.history;
    }

    public boolean hasIndex(String indexName) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return false;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!indexName.equals(cii.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndex() {
        return this.indexes != null && !this.indexes.isEmpty();
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public ClassInfo duplicate(boolean onlyData) {
        ClassInfo ci = new ClassInfo(this.fullClassName);
        ci.extraInfo = this.extraInfo;
        ci.setAttributes(this.attributes);
        ci.setClassCategory(this.classCategory);
        ci.setMaxAttributeId(this.maxAttributeId);
        if (onlyData) {
            return ci;
        }
        ci.setAttributesDefinitionPosition(this.attributesDefinitionPosition);
        ci.setBlockSize(this.blockSize);
        ci.setExtraInfo(this.extraInfo);
        ci.setId(this.id);
        ci.setPreviousClassOID(this.previousClassOID);
        ci.setNextClassOID(this.nextClassOID);
        ci.setLastObjectInfoHeader(this.lastObjectInfoHeader);
        ci.setPosition(this.position);
        ci.setIndexes(this.indexes);
        return ci;
    }
}

