/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.connect.ConnectConfig;
import org.neodatis.odb.gui.connect.Connection;
import org.neodatis.odb.gui.connect.ConnectionPanel;
import org.neodatis.odb.gui.connect.LocalConnection;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.ILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnectionPanel
extends ConnectionPanel
implements ActionListener {
    private JTextField tfFileName;
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private JComboBox cbConnections;
    private ILogger logger;

    public LocalConnectionPanel(ILogger logger) {
        this.logger = logger;
        this.initGUI();
    }

    private void initGUI() {
        this.tfFileName = new JTextField(30);
        this.tfUserName = new JTextField(20);
        this.tfPassword = new JPasswordField(20);
        Vector<LocalConnection> v = null;
        try {
            v = new Vector<LocalConnection>(this.getRecentLocalConnections());
        }
        catch (Exception e) {
            String error = "Error while loading recent conections :" + e.getMessage();
            this.logger.error(error, e);
        }
        this.cbConnections = new JComboBox<LocalConnection>(v);
        this.cbConnections.setActionCommand("choose-recent");
        this.cbConnections.addActionListener(this);
        JButton btBrowseFile = new JButton(Messages.getString("..."));
        btBrowseFile.setActionCommand("browse-file");
        btBrowseFile.addActionListener(this);
        btBrowseFile.setPreferredSize(new Dimension((int)btBrowseFile.getPreferredSize().getWidth(), (int)this.tfFileName.getPreferredSize().getHeight()));
        JButton btChoose = new JButton(Messages.getString("Choose"));
        btChoose.setActionCommand("choose");
        btChoose.addActionListener(this);
        JPanel fieldsPanel = new JPanel(new BorderLayout(5, 5));
        JPanel labelsPanel = new JPanel(new GridLayout(4, 1));
        labelsPanel.add(new JLabel(Messages.getString("Recent")));
        labelsPanel.add(new JLabel(Messages.getString("File name")));
        labelsPanel.add(new JLabel(Messages.getString("User")));
        labelsPanel.add(new JLabel(Messages.getString("Password")));
        JPanel panel0 = new JPanel(new FlowLayout(0));
        panel0.add(this.cbConnections);
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this.tfFileName);
        panel1.add(btBrowseFile);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.tfUserName);
        JPanel panel3 = new JPanel(new FlowLayout(0));
        panel3.add(this.tfPassword);
        JPanel inputPanel = new JPanel(new GridLayout(4, 1));
        inputPanel.add(panel0);
        inputPanel.add(panel1);
        inputPanel.add(panel2);
        inputPanel.add(panel3);
        fieldsPanel.add((Component)labelsPanel, "West");
        fieldsPanel.add((Component)inputPanel, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)fieldsPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<LocalConnection> getRecentLocalConnections() throws Exception {
        ODB odb = null;
        try {
            odb = ODBFactory.open("connect-history.neodatis");
            CriteriaQuery query = new CriteriaQuery(LocalConnection.class);
            Objects<LocalConnection> objects = odb.getObjects(query);
            return objects;
        }
        finally {
            if (odb != null) {
                odb.close();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("browse-file".equals(command)) {
            try {
                this.browseFile();
            }
            catch (Exception e1) {
                this.logger.error("Error while browsing file:", e1);
            }
        }
        if ("choose-recent".equals(command)) {
            this.chooseRecent();
        }
    }

    private void chooseRecent() {
        LocalConnection lc = (LocalConnection)this.cbConnections.getSelectedItem();
        this.tfFileName.setText(lc.getFileName());
        if (lc.getUser() != null) {
            this.tfUserName.setText(lc.getUser());
        }
    }

    @Override
    public boolean validateData() {
        if (this.tfFileName.getText().length() == 0) {
            this.logger.error("Please inform the file name");
            this.tfFileName.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public Connection getConnection() throws Exception {
        LocalConnection lc = new LocalConnection();
        lc.setDate(new Date());
        lc.setFileName(this.tfFileName.getText());
        if (this.tfUserName.getText().length() > 0) {
            lc.setUser(this.tfUserName.getText());
            lc.setPassword(this.tfPassword.getText());
        }
        if (!this.existConnection(this.tfFileName.getText(), this.tfUserName.getName())) {
            this.saveConnection(lc);
        }
        this.logger.info("connecting to " + lc);
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConnection(Connection connection) throws Exception {
        ODB odb = null;
        try {
            odb = ODBFactory.open("connect-history.neodatis");
            odb.store(connection);
            Objects l = odb.getObjects(ConnectConfig.class);
            ConnectConfig cc = null;
            LocalConnection lc = (LocalConnection)connection;
            File f = new File(lc.getFileName());
            if (l.isEmpty()) {
                cc = new ConnectConfig();
                cc.setLastDirectory(f.getPath());
            } else {
                cc = (ConnectConfig)l.getFirst();
                cc.setLastDirectory(f.getPath());
            }
            odb.store(cc);
        }
        finally {
            if (odb != null) {
                odb.close();
            }
        }
    }

    private void browseFile() throws Exception {
        String lastDirectory = this.getLastDirectory();
        JFileChooser chooser = null;
        if (lastDirectory != null) {
            chooser = new JFileChooser(lastDirectory);
        } else {
            String userDir = System.getProperty("user.dir");
            chooser = new JFileChooser(userDir);
        }
        int returnValue = chooser.showOpenDialog(this);
        if (returnValue == 0) {
            File file = chooser.getSelectedFile();
            this.tfFileName.setText(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existConnection(String fileName, String user) throws Exception {
        ODB odb = null;
        try {
            odb = ODBFactory.open("connect-history.neodatis");
            CriteriaQuery query = new CriteriaQuery(LocalConnection.class, (ICriterion)Where.and().add(Where.equal("fileName", fileName)).add(Where.equal("user", user)));
            boolean bl = !odb.getObjects(query).isEmpty();
            return bl;
        }
        finally {
            if (odb != null) {
                odb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastDirectory() throws Exception {
        ODB odb = null;
        try {
            odb = ODBFactory.open("connect-history.neodatis");
            Objects l = odb.getObjects(ConnectConfig.class);
            if (l.isEmpty()) {
                String string = null;
                return string;
            }
            ConnectConfig cc = (ConnectConfig)l.getFirst();
            String string = cc.getLastDirectory();
            return string;
        }
        finally {
            if (odb != null) {
                odb.close();
            }
        }
    }

    public static void main(String[] args) {
        LoggerPanel loggerPanel = new LoggerPanel();
        LocalConnectionPanel lcp = new LocalConnectionPanel(loggerPanel);
        JFrame f = new JFrame("Test LocalConnectionPanel");
        f.getContentPane().add(lcp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        JFrame f2 = new JFrame("Test LocalConnectionPanel");
        f2.getContentPane().add(loggerPanel);
        f2.setDefaultCloseOperation(3);
        f2.pack();
        f2.setVisible(true);
    }
}

