/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.hierarchy;

import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.gui.objectbrowser.hierarchy.ArrayWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.CollectionWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.MapElementWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.MapKeyWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.MapValueWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.MapWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.NativeAttributeValueWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.NonNativeObjectInfoWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.StringWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.Wrapper;

public class ObjectBrowserModel
extends DefaultTreeModel {
    private ClassInfo ci;
    private List objectValues;

    public ObjectBrowserModel(ClassInfo ci, List objectValues, TreeNode node) {
        super(node);
        this.ci = ci;
        this.objectValues = objectValues;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            Object o = this.objectValues.get(index);
            return this.manageRepresentation(o);
        }
        if (parent instanceof NonNativeObjectInfoWrapper) {
            NonNativeObjectInfoWrapper nnaiw = (NonNativeObjectInfoWrapper)parent;
            NonNativeObjectInfo nnoi = nnaiw.getNnoi();
            ClassAttributeInfo cai = nnaiw.getNnoi().getClassInfo().getAttributeInfo(index);
            String attributeName = cai.getName();
            AbstractObjectInfo value = nnaiw.getNnoi().getAttributeValues()[index];
            if (value instanceof NonNativeNullObjectInfo) {
                return new NonNativeObjectInfoWrapper(attributeName, (NonNativeObjectInfo)value);
            }
            if (cai.getAttributeType().isNative()) {
                NativeObjectInfo noi = null;
                try {
                    noi = (NativeObjectInfo)value;
                }
                catch (Exception e) {
                    noi = new AtomicNativeObjectInfo((Object)("Error:" + e.getMessage()), 210);
                    System.out.println(noi.getObject());
                }
                if (cai.getAttributeType().isCollection() && !noi.isNull()) {
                    return new CollectionWrapper(nnoi, attributeName, (CollectionObjectInfo)value);
                }
                if (cai.getAttributeType().isMap() && !noi.isNull()) {
                    return new MapWrapper(nnoi, attributeName, (MapObjectInfo)value);
                }
                if (cai.getAttributeType().isArray() && !noi.isNull()) {
                    return new ArrayWrapper(nnoi, attributeName, (ArrayObjectInfo)value);
                }
                return new NativeAttributeValueWrapper(nnoi, attributeName, value, nnaiw.getNnoi().getHeader().getAttributeIdentificationFromId(index + 1));
            }
            if (value instanceof NonNativeObjectInfo) {
                return new NonNativeObjectInfoWrapper(attributeName, (NonNativeObjectInfo)nnaiw.getNnoi().getAttributeValues()[index]);
            }
            return value.getClass().getName();
        }
        if (parent instanceof CollectionWrapper) {
            CollectionWrapper cw = (CollectionWrapper)parent;
            Iterator iterator = cw.getCollection().iterator();
            Object element = null;
            for (int i = 0; i <= index && iterator.hasNext(); ++i) {
                element = iterator.next();
            }
            return this.manageRepresentation(element);
        }
        if (parent instanceof ArrayWrapper) {
            ArrayWrapper aw = (ArrayWrapper)parent;
            Object element = null;
            try {
                Object[] a = (Object[])aw.getArray();
                element = a[index];
                System.out.println("Getting array element for index " + index);
                Object o = this.manageRepresentation(element);
                return o;
            }
            catch (Exception e) {
                return new StringWrapper("Null");
            }
        }
        if (parent instanceof MapWrapper) {
            MapWrapper mw = (MapWrapper)parent;
            Iterator iterator = mw.getMap().keySet().iterator();
            Object keyElement = null;
            Object valueElement = null;
            for (int i = 0; i <= index && iterator.hasNext(); ++i) {
                keyElement = iterator.next();
            }
            valueElement = mw.getMap().get(keyElement);
            return new MapElementWrapper(keyElement, valueElement);
        }
        if (parent instanceof MapElementWrapper) {
            MapElementWrapper mew = (MapElementWrapper)parent;
            if (index == 0) {
                return new MapKeyWrapper(mew.getKeyAoi());
            }
            return new MapValueWrapper(mew.getValueAoi());
        }
        if (parent instanceof MapKeyWrapper) {
            MapKeyWrapper mkw = (MapKeyWrapper)parent;
            return this.manageRepresentation(mkw.getAoi());
        }
        if (parent instanceof MapValueWrapper) {
            MapValueWrapper mvw = (MapValueWrapper)parent;
            return this.manageRepresentation(mvw.getAoi());
        }
        return "unknown";
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            return this.objectValues.size();
        }
        if (parent instanceof NonNativeObjectInfoWrapper) {
            NonNativeObjectInfoWrapper nnaiw = (NonNativeObjectInfoWrapper)parent;
            AbstractObjectInfo[] aois = nnaiw.getNnoi().getAttributeValues();
            if (aois != null) {
                return aois.length;
            }
            return 0;
        }
        if (parent instanceof CollectionWrapper) {
            CollectionWrapper cw = (CollectionWrapper)parent;
            return cw.getCollection().size();
        }
        if (parent instanceof MapWrapper) {
            MapWrapper mw = (MapWrapper)parent;
            return mw.getMap().size();
        }
        if (parent instanceof ArrayWrapper) {
            ArrayWrapper aw = (ArrayWrapper)parent;
            int size = aw.getArraySize();
            return size;
        }
        if (parent instanceof MapElementWrapper) {
            return 2;
        }
        if (parent instanceof MapKeyWrapper) {
            return 1;
        }
        if (parent instanceof MapValueWrapper) {
            return 1;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node instanceof String || node instanceof NativeObjectInfo;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DefaultMutableTreeNode) {
            return this.objectValues.indexOf(child);
        }
        if (parent instanceof NonNativeObjectInfoWrapper) {
            NonNativeObjectInfoWrapper nnaiw = (NonNativeObjectInfoWrapper)parent;
            Wrapper childWrapper = (Wrapper)child;
            return nnaiw.getNnoi().getAttributeId(childWrapper.getObject());
        }
        return 0;
    }

    public Object manageRepresentation(Object object) {
        if (object == null || object instanceof NonNativeNullObjectInfo || object instanceof NullNativeObjectInfo) {
            return new StringWrapper("Null");
        }
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            return new NonNativeObjectInfoWrapper("oid=" + nnoi.getOid(), nnoi);
        }
        if (object instanceof NativeObjectInfo) {
            NativeObjectInfo noi = (NativeObjectInfo)object;
            Object o = noi.getObject();
            String s = "object is null";
            if (o != null) {
                s = new String(o.toString() + " (type=" + o.getClass().getName() + ")");
            }
            System.out.println("manageRepresentation returning string " + s);
            return new StringWrapper(s);
        }
        System.out.println("manageRepresentation returning object " + object);
        return object;
    }

    public void refresh(TreePath tp) {
        this.reload();
        Object[] tps = new TreePath[]{tp};
        this.fireTreeNodesRemoved(this.getRoot(), tps, null, null);
    }
}

