/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.neodatis.odb.core.server.message.GetSessionsMessage;
import org.neodatis.odb.core.server.message.GetSessionsMessageResponse;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.tool.GuiUtil;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ServerAdmin;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbString;

public class SessionMonitorPanel
extends JPanel
implements ActionListener {
    public static final SimpleDateFormat sdt = new SimpleDateFormat("HH:mm:ss");
    private JButton btRefresh;
    private JTextArea textArea;
    private ServerAdmin serverAdmin;

    public SessionMonitorPanel(String host, int port) {
        this.serverAdmin = new ServerAdmin(host, port);
        this.initGUI();
    }

    private void initGUI() {
        GuiUtil.setDefaultFont();
        this.btRefresh = new JButton(Messages.getString("Update"));
        this.btRefresh.setActionCommand("refresh");
        this.btRefresh.addActionListener(this);
        this.textArea = new JTextArea(20, 50);
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        headerPanel.add(new JLabel(this.serverAdmin.getHost() + ":" + this.serverAdmin.getPort()));
        headerPanel.add(this.btRefresh);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)headerPanel, "North");
        this.add((Component)new JScrollPane(this.textArea), "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String action = actionEvent.getActionCommand();
        if ("refresh".equals(action)) {
            this.refresh();
        }
    }

    private void refresh() {
        GetSessionsMessage message = new GetSessionsMessage();
        try {
            GetSessionsMessageResponse rmessage = (GetSessionsMessageResponse)this.serverAdmin.sendMessage(message);
            StringBuffer buffer = new StringBuffer();
            buffer.append("Last update : ").append(sdt.format(new Date())).append("\n");
            if (rmessage.hasError()) {
                buffer.append(rmessage.getError());
            } else if (rmessage.getSessions() == null) {
                buffer.append("\nSessions were not retrieved!");
            } else if (rmessage.getSessions().isEmpty()) {
                buffer.append("\nno session!");
            } else {
                buffer.append("Number of sessions : ").append(rmessage.getSessions().size()).append("\n\n");
                buffer.append("\n").append(DisplayUtility.listToString(rmessage.getSessions()));
            }
            this.textArea.setText(buffer.toString());
        }
        catch (Exception e) {
            String msg = "Error while getting sessions status " + OdbString.exceptionToString(e, false);
            this.textArea.setText(msg);
        }
    }
}

