/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.btree;

import org.neodatis.btree.BTreeError;
import org.neodatis.btree.BTreeIteratorMultipleValuesPerKey;
import org.neodatis.btree.IBTree;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;

public class LazyODBBTreeIteratorMultiple
extends BTreeIteratorMultipleValuesPerKey {
    private IStorageEngine storageEngine;
    private boolean returnObjects;

    public LazyODBBTreeIteratorMultiple(IBTree tree, OrderByConstants orderByType, IStorageEngine storageEngine, boolean returnObjects) {
        super(tree, orderByType);
        this.storageEngine = storageEngine;
        this.returnObjects = returnObjects;
    }

    public Object next() {
        OID oid = (OID)super.next();
        try {
            return this.loadObject(oid);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(BTreeError.LAZY_LOADING_NODE.addParameter(oid), (Throwable)e);
        }
    }

    private Object loadObject(OID oid) throws Exception {
        NonNativeObjectInfo nnoi = this.storageEngine.getObjectReader().readNonNativeObjectInfoFromOid(null, oid, true, this.returnObjects);
        if (this.returnObjects) {
            Object o = nnoi.getObject();
            if (o != null) {
                return o;
            }
            return this.storageEngine.getObjectReader().buildOneInstance(nnoi);
        }
        return nnoi;
    }
}

