/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.util.Iterator;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectValues;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.query.execution.IQueryFieldAction;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.odb.impl.core.query.list.values.DefaultObjectValues;
import org.neodatis.odb.impl.core.query.list.values.InMemoryBTreeCollectionForValues;
import org.neodatis.odb.impl.core.query.list.values.SimpleListForValues;
import org.neodatis.tool.wrappers.OdbComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesQueryResultAction
implements IMatchingObjectAction {
    private IValuesQuery query;
    private IQueryFieldAction[] queryFieldActions;
    private long nbObjects;
    private Values result;
    private boolean queryHasOrderBy;
    protected IInstanceBuilder instanceBuilder;
    protected ClassInfo classInfo;
    private int returnArraySize;
    private IStorageEngine engine;

    public ValuesQueryResultAction(IValuesQuery query, IStorageEngine storageEngine, IInstanceBuilder instanceBuilder) {
        this.engine = storageEngine;
        this.query = query;
        this.queryHasOrderBy = query.hasOrderBy();
        this.instanceBuilder = instanceBuilder;
        this.returnArraySize = query.getObjectActions().size();
        Iterator iterator = query.getObjectActions().iterator();
        IQueryFieldAction qfa = null;
        this.queryFieldActions = new IQueryFieldAction[this.returnArraySize];
        int i = 0;
        while (iterator.hasNext()) {
            qfa = (IQueryFieldAction)iterator.next();
            this.queryFieldActions[i] = qfa.copy();
            this.queryFieldActions[i].setReturnInstance(query.returnInstance());
            this.queryFieldActions[i].setInstanceBuilder(instanceBuilder);
            ++i;
        }
    }

    @Override
    public void objectMatch(OID oid, OdbComparable orderByKey) {
    }

    @Override
    public void objectMatch(OID oid, Object object, OdbComparable orderByKey) {
        if (this.query.isMultiRow()) {
            ObjectValues values = this.convertObject((AttributeValuesMap)object);
            if (this.queryHasOrderBy) {
                this.result.addWithKey(orderByKey, values);
            } else {
                this.result.add(values);
            }
        } else {
            this.compute((AttributeValuesMap)object);
        }
    }

    private void compute(AttributeValuesMap values) {
        for (int i = 0; i < this.returnArraySize; ++i) {
            this.queryFieldActions[i].execute(values.getObjectInfoHeader().getOid(), values);
        }
    }

    private ObjectValues convertObject(AttributeValuesMap values) {
        DefaultObjectValues dov = new DefaultObjectValues(this.returnArraySize);
        IQueryFieldAction qfa = null;
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.execute(values.getObjectInfoHeader().getOid(), values);
            Object o = qfa.getValue();
            if (o != null && o instanceof OID) {
                OdbObjectOID oid = (OdbObjectOID)o;
                o = this.engine.getObjectFromOid(oid);
            }
            dov.set(i, qfa.getAlias(), o);
        }
        return dov;
    }

    @Override
    public void start() {
        this.result = this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollectionForValues((int)this.nbObjects, this.query.getOrderByType()) : new SimpleListForValues((int)this.nbObjects);
        IQueryFieldAction qfa = null;
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.start();
        }
    }

    @Override
    public void end() {
        IQueryFieldAction qfa = null;
        DefaultObjectValues dov = null;
        if (!this.query.isMultiRow()) {
            dov = new DefaultObjectValues(this.returnArraySize);
        }
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.end();
            if (this.query.isMultiRow()) continue;
            Object o = qfa.getValue();
            if (o != null && o instanceof OID) {
                OdbObjectOID oid = (OdbObjectOID)o;
                o = this.engine.getObjectFromOid(oid);
            }
            dov.set(i, qfa.getAlias(), o);
        }
        if (!this.query.isMultiRow()) {
            this.result.add(dov);
        }
    }

    public Values getValues() {
        return this.result;
    }

    @Override
    public <T> Objects<T> getObjects() {
        return this.result;
    }
}

