/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.ClassRepresentation;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer1.introspector.IIntrospectionCallback;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.ICommitListener;
import org.neodatis.odb.core.layers.layer3.IOSocketParameter;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.lookup.LookupFactory;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.server.layers.layer1.IClientObjectIntrospector;
import org.neodatis.odb.core.server.layers.layer2.meta.ClientNonNativeObjectInfo;
import org.neodatis.odb.core.server.layers.layer3.engine.IMessageStreamer;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.odb.core.server.message.AddIndexMessage;
import org.neodatis.odb.core.server.message.AddIndexMessageResponse;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessage;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessageResponse;
import org.neodatis.odb.core.server.message.CloseMessage;
import org.neodatis.odb.core.server.message.CloseMessageResponse;
import org.neodatis.odb.core.server.message.CommitMessage;
import org.neodatis.odb.core.server.message.CommitMessageResponse;
import org.neodatis.odb.core.server.message.ConnectMessage;
import org.neodatis.odb.core.server.message.ConnectMessageResponse;
import org.neodatis.odb.core.server.message.CountMessage;
import org.neodatis.odb.core.server.message.CountMessageResponse;
import org.neodatis.odb.core.server.message.DeleteIndexMessage;
import org.neodatis.odb.core.server.message.DeleteIndexMessageResponse;
import org.neodatis.odb.core.server.message.DeleteObjectMessage;
import org.neodatis.odb.core.server.message.DeleteObjectMessageResponse;
import org.neodatis.odb.core.server.message.GetMessage;
import org.neodatis.odb.core.server.message.GetMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessage;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessage;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectValuesMessage;
import org.neodatis.odb.core.server.message.GetObjectValuesMessageResponse;
import org.neodatis.odb.core.server.message.NewClassInfoListMessage;
import org.neodatis.odb.core.server.message.NewClassInfoListMessageResponse;
import org.neodatis.odb.core.server.message.RebuildIndexMessage;
import org.neodatis.odb.core.server.message.RebuildIndexMessageResponse;
import org.neodatis.odb.core.server.message.RollbackMessage;
import org.neodatis.odb.core.server.message.RollbackMessageResponse;
import org.neodatis.odb.core.server.message.StoreMessage;
import org.neodatis.odb.core.server.message.StoreMessageResponse;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.layers.layer1.introspector.DefaultInstrospectionCallbackForStore;
import org.neodatis.odb.impl.core.layers.layer1.introspector.GetDependentObjectIntrospectingCallback;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineAdapter;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.list.objects.InMemoryBTreeCollection;
import org.neodatis.odb.impl.core.server.ReturnValue;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ChangedValueProcessor;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ReturnValueProcessor;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.odb.impl.main.DefaultClassRepresentation;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.net.NeoDatisIpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStorageEngine
extends StorageEngineAdapter {
    public static final String LOG_ID = "ClientStorageEngine";
    private Socket socket;
    public static int nbcalls = 0;
    public static int nbdiffcalls = 0;
    protected IMessageStreamer messageStreamer;
    protected String connectionId;
    private MetaModel localMetaModel;
    private IClientObjectIntrospector objectIntrospector;
    private IInstanceBuilder instanceBuilder;
    private IClassIntrospector classIntrospector;
    private ISession session;
    private boolean isRollbacked;
    protected IOSocketParameter parameters;
    protected ICoreProvider provider;
    protected IIntrospectionCallback introspectionCallbackForInsert;
    protected IIntrospectionCallback introspectionCallbackForUpdate;
    protected List<ReturnValueProcessor> returnValueProcessors;

    protected ClientStorageEngine(String hostName, int port, String baseId) {
        this(new IOSocketParameter(hostName, port, baseId, 1, null, null));
    }

    protected ClientStorageEngine(String hostName, int port, String baseId, String user, String password) {
        this(new IOSocketParameter(hostName, port, baseId, 1, user, password));
    }

    public ClientStorageEngine(IOSocketParameter parameters) {
        this.init(parameters);
    }

    @Override
    public ISession buildDefaultSession() {
        this.session = OdbConfiguration.getCoreProvider().getClientSession(this);
        return this.session;
    }

    private void init(IOSocketParameter parameter) {
        this.provider = OdbConfiguration.getCoreProvider();
        this.parameters = parameter;
        ICoreProvider provider = OdbConfiguration.getCoreProvider();
        this.classIntrospector = provider.getClassIntrospector();
        this.buildDefaultSession();
        this.initODBConnection();
        provider.getClientServerSessionManager().addSession(this.session);
        this.objectIntrospector = (IClientObjectIntrospector)this.buildObjectIntrospector();
        this.instanceBuilder = provider.getLocalInstanceBuilder(this);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("ODBRemote:Connected to " + this.parameters.getDestinationHost() + ":" + this.parameters.getPort() + " - connection id=" + this.connectionId);
        }
        this.triggerManager = OdbConfiguration.getCoreProvider().getLocalTriggerManager(this);
        this.introspectionCallbackForInsert = new DefaultInstrospectionCallbackForStore(this, this.triggerManager, false);
        this.introspectionCallbackForUpdate = new DefaultInstrospectionCallbackForStore(this, this.triggerManager, true);
        this.returnValueProcessors = new ArrayList<ReturnValueProcessor>();
        this.returnValueProcessors.add(new ChangedValueProcessor(this.classIntrospector));
    }

    protected void initMessageStreamer() {
        this.messageStreamer = OdbConfiguration.getCoreProvider().getMessageStreamer(this.parameters.getDestinationHost(), this.parameters.getPort(), this.parameters.getIdentification());
    }

    protected void initODBConnection() {
        String localhost = null;
        localhost = NeoDatisIpAddress.get("localhost");
        localhost = this.transformIfV6(localhost);
        this.initMessageStreamer();
        ConnectMessage msg = new ConnectMessage(this.parameters.getBaseIdentifier(), localhost, this.parameters.getUserName(), this.parameters.getPassword());
        ConnectMessageResponse rmsg = (ConnectMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting a connection from ODB Server").addParameter(rmsg.getError()));
        }
        this.connectionId = rmsg.getConnectionId();
        this.session.setMetaModel(rmsg.getMetaModel());
        this.session.setId(this.connectionId);
        this.setDatabaseId(rmsg.getTransactionId().getDatabaseId());
        this.setCurrentTransactionId(rmsg.getTransactionId());
        if (OdbConfiguration.checkModelCompatibility()) {
            Map<String, ClassInfo> currentCIs = this.classIntrospector.instrospect(rmsg.getMetaModel().getAllClasses());
            CheckMetaModelCompatibilityMessage compatibilityMessage = new CheckMetaModelCompatibilityMessage(this.parameters.getBaseIdentifier(), rmsg.getConnectionId(), currentCIs);
            CheckMetaModelCompatibilityMessageResponse rmsg2 = (CheckMetaModelCompatibilityMessageResponse)this.sendMessage(compatibilityMessage);
            if (rmsg2.getResult().isModelHasBeenUpdated()) {
                DLogger.info("Meta-model has changed:");
                DLogger.info(rmsg2.getResult().getResults());
                this.session.setMetaModel(rmsg2.getUpdatedMetaModel());
            }
        }
    }

    private String transformIfV6(String host) {
        return OdbString.replaceToken(host, ":", ".");
    }

    public Message sendMessage(Message msg) {
        Message rmsg;
        try {
            this.messageStreamer.write(msg);
            rmsg = this.messageStreamer.read();
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_NET_ERROR.addParameter(OdbString.exceptionToString(e, true)));
        }
        return rmsg;
    }

    @Override
    public void commit() {
        CommitMessage msg = new CommitMessage(this.parameters.getBaseIdentifier(), this.connectionId);
        CommitMessageResponse rmsg = (CommitMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while committing database").addParameter(rmsg.getError()));
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getIdentification()));
        }
        CloseMessage msg = new CloseMessage(this.parameters.getBaseIdentifier(), this.connectionId);
        CloseMessageResponse rmsg = (CloseMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while closing database").addParameter(rmsg.getError()));
        }
        this.messageStreamer.close();
        this.isClosed = true;
        this.provider.removeLocalTriggerManager(this);
    }

    @Override
    public void rollback() {
        RollbackMessage msg = new RollbackMessage(this.parameters.getBaseIdentifier(), this.connectionId);
        RollbackMessageResponse rmsg = (RollbackMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while executing rollback").addParameter(rmsg.getError()));
        }
        this.isRollbacked = true;
    }

    @Override
    public OID store(Object object) {
        return this.store(StorageEngineConstant.NULL_OBJECT_ID, object);
    }

    @Override
    public synchronized OID store(OID oid, Object object) {
        return this.internalStore(oid, object, false);
    }

    public synchronized OID internalStore(OID oid, Object object, boolean forceUpdate) {
        StoreMessage msg;
        StoreMessageResponse rmsg;
        boolean isUpdate;
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        ICache cache = this.session.getCache();
        ClientNonNativeObjectInfo nnoi = this.objectToMetaRepresentation(object);
        boolean bl = isUpdate = nnoi.getOid() != null;
        if (nnoi.getOid() == StorageEngineConstant.NULL_OBJECT_ID) {
            nnoi.setOid(oid);
        }
        if ((rmsg = (StoreMessageResponse)this.sendMessage(msg = new StoreMessage(this.parameters.getBaseIdentifier(), this.connectionId, nnoi, this.convertToOIDArray(this.objectIntrospector.getClientOids())))).hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while storing object").addParameter(rmsg.getError()));
        }
        nnoi.setOid(rmsg.getOid());
        if (OdbConfiguration.reconnectObjectsToSession()) {
            ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification());
            crossSessionCache.addObject(object, rmsg.getOid());
        }
        this.session.getCache().addObject(rmsg.getOid(), object, nnoi.getHeader());
        this.objectIntrospector.synchronizeIds(rmsg.getClientIds(), rmsg.getServerIds());
        for (ReturnValue rv : rmsg.getReturnValues()) {
            for (ReturnValueProcessor rvp : this.returnValueProcessors) {
                try {
                    rvp.process(rv, cache.getObjectWithOid(rv.getOid()));
                }
                catch (Exception e) {
                    throw new ODBRuntimeException(NeoDatisError.ERROR_IN_RETURN_VALUE_PROCESSOR.addParameter(rvp.getClass().getName()).addParameter(rv.toString()), (Throwable)e);
                }
            }
        }
        if (rmsg.isNewObject()) {
            this.triggerManager.manageInsertTriggerAfter(nnoi.getClassInfo().getFullClassName(), object, nnoi.getOid());
        } else {
            this.triggerManager.manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), nnoi, object, nnoi.getOid());
        }
        return rmsg.getOid();
    }

    private OID[] convertToOIDArray(IOdbList<OID> localOids) {
        OID[] array = new OID[localOids.size()];
        Iterator iterator = localOids.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = (OID)iterator.next();
        }
        return array;
    }

    private ClientNonNativeObjectInfo objectToMetaRepresentation(Object object) {
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NULL_OBJECT);
        }
        if (object.getClass().isArray()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_ARRAY_DIRECTLY);
        }
        if (ODBType.isNative(object.getClass())) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NATIVE_OBJECT_DIRECTLY);
        }
        ClassInfo ci = null;
        String className = object.getClass().getName();
        if (this.session.getMetaModel().existClass(className)) {
            ci = this.session.getMetaModel().getClassInfo(className, true);
        } else {
            ClassInfoList ciList = this.classIntrospector.introspect(object.getClass(), true);
            this.addClasses(ciList);
            ci = ciList.getMainClassInfo();
        }
        boolean mustUpdate = false;
        OID oid = this.getSession(true).getCache().getOid(object, false);
        if (oid != null) {
            mustUpdate = true;
        }
        IIntrospectionCallback callback = this.introspectionCallbackForInsert;
        if (mustUpdate) {
            callback = this.introspectionCallbackForUpdate;
        }
        NonNativeObjectInfo nnoi = (NonNativeObjectInfo)this.objectIntrospector.getMetaRepresentation(object, ci, true, null, callback);
        if (mustUpdate) {
            nnoi.setOid(oid);
        }
        return (ClientNonNativeObjectInfo)nnoi;
    }

    @Override
    public ClassInfoList addClasses(ClassInfoList classInfoList) {
        NewClassInfoListMessage msg = new NewClassInfoListMessage(this.parameters.getBaseIdentifier(), this.connectionId, classInfoList);
        NewClassInfoListMessageResponse rmsg = (NewClassInfoListMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while adding  new Class Info list").addParameter(rmsg.getError()));
        }
        MetaModel metaModel = MetaModel.fromClassInfos(rmsg.getClassInfos());
        this.session.setMetaModel(metaModel);
        String mainClassName = classInfoList.getMainClassInfo().getFullClassName();
        classInfoList.setMainClassInfo(metaModel.getClassInfo(mainClassName, true));
        return classInfoList;
    }

    public <T> Objects<T> getObjects(Class clazz) {
        return this.getObjects(clazz, true);
    }

    public <T> Objects<T> getObjects(Class clazz, boolean inMemory) {
        return this.getObjects(clazz, inMemory, -1, -1);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        CriteriaQuery query = new CriteriaQuery(clazz);
        return this.getObjects(query, inMemory, startIndex, endIndex);
    }

    private <T> Objects<T> buildInstances(Objects<NonNativeObjectInfo> metaObjects) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Building instances for " + metaObjects.size() + " meta objects");
        }
        InMemoryBTreeCollection list = new InMemoryBTreeCollection(metaObjects.size(), OrderByConstants.ORDER_BY_ASC);
        Iterator iterator = metaObjects.iterator();
        Object o = null;
        NonNativeObjectInfo nnoi = null;
        int i = 0;
        while (iterator.hasNext()) {
            Object obj;
            nnoi = (NonNativeObjectInfo)iterator.next();
            o = obj = this.instanceBuilder.buildOneInstance(nnoi);
            list.add(o);
            ++i;
        }
        return list;
    }

    private Object buildOneInstance(NonNativeObjectInfo nnoi) {
        Object o = this.instanceBuilder.buildOneInstance(nnoi);
        return o;
    }

    @Override
    public long count(CriteriaQuery query) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        CountMessage msg = new CountMessage(this.parameters.getBaseIdentifier(), this.connectionId, query);
        CountMessageResponse rmsg = (CountMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while counting objects").addParameter(rmsg.getError()));
        }
        return rmsg.getNbObjects();
    }

    @Override
    public OID delete(Object object, boolean cascade) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        if (cascade) {
            throw new ODBRuntimeException(NeoDatisError.NOT_YET_SUPPORTED.addParameter("delete cascade in client server mode"));
        }
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_DELETE_NULL_OBJECT);
        }
        OID oid = this.getObjectId(object, false);
        if (oid == null && OdbConfiguration.reconnectObjectsToSession()) {
            oid = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).getOid(object);
        }
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE_FOR_DELETE.addParameter(object.getClass().getName()).addParameter(object));
        }
        this.internalDeleteObjectWithOid(oid, cascade);
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeObject(object);
        }
        return oid;
    }

    @Override
    public void deleteObjectWithOid(OID oid, boolean cascade) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        this.internalDeleteObjectWithOid(oid, cascade);
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeOid(oid);
        }
    }

    public void internalDeleteObjectWithOid(OID oid, boolean cascade) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        DeleteObjectMessage msg = new DeleteObjectMessage(this.parameters.getBaseIdentifier(), this.connectionId, oid, cascade);
        DeleteObjectMessageResponse rmsg = (DeleteObjectMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while deleting objects").addParameter(rmsg.getError()));
        }
        ICache cache = this.getSession(true).getCache();
        cache.markIdAsDeleted(oid);
        cache.removeObjectWithOid(oid);
    }

    public <T> Objects<T> getObjects(IQuery query) {
        return this.getObjects(query, true, -1, -1);
    }

    public <T> Objects<T> getObjects(IQuery query, boolean inMemory) {
        return this.getObjects(query, inMemory, -1, -1);
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        if (this.isRollbacked) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        GetMessage msg = new GetMessage(this.parameters.getBaseIdentifier(), this.connectionId, query, inMemory, startIndex, endIndex);
        GetMessageResponse rmsg = (GetMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting objects").addParameter(rmsg.getError()));
        }
        query.setExecutionPlan(rmsg.getPlan());
        return this.buildInstances(rmsg.getMetaObjects());
    }

    @Override
    public Values getValues(IValuesQuery query, int startIndex, int endIndex) {
        if (this.isRollbacked) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        GetObjectValuesMessage msg = new GetObjectValuesMessage(this.parameters.getBaseIdentifier(), this.connectionId, query, startIndex, endIndex);
        Message o = this.sendMessage(msg);
        GetObjectValuesMessageResponse rmsg = (GetObjectValuesMessageResponse)o;
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting object values").addParameter(rmsg.getError()));
        }
        Values values = rmsg.getValues();
        query.setExecutionPlan(rmsg.getPlan());
        LookupFactory.get(this.getSession(true).getId()).set("InstanceBuilder", this.instanceBuilder);
        return values;
    }

    @Override
    public OID getObjectId(Object object, boolean throwExceptionIfDoesNotExist) {
        ICrossSessionCache crossSessionCache;
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_RETURN_OID_OF_NULL_OBJECT);
        }
        if (OdbConfiguration.reconnectObjectsToSession() && (crossSessionCache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification())).getOid(object) != null) {
            return crossSessionCache.getOid(object);
        }
        OID oid = this.getSession(true).getCache().getOid(object, false);
        if (oid == null && throwExceptionIfDoesNotExist) {
            throw new ODBRuntimeException(NeoDatisError.UNKNOWN_OBJECT_TO_GET_OID.addParameter(object.toString()));
        }
        return oid;
    }

    @Override
    public Object getObjectFromOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_GET_OBJECT_FROM_NULL_OID);
        }
        GetObjectFromIdMessage message = new GetObjectFromIdMessage(this.parameters.getBaseIdentifier(), this.connectionId, oid);
        GetObjectFromIdMessageResponse rmsg = (GetObjectFromIdMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter("Error while getting object from id :" + rmsg.getError()));
        }
        return this.buildOneInstance(rmsg.getMetaRepresentation());
    }

    @Override
    public NonNativeObjectInfo getMetaObjectFromOid(OID oid) {
        GetObjectFromIdMessage message = new GetObjectFromIdMessage(this.parameters.getBaseIdentifier(), this.connectionId, oid);
        GetObjectFromIdMessageResponse rmsg = (GetObjectFromIdMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter("Error while getting object from id :" + rmsg.getError()));
        }
        return rmsg.getMetaRepresentation();
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean useCache) {
        GetObjectHeaderFromIdMessage message = new GetObjectHeaderFromIdMessage(this.parameters.getBaseIdentifier(), this.connectionId, oid, useCache);
        GetObjectHeaderFromIdMessageResponse rmsg = (GetObjectHeaderFromIdMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter("Error while getting object header from id :" + rmsg.getError()));
        }
        return rmsg.getObjectInfoHeader();
    }

    @Override
    public void defragmentTo(String newFileName) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.defragmentTo"));
    }

    public ClassRepresentation getClassRepresentation(Class clazz) {
        String fullClassName = clazz.getName();
        ClassInfo classInfo = this.session.getMetaModel().getClassInfo(fullClassName, false);
        if (classInfo == null) {
            ClassInfoList ciList = this.classIntrospector.introspect(clazz, false);
            classInfo = ciList.getMainClassInfo();
        }
        return new DefaultClassRepresentation(null, classInfo);
    }

    public void run() {
        if (!this.isClosed) {
            DLogger.debug("ODBFactory has not been closed and VM is exiting : force ODBFactory close");
            this.close();
        }
    }

    public void addUpdateTrigger(UpdateTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addUpdateTrigger"));
    }

    public void addInsertTrigger(InsertTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addInsertTrigger"));
    }

    public void addOidTrigger(OIDTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addOidTrigger"));
    }

    public void addDeleteTrigger(DeleteTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addDeleteTrigger"));
    }

    public void addSelectTrigger(SelectTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addSelectTrigger"));
    }

    @Override
    public IBaseIdentification getBaseIdentification() {
        return this.parameters;
    }

    @Override
    public <T> Objects<T> getObjectInfos(IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) {
        GetMessage msg = new GetMessage(this.parameters.getBaseIdentifier(), this.connectionId, query, inMemory, startIndex, endIndex);
        GetMessageResponse rmsg = (GetMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter("Error while getting objects :" + rmsg.getError()));
        }
        return rmsg.getMetaObjects();
    }

    public <T> Objects<T> getObjectInfos(String fullClassName, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) {
        return this.getObjectInfos(new CriteriaQuery(fullClassName), inMemory, startIndex, endIndex, returnOjects);
    }

    @Override
    public ISession getSession(boolean throwExceptionIfDoesNotExist) {
        return this.session;
    }

    @Override
    public OID updateObject(NonNativeObjectInfo nnoi2, boolean forceUpdate) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getBaseIdentifier()));
        }
        ClientNonNativeObjectInfo nnoi = (ClientNonNativeObjectInfo)nnoi2;
        StoreMessage msg = new StoreMessage(this.parameters.getBaseIdentifier(), this.connectionId, nnoi, this.convertToOIDArray(this.objectIntrospector.getClientOids()));
        StoreMessageResponse rmsg = (StoreMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while storing object").addParameter(rmsg.getError()));
        }
        nnoi.setOid(rmsg.getOid());
        this.objectIntrospector.synchronizeIds(rmsg.getClientIds(), rmsg.getServerIds());
        return rmsg.getOid();
    }

    @Override
    public OID writeObjectInfo(OID oid, NonNativeObjectInfo aoi, long position, boolean updatePointers) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("writeObjectInfo from meta representation not implemented in ClientStorageEngine"));
    }

    @Override
    public void addSession(ISession session, boolean readMetamodel) {
        this.session = session;
    }

    @Override
    public void addIndexOn(String className, String indexName, String[] indexFields, boolean verbose, boolean acceptMultipleValuesForSameKey) {
        AddIndexMessage message = new AddIndexMessage(this.parameters.getBaseIdentifier(), this.connectionId, className, indexName, indexFields, acceptMultipleValuesForSameKey, verbose);
        AddIndexMessageResponse rmsg = (AddIndexMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter(indexName + ":" + rmsg.getError()));
        }
    }

    @Override
    public void rebuildIndex(String className, String indexName, boolean verbose) {
        RebuildIndexMessage message = new RebuildIndexMessage(this.parameters.getBaseIdentifier(), this.connectionId, className, indexName, verbose);
        RebuildIndexMessageResponse rmsg = (RebuildIndexMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter(indexName + ":" + rmsg.getError()));
        }
    }

    @Override
    public void deleteIndex(String className, String indexName, boolean verbose) {
        DeleteIndexMessage message = new DeleteIndexMessage(this.parameters.getBaseIdentifier(), this.connectionId, className, indexName, verbose);
        DeleteIndexMessageResponse rmsg = (DeleteIndexMessageResponse)this.sendMessage(message);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_ERROR.addParameter(indexName + ":" + rmsg.getError()));
        }
    }

    @Override
    public void addCommitListener(ICommitListener commitListener) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.addCommitListener"));
    }

    @Override
    public IOdbList<ICommitListener> getCommitListeners() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.getCommitListeners"));
    }

    @Override
    public IRefactorManager getRefactorManager() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.getRefactorManager"));
    }

    @Override
    public void resetCommitListeners() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("ClientStorageEngine.resetCommitListeners"));
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public ITriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public void disconnect(Object object) {
        this.getSession(true).removeObjectFromCache(object);
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeObject(object);
        }
    }

    public void reconnect(Object object, OID oid) {
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.RECONNECT_CAN_RECONNECT_NULL_OBJECT);
        }
        if (!OdbConfiguration.reconnectObjectsToSession()) {
            throw new ODBRuntimeException(NeoDatisError.RECONNECT_ONLY_WITH_BYTE_CODE_AGENT_CONFIGURED);
        }
        ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification());
        ObjectInfoHeader oih = this.getObjectInfoHeaderFromOid(oid, true);
        this.getSession(true).addObjectToCache(oid, object, oih);
        GetDependentObjectIntrospectingCallback getObjectsCallback = new GetDependentObjectIntrospectingCallback();
        ClassInfo ci = this.getSession(true).getMetaModel().getClassInfoFromId(oih.getClassInfoId());
        this.objectIntrospector.getMetaRepresentation(object, ci, true, null, getObjectsCallback);
        Collection<Object> dependentObjects = getObjectsCallback.getObjects();
        for (Object o : dependentObjects) {
            if (o == null) continue;
            oid = crossSessionCache.getOid(o);
            if (oid == null) {
                throw new ODBRuntimeException(NeoDatisError.CROSS_SESSION_CACHE_NULL_OID_FOR_OBJECT.addParameter(o));
            }
            oih = this.getObjectInfoHeaderFromOid(oid, true);
            this.getSession(true).addObjectToCache(oid, o, oih);
        }
    }

    @Override
    public void addDeleteTrigger(Class clazz, DeleteTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("addDeleteTrigger not implemented in ClientStorageEngine"));
    }

    @Override
    public void addInsertTrigger(Class clazz, InsertTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("addInsertTrigger not implemented in ClientStorageEngine"));
    }

    @Override
    public void addOidTrigger(Class clazz, OIDTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("addOidTrigger not implemented in ClientStorageEngine"));
    }

    @Override
    public void addSelectTrigger(Class clazz, SelectTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("addSelectTrigger not implemented in ClientStorageEngine"));
    }

    @Override
    public void addUpdateTrigger(Class clazz, UpdateTrigger trigger) {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("addUpdateTrigger not implemented in ClientStorageEngine"));
    }

    @Override
    public IObjectIntrospector buildObjectIntrospector() {
        return this.provider.getClientObjectIntrospector(this, this.connectionId);
    }

    @Override
    public IObjectReader buildObjectReader() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("buildObjectReader not implemented in ClientStorageEngine"));
    }

    @Override
    public IObjectWriter buildObjectWriter() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("buildObjectWriter not implemented in ClientStorageEngine"));
    }

    @Override
    public ITriggerManager buildTriggerManager() {
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("buildTriggerManager not implemented in ClientStorageEngine"));
    }

    @Override
    public IObjectIntrospector getObjectIntrospector() {
        return this.objectIntrospector;
    }
}

