/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.connection.ConnectionManager;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
implements ISessionManager {
    public static final String LOG_ID = "SessionManager";
    protected Map<String, ISession> sessions = new OdbHashMap<String, ISession>();

    @Override
    public void init2() {
    }

    @Override
    public ISession getSession(String baseIdentification, boolean throwExceptionIfDoesNotExist) {
        String threadName = OdbThread.getCurrentThreadName();
        StringBuffer id = new StringBuffer(threadName).append(baseIdentification);
        ISession session = this.sessions.get(id.toString());
        if (session == null && throwExceptionIfDoesNotExist) {
            throw new ODBRuntimeException(NeoDatisError.SESSION_DOES_NOT_EXIST_FOR_CONNECTION.addParameter(threadName).addParameter(baseIdentification).addParameter(id));
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Getting session for base " + baseIdentification + " and thread " + threadName + " = " + id + " - sid=" + session.getId());
        }
        return session;
    }

    @Override
    public void addSession(ISession session) {
        String id = OdbThread.getCurrentThreadName() + session.getBaseIdentification();
        this.sessions.put(id, session);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Associating id = " + id + " to session " + session.getId());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = this.sessions.keySet().iterator();
        String sid = null;
        ISession session = null;
        while (iterator.hasNext()) {
            sid = iterator.next();
            session = this.sessions.get(sid);
            buffer.append(sid).append(":").append(session.toString()).append("\n");
        }
        return buffer.toString();
    }

    @Override
    public void removeSession(String baseIdentification) {
        String id = OdbThread.getCurrentThreadName() + baseIdentification;
        this.sessions.remove(id);
    }

    @Override
    public List<String> getSessionDescriptions(Map connectionManagers) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator<String> iterator = this.sessions.keySet().iterator();
        String sid = null;
        ISession session = null;
        ConnectionManager cm = null;
        StringBuffer buffer = null;
        while (iterator.hasNext()) {
            sid = iterator.next();
            session = this.sessions.get(sid);
            cm = (ConnectionManager)connectionManagers.get(session.getBaseIdentification());
            buffer = new StringBuffer("Session " + sid + " : " + session.toString());
            if (cm != null) {
                buffer.append(" - Number of connections=" + cm.getNbConnections());
                buffer.append(cm.getConnectionDescriptions());
            }
            l.add(buffer.toString());
        }
        return l;
    }

    @Override
    public long getNumberOfSessions() {
        return this.sessions.size();
    }
}

