/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class TmpCache
implements ITmpCache {
    protected Map<OID, Object[]> readingObjectInfo;
    protected ISession session;
    protected String name;

    public TmpCache(ISession session, String name) {
        this.init(session, name);
    }

    protected void init(ISession session, String name) {
        this.name = name;
        this.session = session;
        this.readingObjectInfo = new OdbHashMap<OID, Object[]>();
    }

    public boolean isReadingObjectInfoWithOid(OID oid) {
        if (oid == null) {
            return false;
        }
        return this.readingObjectInfo.containsKey(oid);
    }

    public NonNativeObjectInfo getReadingObjectInfoFromOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object[] values = this.readingObjectInfo.get(oid);
        if (values == null) {
            return null;
        }
        return (NonNativeObjectInfo)values[1];
    }

    public void startReadingObjectInfoWithOid(OID oid, NonNativeObjectInfo objectInfo) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object[] objects = this.readingObjectInfo.get(oid);
        if (objects == null) {
            Object[] values = new Object[]{new Short(1), objectInfo};
            this.readingObjectInfo.put(oid, values);
        } else {
            short currentReadCount = (Short)objects[0];
            objects[0] = new Short((short)(currentReadCount + 1));
        }
    }

    public void clearObjectInfos() {
        this.readingObjectInfo.clear();
    }

    public int size() {
        return this.readingObjectInfo.size();
    }
}

