/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.trigger;

import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.Trigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.server.trigger.DefaultObjectRepresentation;
import org.neodatis.odb.impl.main.ODBForTrigger;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTriggerManager
implements ITriggerManager {
    private static final String ALL_CLASS_TRIGGER = "__all_class_";
    private IStorageEngine storageEngine;
    protected Map<String, IOdbList<Trigger>> listOfUpdateTriggers;
    protected Map<String, IOdbList<Trigger>> listOfInsertTriggers;
    protected Map<String, IOdbList<Trigger>> listOfDeleteTriggers;
    protected Map<String, IOdbList<Trigger>> listOfSelectTriggers;
    protected Map<String, IOdbList<Trigger>> listOfOIdTriggers;

    public DefaultTriggerManager(IStorageEngine engine) {
        this.storageEngine = engine;
        this.init();
    }

    private void init() {
        this.listOfUpdateTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfDeleteTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfSelectTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfInsertTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfOIdTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfUpdateTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfUpdateTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfInsertTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfInsertTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addOidTriggerFor(String className, OIDTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfOIdTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfOIdTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfDeleteTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfDeleteTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfSelectTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfSelectTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public boolean hasDeleteTriggersFor(String classsName) {
        return this.listOfDeleteTriggers.containsKey(classsName) || this.listOfDeleteTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasOidTriggersFor(String classsName) {
        return this.listOfOIdTriggers.containsKey(classsName) || this.listOfOIdTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasInsertTriggersFor(String className) {
        return this.listOfInsertTriggers.containsKey(className) || this.listOfInsertTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasSelectTriggersFor(String className) {
        return this.listOfSelectTriggers.containsKey(className) || this.listOfSelectTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasUpdateTriggersFor(String className) {
        return this.listOfUpdateTriggers.containsKey(className) || this.listOfUpdateTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    public IOdbList<Trigger> getListOfDeleteTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfDeleteTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfDeleteTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    public IOdbList<Trigger> getListOfInsertTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfInsertTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfInsertTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    public IOdbList<Trigger> getListOfOidTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfOIdTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfOIdTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    public IOdbList<Trigger> getListOfSelectTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfSelectTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfSelectTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    public IOdbList<Trigger> getListOfUpdateTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfUpdateTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfUpdateTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public boolean manageInsertTriggerBefore(String className, Object object) {
        if (this.hasInsertTriggersFor(className)) {
            Object var3_3 = null;
            for (InsertTrigger insertTrigger : this.getListOfInsertTriggersFor(className)) {
                if (insertTrigger.getOdb() == null) {
                    insertTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    if (this.isNull(object)) continue;
                    insertTrigger.beforeInsert(this.transform(object));
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(insertTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageInsertTriggerAfter(String className, Object object, OID oid) {
        if (this.hasInsertTriggersFor(className)) {
            Object var4_4 = null;
            for (InsertTrigger insertTrigger : this.getListOfInsertTriggersFor(className)) {
                if (insertTrigger.getOdb() == null) {
                    insertTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    insertTrigger.afterInsert(this.transform(object), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(insertTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public boolean manageOidTrigger(NonNativeObjectInfo nnoi, OID oid) {
        String className = nnoi.getClassInfo().getFullClassName();
        if (this.hasOidTriggersFor(className)) {
            Object var4_4 = null;
            for (OIDTrigger oIDTrigger : this.getListOfOidTriggersFor(className)) {
                if (oIDTrigger.getOdb() == null) {
                    oIDTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    if (this.isNull(nnoi)) continue;
                    DefaultObjectRepresentation or = new DefaultObjectRepresentation(nnoi);
                    or.addObserver(this.storageEngine.getSession(true));
                    oIDTrigger.setOid(or, oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(oIDTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public boolean manageUpdateTriggerBefore(String className, NonNativeObjectInfo oldNnoi, Object newObject, OID oid) {
        if (this.hasUpdateTriggersFor(className)) {
            Object var5_5 = null;
            for (UpdateTrigger updateTrigger : this.getListOfUpdateTriggersFor(className)) {
                if (updateTrigger.getOdb() == null) {
                    updateTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    updateTrigger.beforeUpdate(new DefaultObjectRepresentation(oldNnoi), this.transform(newObject), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_UPDATE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(updateTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageUpdateTriggerAfter(String className, NonNativeObjectInfo oldNnoi, Object newObject, OID oid) {
        if (this.hasUpdateTriggersFor(className)) {
            Object var5_5 = null;
            for (UpdateTrigger updateTrigger : this.getListOfUpdateTriggersFor(className)) {
                if (updateTrigger.getOdb() == null) {
                    updateTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    updateTrigger.afterUpdate(new DefaultObjectRepresentation(oldNnoi), this.transform(newObject), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_UPDATE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(updateTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public boolean manageDeleteTriggerBefore(String className, Object object, OID oid) {
        if (this.hasDeleteTriggersFor(className)) {
            Object var4_4 = null;
            for (DeleteTrigger deleteTrigger : this.getListOfDeleteTriggersFor(className)) {
                if (deleteTrigger.getOdb() == null) {
                    deleteTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    deleteTrigger.beforeDelete(this.transform(object), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_DELETE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(deleteTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, true));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageDeleteTriggerAfter(String className, Object object, OID oid) {
        if (this.hasDeleteTriggersFor(className)) {
            Object var4_4 = null;
            for (DeleteTrigger deleteTrigger : this.getListOfDeleteTriggersFor(className)) {
                if (deleteTrigger.getOdb() == null) {
                    deleteTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                try {
                    deleteTrigger.afterDelete(this.transform(object), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_DELETE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(deleteTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!OdbConfiguration.displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public void manageSelectTriggerAfter(String className, Object object, OID oid) {
        if (this.hasSelectTriggersFor(className)) {
            Object var4_4 = null;
            for (SelectTrigger selectTrigger : this.getListOfSelectTriggersFor(className)) {
                if (selectTrigger.getOdb() == null) {
                    selectTrigger.setOdb(new ODBForTrigger(this.storageEngine));
                }
                if (this.isNull(object)) continue;
                selectTrigger.afterSelect(this.transform(object), oid);
            }
        }
    }

    protected boolean isNull(Object object) {
        return object == null;
    }

    @Override
    public Object transform(Object object) {
        return object;
    }

    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }
}

