/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dtd.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.ContentModelValidator;
import com.sun.org.apache.xerces.internal.xni.QName;

public class MixedContentModel
implements ContentModelValidator {
    private int fCount;
    private QName[] fChildren;
    private int[] fChildrenType;
    private boolean fOrdered;

    public MixedContentModel(QName[] children, int[] type, int offset, int length, boolean ordered) {
        this.fCount = length;
        this.fChildren = new QName[this.fCount];
        this.fChildrenType = new int[this.fCount];
        int i = 0;
        while (i < this.fCount) {
            this.fChildren[i] = new QName(children[offset + i]);
            this.fChildrenType[i] = type[offset + i];
            ++i;
        }
        this.fOrdered = ordered;
    }

    public int validate(QName[] children, int offset, int length) {
        if (this.fOrdered) {
            int inIndex = 0;
            int outIndex = 0;
            while (outIndex < length) {
                QName curChild = children[offset + outIndex];
                if (curChild.localpart != null) {
                    String uri;
                    int type = this.fChildrenType[inIndex];
                    if (type == 0 ? this.fChildren[inIndex].rawname != children[offset + outIndex].rawname : (type == 6 ? (uri = this.fChildren[inIndex].uri) != null && uri != children[outIndex].uri : (type == 8 ? children[outIndex].uri != null : type == 7 && this.fChildren[inIndex].uri == children[outIndex].uri))) {
                        return outIndex;
                    }
                    ++inIndex;
                }
                ++outIndex;
            }
        } else {
            int outIndex = 0;
            while (outIndex < length) {
                QName curChild = children[offset + outIndex];
                if (curChild.localpart != null) {
                    int inIndex = 0;
                    while (inIndex < this.fCount) {
                        String uri;
                        int type = this.fChildrenType[inIndex];
                        if (type == 0 ? curChild.rawname == this.fChildren[inIndex].rawname : (type == 6 ? (uri = this.fChildren[inIndex].uri) == null || uri == children[outIndex].uri : (type == 8 ? children[outIndex].uri == null : type == 7 && this.fChildren[inIndex].uri != children[outIndex].uri))) break;
                        ++inIndex;
                    }
                    if (inIndex == this.fCount) {
                        return outIndex;
                    }
                }
                ++outIndex;
            }
        }
        return -1;
    }
}

