/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class Vector_Object
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private static final Integer GENERIC = new Integer(1);
    private static final Integer BASICSTROKE = new Integer(2);
    private static final Integer BUFFERED_IMAGE = new Integer(3);
    private static final Integer GENERAL_PATH = new Integer(4);
    private static final Integer T1GLYPH = new Integer(5);
    private static final Integer TTGLYPH = new Integer(6);
    private static final Integer AREA = new Integer(7);
    private static final Integer RECT = new Integer(8);
    private static final Integer T3GLYPH = new Integer(9);
    private static final Integer TEXTUREDPAINT = new Integer(10);
    private Object[] items = new Object[this.max_size];
    private int checkPoint = -1;

    public Vector_Object() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }

    protected int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Object(int n) {
        this.max_size = n;
        this.items = new Object[this.max_size];
    }

    public final Object[] get() {
        return this.items;
    }

    public final Object pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(Object object) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = object;
        ++this.current_item;
    }

    public final boolean contains(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (!this.items[i].equals(object)) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final void addElement(Object object) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = object;
        ++this.current_item;
    }

    public final void setElementAt(Object object, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = object;
    }

    public final Object elementAt(int n) {
        if (n >= this.max_size) {
            return null;
        }
        return this.items[n];
    }

    public final void set(Object[] objectArray) {
        this.items = objectArray;
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.current_item - 1 - n);
            this.items[this.current_item - 1] = null;
        } else {
            this.items[0] = null;
        }
        --this.current_item;
    }

    private void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            Object[] objectArray = this.items;
            this.items = new Object[this.max_size];
            System.arraycopy(objectArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(new Integer(this.max_size));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < this.max_size; ++i) {
            Object object = this.items[i];
            if (object instanceof BasicStroke) {
                ++n;
                objectOutputStream.writeObject(BASICSTROKE);
                BasicStroke basicStroke = (BasicStroke)this.items[i];
                objectOutputStream.writeFloat(basicStroke.getLineWidth());
                objectOutputStream.writeInt(basicStroke.getEndCap());
                objectOutputStream.writeInt(basicStroke.getLineJoin());
                objectOutputStream.writeFloat(basicStroke.getMiterLimit());
                objectOutputStream.writeObject(basicStroke.getDashArray());
                objectOutputStream.writeFloat(basicStroke.getDashPhase());
                continue;
            }
            if (object instanceof Rectangle2D) {
                ++n;
                objectOutputStream.writeObject(RECT);
                Rectangle2D rectangle2D = (Rectangle2D)this.items[i];
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getX());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getY());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getWidth());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getHeight());
                continue;
            }
            if (object instanceof BufferedImage) {
                ++n2;
                objectOutputStream.writeObject(BUFFERED_IMAGE);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)object), "png", byteArrayOutputStream2);
                objectOutputStream.writeObject(byteArrayOutputStream2.toByteArray());
                continue;
            }
            if (object instanceof GeneralPath) {
                ++n4;
                objectOutputStream.writeObject(GENERAL_PATH);
                PathSerializer.serializePath(objectOutputStream, ((GeneralPath)this.items[i]).getPathIterator(new AffineTransform()));
                continue;
            }
            if (object instanceof T1Glyph) {
                ++n6;
                objectOutputStream.writeObject(T1GLYPH);
                ((T1Glyph)object).flushArea();
                objectOutputStream.writeObject(object);
                ((T1Glyph)object).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object instanceof TTGlyph) {
                ++n7;
                objectOutputStream.writeObject(TTGLYPH);
                ((TTGlyph)object).flushArea();
                objectOutputStream.writeObject(object);
                ((TTGlyph)object).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object instanceof T3Glyph) {
                ++n5;
                objectOutputStream.writeObject(T3GLYPH);
                ((T3Glyph)object).writePathsToStream(objectOutputStream);
                continue;
            }
            if (object instanceof PdfTexturePaint) {
                ++n3;
                objectOutputStream.writeObject(TEXTUREDPAINT);
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((PdfTexturePaint)object).getImage(), "png", byteArrayOutputStream3);
                objectOutputStream.writeObject(byteArrayOutputStream3.toByteArray());
                Rectangle2D rectangle2D = ((PdfTexturePaint)object).getAnchorRect();
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getX());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getY());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getWidth());
                objectOutputStream.writeDouble(rectangle2D.getBounds2D().getHeight());
                continue;
            }
            if (object instanceof Area) {
                ++n8;
                objectOutputStream.writeObject(AREA);
                Area area = (Area)this.items[i];
                PathIterator pathIterator = area.getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutputStream, pathIterator);
                continue;
            }
            if (object == null) {
                ++n10;
            } else {
                ++n9;
            }
            try {
                int n12 = byteArrayOutputStream.size();
                objectOutputStream.writeObject(GENERIC);
                objectOutputStream.writeObject(object);
                int n13 = byteArrayOutputStream.size();
                n11 += n13 - n12;
                continue;
            }
            catch (Exception exception) {
                System.err.println("nextObj = " + object);
                exception.printStackTrace();
            }
        }
        objectOutputStream.close();
    }

    public void restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        int n;
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.max_size = n = ((Integer)objectInputStream.readObject()).intValue();
        this.items = new Object[n];
        Object object = null;
        Integer n2 = null;
        for (int i = 0; i < n; ++i) {
            double d;
            n2 = (Integer)objectInputStream.readObject();
            if (n2.compareTo(BASICSTROKE) == 0) {
                float f = objectInputStream.readFloat();
                int n3 = objectInputStream.readInt();
                int n4 = objectInputStream.readInt();
                float f2 = objectInputStream.readFloat();
                float[] fArray = (float[])objectInputStream.readObject();
                float f3 = objectInputStream.readFloat();
                object = new BasicStroke(f, n3, n4, f2, fArray, f3);
            } else if (n2.compareTo(RECT) == 0) {
                double d2 = objectInputStream.readDouble();
                double d3 = objectInputStream.readDouble();
                double d4 = objectInputStream.readDouble();
                d = objectInputStream.readDouble();
                object = new Rectangle2D.Double(d2, d3, d4, d);
            } else if (n2.compareTo(BUFFERED_IMAGE) == 0) {
                byte[] byArray = (byte[])objectInputStream.readObject();
                object = ImageIO.read(new ByteArrayInputStream(byArray));
            } else if (n2.compareTo(GENERAL_PATH) == 0) {
                object = PathSerializer.deserializePath(objectInputStream);
            } else if (n2.compareTo(T1GLYPH) == 0) {
                T1Glyph t1Glyph = (T1Glyph)objectInputStream.readObject();
                int n5 = (Integer)objectInputStream.readObject();
                GeneralPath[] generalPathArray = new GeneralPath[n5];
                for (int j = 0; j < n5; ++j) {
                    generalPathArray[j] = PathSerializer.deserializePath(objectInputStream);
                }
                Vector_Path vector_Path = new Vector_Path();
                vector_Path.set(generalPathArray);
                vector_Path.setCurrent_item(generalPathArray.length);
                t1Glyph.setPaths(vector_Path);
                object = t1Glyph;
            } else if (n2.compareTo(TTGLYPH) == 0) {
                TTGlyph tTGlyph = (TTGlyph)objectInputStream.readObject();
                int n6 = (Integer)objectInputStream.readObject();
                GeneralPath[] generalPathArray = new GeneralPath[n6];
                for (int j = 0; j < n6; ++j) {
                    generalPathArray[j] = PathSerializer.deserializePath(objectInputStream);
                }
                Vector_Path vector_Path = new Vector_Path();
                vector_Path.set(generalPathArray);
                vector_Path.setCurrent_item(generalPathArray.length);
                tTGlyph.setPaths(vector_Path);
                object = tTGlyph;
            } else if (n2.compareTo(T3GLYPH) == 0) {
                object = new T3Glyph(objectInputStream);
            } else if (n2.compareTo(TEXTUREDPAINT) == 0) {
                byte[] byArray = (byte[])objectInputStream.readObject();
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                double d5 = objectInputStream.readDouble();
                double d6 = objectInputStream.readDouble();
                d = objectInputStream.readDouble();
                double d7 = objectInputStream.readDouble();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d, d7);
                object = new PdfTexturePaint(bufferedImage, double_);
            } else if (n2.compareTo(AREA) == 0) {
                GeneralPath generalPath = PathSerializer.deserializePath(objectInputStream);
                object = new Area(generalPath);
            } else {
                object = objectInputStream.readObject();
            }
            this.items[i] = object;
        }
    }

    public void trim() {
        Object[] objectArray = new Object[this.current_item];
        System.arraycopy(this.items, 0, objectArray, 0, this.current_item);
        this.items = objectArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }
}

