/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDataNature;
import javax.media.jai.operator.DFTDescriptor;
import javax.media.jai.operator.DFTScalingType;
import javax.media.jai.operator.IDFTPropertyGenerator;
import javax.media.jai.operator.JaiI18N;

public class IDFTDescriptor
extends OperationDescriptorImpl {
    public static final DFTScalingType SCALING_NONE = DFTDescriptor.SCALING_NONE;
    public static final DFTScalingType SCALING_UNITARY = DFTDescriptor.SCALING_UNITARY;
    public static final DFTScalingType SCALING_DIMENSIONS = DFTDescriptor.SCALING_DIMENSIONS;
    public static final DFTDataNature REAL_TO_COMPLEX = DFTDescriptor.REAL_TO_COMPLEX;
    public static final DFTDataNature COMPLEX_TO_COMPLEX = DFTDescriptor.COMPLEX_TO_COMPLEX;
    public static final DFTDataNature COMPLEX_TO_REAL = DFTDescriptor.COMPLEX_TO_REAL;
    private static final String[][] resources = new String[][]{{"GlobalName", "IDFT"}, {"LocalName", "IDFT"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("IDFTDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/IDFTDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion2")}, {"arg0Desc", JaiI18N.getString("IDFTDescriptor1")}, {"arg1Desc", JaiI18N.getString("IDFTDescriptor2")}};
    private static final Class[] paramClasses = new Class[]{class$javax$media$jai$operator$DFTScalingType == null ? (class$javax$media$jai$operator$DFTScalingType = IDFTDescriptor.class$("javax.media.jai.operator.DFTScalingType")) : class$javax$media$jai$operator$DFTScalingType, class$javax$media$jai$operator$DFTDataNature == null ? (class$javax$media$jai$operator$DFTDataNature = IDFTDescriptor.class$("javax.media.jai.operator.DFTDataNature")) : class$javax$media$jai$operator$DFTDataNature};
    private static final String[] paramNames = new String[]{"scalingType", "dataNature"};
    private static final Object[] paramDefaults = new Object[]{SCALING_DIMENSIONS, COMPLEX_TO_REAL};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    static /* synthetic */ Class class$javax$media$jai$operator$DFTScalingType;
    static /* synthetic */ Class class$javax$media$jai$operator$DFTDataNature;

    public IDFTDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        RenderedImage renderedImage;
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        EnumeratedParameter enumeratedParameter = (EnumeratedParameter)parameterBlock.getObjectParameter(1);
        if (!enumeratedParameter.equals(REAL_TO_COMPLEX) && (renderedImage = parameterBlock.getRenderedSource(0)).getSampleModel().getNumBands() % 2 != 0) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("IDFTDescriptor5"));
            return false;
        }
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators(String string) {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new IDFTPropertyGenerator()};
        return propertyGeneratorArray;
    }

    public static RenderedOp create(RenderedImage renderedImage, DFTScalingType dFTScalingType, DFTDataNature dFTDataNature, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("IDFT", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("scalingType", dFTScalingType);
        parameterBlockJAI.setParameter("dataNature", dFTDataNature);
        return JAI.create("IDFT", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, DFTScalingType dFTScalingType, DFTDataNature dFTDataNature, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("IDFT", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("scalingType", dFTScalingType);
        parameterBlockJAI.setParameter("dataNature", dFTDataNature);
        return JAI.createRenderable("IDFT", parameterBlockJAI, renderingHints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

