/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jreepad.JreepadViewer;
import jreepad.TreePathCollection;

public class JreepadPrefs {
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    File openLocation = new File(this.prefs.get("OPENLOCATION", System.getProperty("user.home")));
    File importLocation = new File(this.prefs.get("IMPORTLOCATION", System.getProperty("user.home")));
    File exportLocation = new File(this.prefs.get("EXPORTLOCATION", System.getProperty("user.home")));
    File backupLocation = new File(this.prefs.get("BACKUPLOCATION", System.getProperty("user.home")));
    boolean seenLicense = this.prefs.getBoolean("SEENLICENSE", false);
    int autoSavePeriod = this.prefs.getInt("AUTOSAVEPERIOD", 10);
    boolean autoSave = this.prefs.getBoolean("AUTOSAVE", false);
    public static final int VIEW_BOTH = 0;
    public static final int VIEW_TREE = 1;
    public static final int VIEW_ARTICLE = 2;
    int viewWhich = this.prefs.getInt("VIEWWHICH", 0);
    boolean viewToolbar = this.prefs.getBoolean("VIEWTOOLBAR", true);
    int searchMaxNum = this.prefs.getInt("SEARCHMAXNUM", 200);
    boolean autoDateInArticles = this.prefs.getBoolean("AUTODATEINARTICLES", true);
    boolean loadLastFileOnOpen = this.prefs.getBoolean("LOADLASTFILEONOPEN", true);
    String webSearchName = this.prefs.get("WEBSEARCHNAME", JreepadViewer.lang.getString("PREFS_DEFAULT_SEARCH_TEXT"));
    String webSearchPrefix = this.prefs.get("WEBSEARCHPREFIX", "www.google.co.uk/search?q=");
    String webSearchPostfix = this.prefs.get("WEBSEARCHPOSTFIX", "&hl=en");
    int defaultSearchMode = this.prefs.getInt("DEFAULTSEARCHMODE", 0);
    boolean wikiBehaviourActive = this.prefs.getBoolean("WIKIBEHAVIOURACTIVE", true);
    static final String[] characterEncodings = new String[]{"ISO-8859-1", "ISO-8859-15", "UTF-8", "UTF-16", "US-ASCII", "8859_15"};
    int fileEncoding = this.prefs.getInt("FILEENCODING", 2);
    Vector openRecentList = new Vector();
    int openRecentListLength = this.prefs.getInt("OPENRECENTLISTLENGTH", 10);
    Font treeFont;
    Font articleFont;
    int characterWrapWidth;
    public boolean wrapToWindow;
    int windowLeft;
    int windowTop;
    int windowWidth;
    int windowHeight;
    public static final int LINEBREAK_WIN = 0;
    public static final int LINEBREAK_MAC = 1;
    public static final int LINEBREAK_UNIX = 2;
    int linebreakType = 0;
    TreePathCollection treePathCollection;
    int htmlExportArticleType;
    boolean htmlExportUrlsToLinks;
    int htmlExportAnchorLinkType;
    int dividerLocation;
    boolean autoDetectHtmlArticles;
    public boolean addQuotesToCsvOutput;
    public static final int FILETYPE_XML = 0;
    public static final int FILETYPE_HJT = 1;
    public static final int FILETYPE_XML_ENCRYPTED = 2;
    int mainFileType;
    public static final String[] mainFileTypes = new String[]{"Jreepad XML", "Treepad HJT"};
    static final int TOOLBAR_TEXT = 0;
    static final int TOOLBAR_ICON = 1;
    static final int TOOLBAR_OFF = 2;
    int toolbarMode;
    boolean showGreenStrip;
    public String dateFormat;

    String getEncoding() {
        return characterEncodings[this.fileEncoding];
    }

    File getMostRecentFile() {
        if (this.openRecentList.size() == 0) {
            return null;
        }
        return (File)this.openRecentList.get(0);
    }

    public String linebreak() {
        switch (this.linebreakType) {
            case 0: {
                return "\r\n";
            }
            case 1: {
                return "\r";
            }
            case 2: {
                return "\n";
            }
        }
        return "\r\n";
    }

    JreepadPrefs(Dimension wndSize) {
        String tempFileListItem;
        for (int i = 0; i < 100 && !(tempFileListItem = this.prefs.get("OPENRECENTLIST_" + i, "")).equals(""); ++i) {
            this.openRecentList.add(new File(tempFileListItem));
        }
        String treeFontName = this.prefs.get("TREEFONTNAME", new JTree().getFont().getName());
        String articleFontName = this.prefs.get("ARTICLEFONTNAME", new JEditorPane().getFont().getName());
        int treeFontSize = this.prefs.getInt("TREEFONTSIZE", new JTree().getFont().getSize());
        int articleFontSize = this.prefs.getInt("ARTICLEFONTSIZE", new JEditorPane().getFont().getSize());
        this.treeFont = new Font(treeFontName, 0, treeFontSize);
        this.articleFont = new Font(articleFontName, 0, articleFontSize);
        this.characterWrapWidth = this.prefs.getInt("CHARACTERWRAPWIDTH", 80);
        this.wrapToWindow = this.prefs.getBoolean("WRAPTOWINDOW", true);
        this.windowWidth = this.prefs.getInt("WINDOWWIDTH", 0);
        this.windowHeight = this.prefs.getInt("WINDOWHEIGHT", 0);
        this.windowTop = this.prefs.getInt("WINDOWTOP", 0);
        this.windowLeft = this.prefs.getInt("WINDOWLEFT", 0);
        if (this.windowWidth == 0 || this.windowWidth == 0) {
            this.windowWidth = (int)(wndSize.getWidth() * (double)0.6f);
            this.windowHeight = (int)(wndSize.getHeight() * (double)0.6f);
            if (this.windowWidth > (int)((float)this.windowHeight * 1.618034f)) {
                this.windowWidth = (int)((float)this.windowHeight * 1.618034f);
            } else if (this.windowHeight > (int)((float)this.windowWidth * 1.618034f)) {
                this.windowHeight = (int)((float)this.windowWidth * 1.618034f);
            }
            this.windowTop = this.windowHeight / 3;
            this.windowLeft = this.windowWidth / 3;
        }
        this.linebreakType = this.prefs.getInt("LINEBREAKTYPE", 0);
        this.treePathCollection = new TreePathCollection(new TreePath[0]);
        this.htmlExportArticleType = this.prefs.getInt("HTMLEXPORTARTICLETYPE", 0);
        this.htmlExportUrlsToLinks = this.prefs.getBoolean("HTMLEXPORTURLSTOLINKS", true);
        this.htmlExportAnchorLinkType = this.prefs.getInt("HTMLEXPORTANCHORLINKTYPE", 1);
        this.dividerLocation = this.prefs.getInt("DIVIDERLOCATION", -1);
        this.autoDetectHtmlArticles = this.prefs.getBoolean("AUTODETECTHTMLINARTICLES", true);
        this.addQuotesToCsvOutput = this.prefs.getBoolean("ADDQUOTESTOCSVOUTPUT", false);
        this.mainFileType = this.prefs.getInt("MAINFILETYPE", 1);
        this.toolbarMode = this.prefs.getInt("TOOLBARMODE", 1);
        this.showGreenStrip = this.prefs.getBoolean("SHOWGREENSTRIP", true);
        this.dateFormat = this.prefs.get("DATEFORMAT", "");
    }

    void save() {
        this.prefs.put("OPENLOCATION", "" + this.openLocation);
        this.prefs.put("IMPORTLOCATION", "" + this.importLocation);
        this.prefs.put("EXPORTLOCATION", "" + this.exportLocation);
        this.prefs.put("BACKUPLOCATION", "" + this.backupLocation);
        this.prefs.putBoolean("SEENLICENSE", this.seenLicense);
        this.prefs.putInt("AUTOSAVEPERIOD", this.autoSavePeriod);
        this.prefs.putBoolean("AUTOSAVE", this.autoSave);
        this.prefs.putInt("VIEWWHICH", this.viewWhich);
        this.prefs.putBoolean("VIEWTOOLBAR", this.viewToolbar);
        this.prefs.putInt("SEARCHMAXNUM", this.searchMaxNum);
        this.prefs.putBoolean("AUTODATEINARTICLES", this.autoDateInArticles);
        this.prefs.putBoolean("LOADLASTFILEONOPEN", this.loadLastFileOnOpen);
        this.prefs.put("WEBSEARCHNAME", "" + this.webSearchName);
        this.prefs.put("WEBSEARCHPREFIX", "" + this.webSearchPrefix);
        this.prefs.put("WEBSEARCHPOSTFIX", "" + this.webSearchPostfix);
        this.prefs.putInt("DEFAULTSEARCHMODE", this.defaultSearchMode);
        this.prefs.putBoolean("WIKIBEHAVIOURACTIVE", this.wikiBehaviourActive);
        this.prefs.putInt("FILEENCODING", this.fileEncoding);
        for (int i = 0; i < this.openRecentList.size(); ++i) {
            this.prefs.put("OPENRECENTLIST_" + i, "" + ((File)this.openRecentList.get(i)).toString());
        }
        this.prefs.putInt("OPENRECENTLISTLENGTH", this.openRecentListLength);
        this.prefs.put("TREEFONTNAME", this.treeFont.getName());
        this.prefs.putInt("TREEFONTSIZE", this.treeFont.getSize());
        this.prefs.put("ARTICLEFONTNAME", this.articleFont.getName());
        this.prefs.putInt("ARTICLEFONTSIZE", this.articleFont.getSize());
        this.prefs.putInt("CHARACTERWRAPWIDTH", this.characterWrapWidth);
        this.prefs.putBoolean("WRAPTOWINDOW", this.wrapToWindow);
        this.prefs.putInt("WINDOWLEFT", this.windowLeft);
        this.prefs.putInt("WINDOWTOP", this.windowTop);
        this.prefs.putInt("WINDOWWIDTH", this.windowWidth);
        this.prefs.putInt("WINDOWHEIGHT", this.windowHeight);
        this.prefs.putInt("LINEBREAKTYPE", this.linebreakType);
        this.prefs.putInt("HTMLEXPORTARTICLETYPE", this.htmlExportArticleType);
        this.prefs.putBoolean("HTMLEXPORTURLSTOLINKS", this.htmlExportUrlsToLinks);
        this.prefs.putInt("HTMLEXPORTANCHORLINKTYPE", this.htmlExportAnchorLinkType);
        this.prefs.putInt("DIVIDERLOCATION", this.dividerLocation);
        this.prefs.putBoolean("AUTODETECTHTMLINARTICLES", this.autoDetectHtmlArticles);
        this.prefs.putBoolean("ADDQUOTESTOCSVOUTPUT", this.addQuotesToCsvOutput);
        this.prefs.putInt("MAINFILETYPE", this.mainFileType);
        this.prefs.putInt("TOOLBARMODE", this.toolbarMode);
        this.prefs.putBoolean("SHOWGREENSTRIP", this.showGreenStrip);
        this.prefs.put("DATEFORMAT", this.dateFormat);
        try {
            this.prefs.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

