/*
 * Decompiled with CFR 0.152.
 */
package jreepad.editor;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import jreepad.JreepadArticle;
import jreepad.editor.AbstractArticleView;

public abstract class EditorPaneView
extends AbstractArticleView {
    protected JEditorPane editorPane;

    public EditorPaneView(String type, JreepadArticle article) {
        super(article);
        this.editorPane = new JEditorPane(type, "");
        this.reloadArticle();
    }

    public void reloadArticle() {
        this.editorPane.setText(this.article.getContent());
    }

    public void updateFont(int direction) {
        StyledEditorKit kit = (StyledEditorKit)this.editorPane.getEditorKit();
        MutableAttributeSet set = kit.getInputAttributes();
        StyledDocument doc = (StyledDocument)this.editorPane.getDocument();
        Font currentFont = doc.getFont(set);
        int currentFontSize = currentFont.getSize();
        switch (direction) {
            case 1: {
                ++currentFontSize;
                break;
            }
            case 2: {
                --currentFontSize;
            }
        }
        StyleConstants.setFontSize(set, currentFontSize);
        doc.setCharacterAttributes(0, doc.getLength(), set, false);
    }

    public JComponent getComponent() {
        return this.editorPane;
    }

    public String getText() {
        return this.editorPane.getText();
    }

    public String getSelectedText() {
        return this.editorPane.getSelectedText();
    }
}

