/*
 * Decompiled with CFR 0.152.
 */
package jreepad.editor;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import jreepad.JreepadArticle;
import jreepad.JreepadPrefs;
import jreepad.JreepadView;
import jreepad.editor.ContentChangeListener;
import jreepad.editor.EditorPaneView;

public class PlainTextEditor
extends EditorPaneView
implements CaretListener,
UndoableEditListener {
    private ContentChangeListener contentChangeListener = null;
    private static short paraRightMargin = 0;

    public PlainTextEditor(JreepadArticle article) {
        super("text/plain", article);
        this.editorPane.setEditable(true);
        if (PlainTextEditor.getPrefs().wrapToWindow) {
            this.editorPane.setEditorKit(new JPEditorKit());
        }
        this.editorPane.addCaretListener(this);
        this.editorPane.getDocument().addUndoableEditListener(this);
    }

    public void insertText(String text) {
        Document doc = this.editorPane.getDocument();
        int here = this.editorPane.getCaretPosition();
        try {
            this.editorPane.setText(doc.getText(0, here) + text + doc.getText(here, doc.getLength() - here));
            this.editorPane.setCaretPosition(here + text.length());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void setContentChangeListener(ContentChangeListener listener) {
        this.contentChangeListener = listener;
    }

    private void notifyContentChangeListener() {
        if (this.contentChangeListener != null) {
            this.contentChangeListener.contentChanged();
        }
    }

    public String selectWordUnderCursor() {
        try {
            int startpos;
            String text = this.editorPane.getText();
            int endpos = startpos = this.editorPane.getCaretPosition();
            if (text.length() > 0) {
                while (startpos > 0 && !Character.isWhitespace(this.editorPane.getText(startpos - 1, 1).charAt(0))) {
                    --startpos;
                }
                while (endpos < text.length() && !Character.isWhitespace(this.editorPane.getText(endpos, 1).charAt(0))) {
                    ++endpos;
                }
                if (endpos > startpos) {
                    this.editorPane.setSelectionStart(startpos);
                    this.editorPane.setSelectionEnd(endpos);
                    return this.getSelectedText();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    public void caretUpdate(CaretEvent e) {
        if (this.editLocked) {
            return;
        }
        if (this.article.getArticleMode() != 1) {
            return;
        }
        if (!this.editorPane.getText().equals(this.article.getContent())) {
            this.article.setContent(this.editorPane.getText());
            this.notifyContentChangeListener();
        }
    }

    public static JreepadPrefs getPrefs() {
        return JreepadView.getPrefs();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (!this.editLocked) {
            this.article.getUndoMgr().addEdit(e.getEdit());
        }
    }

    static class JPParagraphView
    extends ParagraphView {
        public JPParagraphView(Element e) {
            super(e);
            this.setInsets((short)0, (short)0, (short)0, paraRightMargin);
        }
    }

    private static class JPRTFViewFactory
    implements ViewFactory {
        private JPRTFViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new JPParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    private static class JPEditorKit
    extends StyledEditorKit {
        private JPEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new JPRTFViewFactory();
        }
    }
}

