/*
 * Decompiled with CFR 0.152.
 */
package jreepad.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TextTransferHandler
extends TransferHandler {
    private Position p0 = null;
    private Position p1 = null;

    public boolean importData(JComponent comp, Transferable t) {
        boolean insertDone = false;
        if (comp instanceof JTextComponent) {
            String data;
            if (!t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            JTextComponent tc = (JTextComponent)comp;
            tc.replaceSelection(data);
            insertDone = true;
        }
        return insertDone;
    }

    protected Transferable createTransferable(JComponent comp) {
        StringSelection transferData = null;
        if (comp instanceof JTextComponent) {
            int end;
            JTextComponent source = (JTextComponent)comp;
            int start = source.getSelectionStart();
            if (start == (end = source.getSelectionEnd())) {
                return null;
            }
            Document doc = source.getDocument();
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
            }
            catch (BadLocationException e) {
                this.p1 = null;
                this.p0 = null;
            }
            String data = source.getSelectedText();
            transferData = new StringSelection(data);
        }
        return transferData;
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action != 2) {
            return;
        }
        if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent tc = (JTextComponent)c;
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                System.out.println("Can't remove text from source.");
            }
        }
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        boolean supported = false;
        for (int idx = 0; idx < transferFlavors.length && !supported; ++idx) {
            supported = DataFlavor.stringFlavor.equals(transferFlavors[idx]);
        }
        return supported;
    }
}

