/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class AppInfo {
    public static final String APPPATH_PROPERTY_KEY = "bootstrap.appPath";
    public static final String WORKINGDIR_PROPERTY_KEY = "bootstrap.workingDir";
    private static final String JAR_PREFIX = "jar:";
    private static AppInfo instance = null;
    private final String m_appPath;
    private final String m_cwdPath;
    private final String[] m_appArgs;

    private AppInfo(String p_appPath, String p_cwdPath, String[] p_appArgs) {
        try {
            this.m_appPath = new File(p_appPath).getCanonicalPath();
            this.m_cwdPath = new File(p_cwdPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!new File(this.m_appPath).isDirectory()) {
            throw new IllegalArgumentException("The application path '" + this.m_appPath + "' is not a directory.");
        }
        if (!new File(this.m_cwdPath).isDirectory()) {
            throw new IllegalArgumentException("The working directory path '" + this.m_cwdPath + "' is not a directory.");
        }
        this.m_appArgs = p_appArgs;
    }

    public static void init(String[] p_appArgs) {
        if (instance != null) {
            throw new IllegalStateException("The class 'AppInfo' has already been initialized.");
        }
        String appPath = System.getProperty(APPPATH_PROPERTY_KEY);
        if (appPath == null && (appPath = AppInfo.determineAppPath(new File("lib/"))) == null) {
            throw new RuntimeException("Could not determine the application's path. You can fix this specifying this path through the Java system property 'bootstrap.appPath' on the command line.");
        }
        String cwdPath = System.getProperty(WORKINGDIR_PROPERTY_KEY, appPath);
        instance = new AppInfo(appPath, cwdPath, p_appArgs);
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static String getAppPath() {
        if (instance == null) {
            throw new IllegalStateException("The class 'AppInfo' has not yet been initialized.");
        }
        return AppInfo.instance.m_appPath;
    }

    public static String getWorkingDir() {
        if (instance == null) {
            throw new IllegalStateException("The class 'AppInfo' has not yet been initialized.");
        }
        return AppInfo.instance.m_cwdPath;
    }

    public static String[] getAppArgs() {
        if (instance == null) {
            throw new IllegalStateException("The class 'AppInfo' has not yet been initialized.");
        }
        return AppInfo.instance.m_appArgs;
    }

    private static String determineAppPath(File p_relativePathToLauncherJarDir) {
        File basePath;
        System.out.println("Try to detect app path...");
        URL mainClassUrl = AppInfo.class.getResource(AppInfo.class.getSimpleName() + ".class");
        if (mainClassUrl == null) {
            return null;
        }
        System.out.println("URL is: " + mainClassUrl);
        String mainClassUri = mainClassUrl.toString();
        boolean isMainClassInJar = mainClassUri.startsWith(JAR_PREFIX);
        if (!isMainClassInJar) {
            throw new RuntimeException("The class '" + AppInfo.class.getName() + "' is not loaded from the " + "JavaLauncher JAR file (but rather directly from the file system). You must specify the app path " + "manually throught the Java system property '" + APPPATH_PROPERTY_KEY + "'.");
        }
        int idx = mainClassUri.lastIndexOf(33);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        mainClassUri = mainClassUri.substring(JAR_PREFIX.length(), idx);
        System.out.println("Cleansed URI is: " + mainClassUri);
        try {
            basePath = new File(new URI(mainClassUri)).getCanonicalFile().getParentFile();
            System.out.println("Base path is: " + basePath.getPath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (p_relativePathToLauncherJarDir != null && p_relativePathToLauncherJarDir.getPath().length() > 0) {
            if (p_relativePathToLauncherJarDir.isAbsolute()) {
                throw new IllegalArgumentException("The path to the JavaLauncher jar directory must not be absolute.");
            }
            while (p_relativePathToLauncherJarDir != null) {
                basePath = basePath.getParentFile();
                p_relativePathToLauncherJarDir = p_relativePathToLauncherJarDir.getParentFile();
            }
        }
        System.out.println("Cleansed base path is: " + basePath.getPath());
        return basePath.getAbsolutePath();
    }
}

