/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.launcher.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubProcess {
    private static final boolean USE_STDIN;
    private final int m_exitCode;

    private SubProcess(String[] p_args, Map<String, String> p_env, String p_workDir) {
        OutputStream stdin = null;
        InputStream outputStream = null;
        InputStream outputErrStream = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(p_args);
            if (p_env != null) {
                Map<String, String> env = pb.environment();
                env.clear();
                for (Map.Entry<String, String> entry : p_env.entrySet()) {
                    env.put(entry.getKey(), entry.getValue());
                }
            }
            if (p_workDir != null && p_workDir.trim().length() > 0) {
                pb.directory(new File(p_workDir));
            }
            Process child = pb.start();
            stdin = child.getOutputStream();
            outputStream = new BufferedInputStream(child.getInputStream());
            outputErrStream = new BufferedInputStream(child.getErrorStream());
            while (true) {
                int ch;
                if (outputStream.available() > 0) {
                    ch = outputStream.read();
                    if (ch == -1) {
                        throw new IllegalStateException("Should never happen.");
                    }
                } else if (outputErrStream.available() > 0) {
                    ch = outputErrStream.read();
                    if (ch == -1) {
                        throw new IllegalStateException("Should never happen.");
                    }
                } else {
                    if (USE_STDIN && System.in.available() > 0) {
                        int ch2 = System.in.read();
                        if (ch2 == -1) {
                            throw new IllegalStateException("Should never happen.");
                        }
                        stdin.write(ch2);
                        stdin.flush();
                        continue;
                    }
                    try {
                        child.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException e) {
                        Thread.sleep(10L);
                        continue;
                    }
                }
                System.out.print((char)ch);
            }
            this.m_exitCode = child.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stdin != null) {
                    stdin.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (outputErrStream != null) {
                    outputErrStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getExitCode() {
        return this.m_exitCode;
    }

    public static SubProcess exec(String ... p_args) {
        return SubProcess.exec(Arrays.asList(p_args));
    }

    public static SubProcess exec(List<String> p_args) {
        return SubProcess.exec(p_args, null, null);
    }

    public static SubProcess exec(List<String> p_args, Map<String, String> p_env) {
        return SubProcess.exec(p_args, p_env, null);
    }

    public static SubProcess exec(List<String> p_args, Map<String, String> p_env, String p_workDir) {
        return new SubProcess(p_args.toArray(new String[p_args.size()]), p_env, p_workDir);
    }

    public static Map<String, String> getEnvMapCopy() {
        HashMap<String, String> envMapCopy = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            envMapCopy.put(entry.getKey(), entry.getValue());
        }
        return envMapCopy;
    }

    static {
        boolean useStdIn;
        try {
            System.in.available();
            useStdIn = true;
        }
        catch (IOException e) {
            useStdIn = false;
        }
        USE_STDIN = useStdIn;
    }
}

