/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.castor.util.IdentityMap;
import org.castor.util.IdentitySet;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LazyCGLIB;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.util.Messages;

public final class ObjectTracker {
    private final Map _objectToEngine = new IdentityMap();
    private final Map _objectToMolder = new IdentityMap();
    private final Map _engineToOIDToObject = new HashMap();
    private final Map _objectToOID = new IdentityMap();
    private final Set _deletedSet = new IdentitySet();
    private final Set _creatingSet = new IdentitySet();
    private final Set _createdSet = new IdentitySet();
    private final Set _updatePersistNeededSet = new IdentitySet();
    private final Set _updateCacheNeededSet = new IdentitySet();
    private final Set _readOnlySet = new IdentitySet();
    private final Set _readWriteSet = new IdentitySet();

    public Object getObjectForOID(LockEngine engine, OID oid, boolean allowReadOnly) {
        Map oidToObject = (Map)this._engineToOIDToObject.get(engine);
        if (oidToObject != null) {
            Object found = oidToObject.get(oid);
            if (!allowReadOnly && this._readOnlySet.contains(found)) {
                return null;
            }
            return found;
        }
        return null;
    }

    public boolean isReadWrite(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._readWriteSet.contains(aObject);
    }

    public void unmarkAllDeleted() {
        this._deletedSet.clear();
    }

    public void clear() {
        this._createdSet.clear();
        this._creatingSet.clear();
        this._deletedSet.clear();
        this._engineToOIDToObject.clear();
        this._objectToEngine.clear();
        this._objectToMolder.clear();
        this._objectToOID.clear();
        this._readOnlySet.clear();
        this._readWriteSet.clear();
        this._updateCacheNeededSet.clear();
        this._updatePersistNeededSet.clear();
    }

    public boolean isUpdateCacheNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._updateCacheNeededSet.contains(aObject);
    }

    public boolean isUpdatePersistNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._updatePersistNeededSet.contains(aObject);
    }

    public void markUpdateCacheNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._updateCacheNeededSet.add(aObject);
    }

    public void unmarkUpdateCacheNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        this._updateCacheNeededSet.remove(aObject);
    }

    public Collection getObjectsWithUpdateCacheNeededState() {
        return new ArrayList(this._updateCacheNeededSet);
    }

    public void markUpdatePersistNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._updatePersistNeededSet.add(aObject);
        this._updateCacheNeededSet.add(aObject);
    }

    public void unmarkUpdatePersistNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        this._updatePersistNeededSet.remove(aObject);
    }

    public void markCreating(Object object) throws PersistenceException {
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        if (this._createdSet.contains(aObject)) {
            throw new PersistenceException("Invalid state change; can't mark something  creating which is already marked created.");
        }
        this._creatingSet.add(aObject);
    }

    public void markCreated(Object object) {
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._createdSet.add(aObject);
        this._creatingSet.remove(aObject);
    }

    public void markDeleted(Object object) {
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._deletedSet.add(aObject);
    }

    public void unmarkDeleted(Object object) {
        Object aObject = this.supportCGLibObject(object);
        this._deletedSet.remove(aObject);
    }

    public boolean isTracking(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._objectToOID.containsKey(aObject);
    }

    public void trackOIDChange(Object obj, LockEngine engine, OID oldoid, OID newoid) {
        Object object = this.supportCGLibObject(obj);
        this.removeOIDForObject(engine, oldoid);
        this.setOIDForObject(object, engine, newoid);
    }

    public void setOIDForObject(Object obj, LockEngine engine, OID oid) {
        Object object = this.supportCGLibObject(obj);
        this.removeOIDForObject(engine, oid);
        HashMap<OID, Object> oidToObject = (HashMap<OID, Object>)this._engineToOIDToObject.get(engine);
        if (oidToObject == null) {
            oidToObject = new HashMap<OID, Object>();
            this._engineToOIDToObject.put(engine, oidToObject);
        }
        oidToObject.put(oid, obj);
        this._objectToOID.put(object, oid);
    }

    public void removeOIDForObject(LockEngine engine, OID oid) {
        Object found = null;
        Map oidToObject = (Map)this._engineToOIDToObject.get(engine);
        if (oidToObject != null) {
            found = oidToObject.get(oid);
            oidToObject.remove(oid);
        }
        if (found != null) {
            this._objectToOID.remove(found);
        }
    }

    public boolean isCreating(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._creatingSet.contains(object);
    }

    public boolean isCreated(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._createdSet.contains(object);
    }

    public boolean isDeleted(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._deletedSet.contains(object);
    }

    public ClassMolder getMolderForObject(Object o) {
        Object object = this.supportCGLibObject(o);
        return (ClassMolder)this._objectToMolder.get(object);
    }

    public LockEngine getLockEngineForObject(Object o) {
        Object object = this.supportCGLibObject(o);
        return (LockEngine)this._objectToEngine.get(object);
    }

    public void setLockEngineForObject(Object obj, LockEngine engine) {
        Object object = this.supportCGLibObject(obj);
        this.removeLockEngineForObject(object);
        this._objectToEngine.put(object, engine);
    }

    private void removeLockEngineForObject(Object obj) {
        Object object = this.supportCGLibObject(obj);
        this._objectToEngine.remove(object);
    }

    private void setMolderForObject(Object obj, ClassMolder molder) {
        Object object = this.supportCGLibObject(obj);
        this.removeMolderForObject(object);
        this._objectToMolder.put(object, molder);
    }

    private void removeMolderForObject(Object obj) {
        Object object = this.supportCGLibObject(obj);
        this._objectToMolder.remove(object);
    }

    public Collection getReadWriteObjects() {
        ArrayList returnedList = new ArrayList(this._readWriteSet);
        return returnedList;
    }

    public Collection getReadOnlyObjects() {
        ArrayList returnedList = new ArrayList(this._readOnlySet);
        return returnedList;
    }

    public Collection getObjectsWithCreatingStateSortedByLowestMolderPriority() {
        ArrayList returnedList = new ArrayList(this._creatingSet);
        Collections.sort(returnedList, new ObjectMolderPriorityComparator(this, false));
        return returnedList;
    }

    public Collection getObjectsWithDeletedStateSortedByHighestMolderPriority() {
        ArrayList returnedList = new ArrayList(this._deletedSet);
        Collections.sort(returnedList, new ObjectMolderPriorityComparator(this, true));
        return returnedList;
    }

    public void trackObject(LockEngine engine, ClassMolder molder, OID oid, Object object) {
        Object aObject = this.supportCGLibObject(object);
        this.setLockEngineForObject(aObject, engine);
        this.setMolderForObject(aObject, molder);
        this.setOIDForObject(aObject, engine, oid);
        this._readWriteSet.add(aObject);
    }

    public void untrackObject(Object object) {
        Object aObject = this.supportCGLibObject(object);
        LockEngine engine = this.getLockEngineForObject(aObject);
        OID oid = this.getOIDForObject(aObject);
        this.removeMolderForObject(aObject);
        this.removeLockEngineForObject(aObject);
        this.removeOIDForObject(engine, oid);
        this._deletedSet.remove(aObject);
        this._creatingSet.remove(aObject);
        this._createdSet.remove(aObject);
        this._updatePersistNeededSet.remove(aObject);
        this._updateCacheNeededSet.remove(aObject);
        this._readOnlySet.remove(aObject);
        this._readWriteSet.remove(aObject);
    }

    public OID getOIDForObject(Object o) {
        Object object = this.supportCGLibObject(o);
        return (OID)this._objectToOID.get(object);
    }

    public boolean isReadOnly(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._readOnlySet.contains(object);
    }

    public void markReadOnly(Object o) {
        Object object = this.supportCGLibObject(o);
        if (!this.isTracking(object)) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to make read-only object that is not in transaction"));
        }
        this._readOnlySet.add(object);
        this._readWriteSet.remove(object);
    }

    public void unmarkReadOnly(Object o) {
        Object object = this.supportCGLibObject(o);
        if (!this.isTracking(object)) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to make read-write object that is not in transaction"));
        }
        this._readWriteSet.add(object);
        this._readOnlySet.remove(object);
    }

    public int readOnlySize() {
        return this._readOnlySet.size();
    }

    public int readWriteSize() {
        return this._readWriteSet.size();
    }

    private Object supportCGLibObject(Object object) {
        if (object instanceof LazyCGLIB) {
            LazyCGLIB cgObject = (LazyCGLIB)object;
            if (cgObject.interceptedHasMaterialized() == Boolean.TRUE) {
                Object identity = cgObject.interceptedIdentity();
                ClassMolder molder = cgObject.interceptedClassMolder();
                LockEngine engine = cgObject.interceptedLockEngine();
                OID oid = new OID(engine, molder, identity);
                return this.getObjectForOID(engine, oid, true);
            }
            return null;
        }
        return object;
    }

    public String allObjectStates() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this._objectToOID.keySet().iterator();
        while (it.hasNext()) {
            sb.append(this.objectStateToString(it.next()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String objectStateToString(Object obj) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getOIDForObject(obj));
        sb.append('\t');
        sb.append("deleted: ");
        sb.append(this._deletedSet.contains(obj));
        sb.append('\t');
        sb.append("creating: ");
        sb.append(this._creatingSet.contains(obj));
        sb.append('\t');
        sb.append("created: ");
        sb.append(this._createdSet.contains(obj));
        return sb.toString();
    }

    private static final class ObjectMolderPriorityComparator
    implements Comparator {
        private ObjectTracker _tracker;
        private boolean _reverseOrder;

        public ObjectMolderPriorityComparator(ObjectTracker tracker, boolean reverseOrder) {
            this._tracker = tracker;
            this._reverseOrder = reverseOrder;
        }

        public int compare(Object object1, Object object2) {
            int pri2;
            ClassMolder molder1 = this._tracker.getMolderForObject(object1);
            ClassMolder molder2 = this._tracker.getMolderForObject(object2);
            if (molder1 == null || molder2 == null) {
                return 0;
            }
            int pri1 = molder1.getPriority();
            if (pri1 == (pri2 = molder2.getPriority())) {
                return 0;
            }
            if (this._reverseOrder) {
                return pri1 < pri2 ? 1 : -1;
            }
            return pri1 < pri2 ? -1 : 1;
        }
    }
}

