/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Date
extends DateTimeBase {
    private static final int YEAR_FLAG = 15;
    private static final int MONTH_FLAG = 7;
    private static final int DAY_FLAG = 3;
    private static final int TIMEZONE_FLAG = 1;
    private static final String BAD_DATE = "Bad Date format: ";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public Date() {
    }

    public Date(short[] values) {
        this.setValues(values);
    }

    public Date(long dateAsLong) {
        this(new java.util.Date(dateAsLong));
    }

    public Date(java.util.Date dateRef) {
        GregorianCalendar tempCalendar = new GregorianCalendar();
        tempCalendar.setTime(dateRef);
        this.setCentury((short)(tempCalendar.get(1) / 100));
        this.setYear((short)(tempCalendar.get(1) % 100));
        this.setMonth((short)(tempCalendar.get(2) + 1));
        this.setDay((short)tempCalendar.get(5));
    }

    public Date(String date) throws ParseException {
        this();
        Date.parseDateInternal(date, this);
    }

    public void setValues(short[] values) {
        if (values.length != 4) {
            throw new IllegalArgumentException("Date#setValues: not the right number of values");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
        this.setDay(values[3]);
    }

    public short[] getValues() {
        short[] result = null;
        result = new short[]{this.getCentury(), this.getYear(), this.getMonth(), this.getDay()};
        return result;
    }

    public java.util.Date toDate() {
        java.util.Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public long toLong() {
        java.util.Date date = this.toDate();
        return date.getTime();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isNegative()) {
            result.append('-');
        }
        result.append(this.getCentury());
        if (result.length() == 1) {
            result.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        result.append('-');
        if (this.getMonth() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMonth());
        result.append('-');
        if (this.getDay() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getDay());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Date.parseDate(str);
    }

    public static Date parseDate(String str) throws ParseException {
        Date result = new Date();
        return Date.parseDateInternal(str, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date parseDateInternal(String str, Date result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new Date();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            ++idx;
            result.setNegative();
        }
        boolean hasNumber = false;
        boolean has2Digits = false;
        short number = 0;
        short number2 = 0;
        int flags = 15;
        block6: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case '-': {
                    if (flags == 15) {
                        if (number == 0 && number2 == 0) throw new ParseException(BAD_DATE + str + "\n'0000' is not allowed as a year.", idx);
                        if (!has2Digits) {
                            throw new ParseException(BAD_DATE + str + "\nThe Century field must have 2 digits.", idx);
                        }
                        result.setCentury(number);
                        result.setYear(number2);
                        number2 = -1;
                        flags = 7;
                    } else if (flags == 7) {
                        if (!has2Digits || number2 != -1) throw new ParseException(BAD_DATE + str + "\nThe month field must have 2 digits.", idx);
                        result.setMonth(number);
                        flags = 3;
                    } else {
                        if (flags != 3 || number2 != -1) throw new ParseException(BAD_DATE + str + "\n '-' " + "is wrongly placed.", idx);
                        if (!has2Digits) throw new ParseException(BAD_DATE + str + "\nThe day field must have 2 digits.", idx);
                        result.setUTC();
                        result.setZoneNegative(true);
                        result.setDay(number);
                        flags = 1;
                    }
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case 'Z': {
                    if (flags != 3) {
                        throw new ParseException("'Z' is wrongly placed.", idx);
                    }
                    result.setUTC();
                    continue block6;
                }
                case '+': {
                    if (flags != 3) {
                        throw new ParseException("'+' is wrongly placed.", idx);
                    }
                    if (!has2Digits || number2 != -1) throw new ParseException(BAD_DATE + str + "\nThe day field must have 2 digits.", idx);
                    result.setDay(number);
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case ':': {
                    if (flags != 1) {
                        throw new ParseException(BAD_DATE + str + "\n':' " + "is wrongly placed.", idx);
                    }
                    number2 = number;
                    number = -1;
                    flags = 0;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
            }
            if ('0' > ch || ch > '9') throw new ParseException(str + ": Invalid character: " + ch, idx);
            if (hasNumber) {
                if (has2Digits) {
                    number2 = (short)(number2 * 10 + (ch - 48));
                    continue;
                }
                number = (short)(number * 10 + (ch - 48));
                has2Digits = true;
                continue;
            }
            hasNumber = true;
            number = (short)(ch - 48);
        }
        if (flags != 3 && flags != 0) {
            throw new ParseException(BAD_DATE + str + "\nA date must follow the pattern CCYY-MM-DD(Z|((+|-)hh:mm)).", idx);
        }
        if (flags == 3) {
            if (!has2Digits || number2 != -1) throw new ParseException(BAD_DATE + str + "\nThe day field must have 2 digits.", idx);
            result.setDay(number);
            return result;
        } else {
            if (flags != 0) return result;
            if (number == -1) throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
            result.setZone(number2, number);
        }
        return result;
    }

    public short getHour() {
        String err = "Date: couldn't access to the Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public short getMinute() {
        String err = "Date: couldn't access to the Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public short getSeconds() {
        String err = "Date: couldn't access to the Second field.";
        throw new OperationNotSupportedException(err);
    }

    public short getMilli() {
        String err = "Date: couldn't access to the Millisecond field.";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) {
        String err = "Date: couldn't access to the Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) {
        String err = "Date: couldn't access to the Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second) {
        String err = "Date: couldn't access to the second field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMilliSecond(short millisecond) {
        String err = "Date: couldn't access to the Millisecond field.";
        throw new OperationNotSupportedException(err);
    }
}

