/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.OperationNotSupportedException;

public class GMonthDay
extends Date {
    private static final String MONTHDAY_FORMAT = "--MM-dd";
    private static final String BAD_GMONTHDAY = "Bad gMonthDay format: ";

    public GMonthDay() {
    }

    public GMonthDay(short month, short day) {
        this.setMonth(month);
        this.setDay(day);
    }

    public GMonthDay(int month, int day) {
        this.setMonth((short)month);
        this.setDay((short)day);
    }

    public GMonthDay(short[] values) {
        this();
        this.setValues(values);
    }

    public GMonthDay(String gmonthDay) throws ParseException {
        this();
        GMonthDay.parseGMonthDayInternal(gmonthDay, this);
    }

    public void setValues(short[] values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("GYear#setValues: not the right number of values");
        }
        this.setMonth(values[0]);
        this.setDay(values[1]);
    }

    public short[] getValues() {
        short[] result = null;
        result = new short[]{this.getCentury(), this.getYear()};
        return result;
    }

    public java.util.Date toDate() {
        java.util.Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(MONTHDAY_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('-');
        result.append('-');
        result.append(this.getMonth());
        if (result.length() == 3) {
            result.insert(2, 0);
        }
        result.append('-');
        if (this.getDay() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getDay());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GMonthDay.parseGMonthDay(str);
    }

    public static GMonthDay parseGMonthDay(String str) throws ParseException {
        GMonthDay result = new GMonthDay();
        return GMonthDay.parseGMonthDayInternal(str, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GMonthDay parseGMonthDayInternal(String str, GMonthDay result) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GMonthDay();
        }
        char[] chars = str.toCharArray();
        int idx = 0;
        boolean hasNumber = false;
        boolean has2Digits = false;
        short number = -1;
        short number2 = 0;
        int flags = 31;
        block6: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case '-': {
                    if (flags == 31 && number == -1) {
                        flags = 15;
                    } else if (flags == 15 && number == -1) {
                        flags = 7;
                    } else if (flags == 7 && number != -1) {
                        if (!has2Digits) throw new ParseException(BAD_GMONTHDAY + str + "\nThe month field must have 2 digits.", idx);
                        result.setMonth(number);
                        flags = 3;
                    } else {
                        if (flags != 3) throw new ParseException(BAD_GMONTHDAY + str + "\nA gMonthDay must follow the pattern --MM-DD(Z|((+|-)hh:mm)).", idx);
                        if (!has2Digits) throw new ParseException(BAD_GMONTHDAY + str + "\nThe day field must have 2 digits.", idx);
                        result.setDay(number);
                        result.setUTC();
                        result.setZoneNegative(true);
                        flags = 1;
                    }
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case 'Z': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GMONTHDAY + str + "\n'Z' " + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    continue block6;
                }
                case '+': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GMONTHDAY + str + "\n'+' " + "is wrongly placed.", idx);
                    }
                    if (!has2Digits) throw new ParseException(BAD_GMONTHDAY + str + "\nTthe day field must have 2 digits.", idx);
                    result.setDay(number);
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case ':': {
                    if (flags != 1) {
                        throw new ParseException(BAD_GMONTHDAY + str + "\n':' " + "is wrongly placed.", idx);
                    }
                    number2 = number;
                    number = -1;
                    flags = 0;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
            }
            if ('0' > ch || ch > '9') throw new ParseException(str + ": Invalid character: " + ch, idx);
            if (hasNumber) {
                number = (short)(number * 10 + (ch - 48));
                has2Digits = true;
                continue;
            }
            hasNumber = true;
            number = (short)(ch - 48);
        }
        if (flags != 3 && flags != 0) {
            throw new ParseException(BAD_GMONTHDAY + str + "\nA gMonthDay must follow the pattern --MM-DD(Z|((+|-)hh:mm)).", idx);
        }
        if (flags == 3) {
            if (!has2Digits) throw new ParseException(BAD_GMONTHDAY + str + "\nThe day field must have 2 digits.", idx);
            result.setDay(number);
            return result;
        } else {
            if (flags != 0) return result;
            if (number == -1) throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
            result.setZone(number2, number);
        }
        return result;
    }

    public short getCentury() {
        String err = "GMonthDay: couldn't access to the Century field.";
        throw new OperationNotSupportedException(err);
    }

    public void setCentury(short century) {
        String err = "GMonthDay: couldn't access to the Century field.";
        throw new OperationNotSupportedException(err);
    }

    public short getYear() {
        String err = "GMonthDay: couldn't access to the Year field.";
        throw new OperationNotSupportedException(err);
    }

    public void setYear(short year) {
        String err = "GMonthDay: couldn't access to the Year field.";
        throw new OperationNotSupportedException(err);
    }

    public void setNegative() {
        String err = "GMonthDay: couldn't set the type to be negative.";
        throw new OperationNotSupportedException(err);
    }
}

