/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.grafics;

import com.mayastudios.mscl.grafics.CColorEx;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.GeneralPath;

public class GrafixFactory {
    public static final int GRIPPER_POINT_DEFAULT_SPACING = 1;
    public static final Dimension GRIPPER_POINT_SIZE = new Dimension(3, 3);
    public static final CColorEx GRIPPER_LIGHT = new CColorEx(SystemColor.controlLtHighlight);
    public static final CColorEx GRIPPER_DARK = new CColorEx(SystemColor.controlShadow);
    public static final Color RAISED_BORDER = SystemColor.controlLtHighlight;
    public static final Color LOWERED_BORDER = SystemColor.controlShadow;

    private GrafixFactory() {
    }

    public static void paintGripperPoint(Graphics2D graphics2D, int n, int n2) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(GRIPPER_LIGHT);
        graphics2D.fillRect(n + 1, n2 + 1, 2, 2);
        graphics2D.setColor(GRIPPER_DARK);
        graphics2D.fillRect(n, n2, 2, 2);
        graphics2D.setColor(color);
    }

    public static void paintFlatButtonBorder(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        GrafixFactory.paintFlatButtonBorder(graphics2D, rectangle, bl, RAISED_BORDER, LOWERED_BORDER);
    }

    public static void paintFlatButtonBorder(Graphics2D graphics2D, Rectangle rectangle, boolean bl, Color color, Color color2) {
        GeneralPath generalPath = new GeneralPath();
        if (bl) {
            graphics2D.setColor(color);
        } else {
            graphics2D.setColor(color2);
        }
        generalPath.moveTo(rectangle.x, rectangle.y + rectangle.height - 1);
        generalPath.lineTo(rectangle.x, rectangle.y);
        generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y);
        graphics2D.draw(generalPath);
        if (bl) {
            graphics2D.setColor(color2);
        } else {
            graphics2D.setColor(color);
        }
        generalPath.reset();
        generalPath.moveTo(rectangle.x, rectangle.y + rectangle.height - 1);
        generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y);
        graphics2D.draw(generalPath);
    }
}

