/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt;

import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.focus.FocusManager;
import com.mayastudios.mscl.mwt.focus.IFocusListener;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import com.mayastudios.mscl.mwt.windowcloser.IWindowCloseListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class GUIHelper {
    private static final String ERROR_CLIPBOARD_TITLE = "Fehler beim Kopieren";
    private static final String ERROR_CLIPBOARD_TEXT = "Der Text konnte nicht in die Zwischenablage kopiert werden.";

    public static void initWindow(Window window, String string, int n, int n2, boolean bl, boolean bl2) {
        Serializable serializable;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (bl) {
            if (dimension.width < n) {
                n = dimension.width;
            }
            if (dimension.height < n2) {
                n2 = dimension.height;
            }
            GUIHelper.centerWindow(window, n, n2);
        } else {
            serializable = window.getLocation();
            if (dimension.width < n) {
                n = dimension.width;
                ((Point)serializable).x = 0;
            } else if (dimension.width < ((Point)serializable).x + n) {
                ((Point)serializable).x = dimension.width - n;
            }
            if (dimension.height < n2) {
                n2 = dimension.height;
                ((Point)serializable).y = 0;
            } else if (dimension.height < ((Point)serializable).y + n2) {
                ((Point)serializable).y = dimension.height - n2;
            }
            window.setBounds(((Point)serializable).x, ((Point)serializable).y, n, n2);
        }
        if (window instanceof Frame) {
            serializable = (Frame)window;
            ((Frame)serializable).setTitle(string);
            ((Frame)serializable).setResizable(bl2);
        } else if (window instanceof Dialog) {
            serializable = (Dialog)window;
            ((Dialog)serializable).setTitle(string);
            ((Dialog)serializable).setResizable(bl2);
        }
        window.setVisible(true);
    }

    public static void initWindow(Window window, String string, int n, int n2, boolean bl, boolean bl2, final int n3) {
        GUIHelper.initWindow(window, string, n, n2, bl, bl2, new IWindowCloseListener(){

            public boolean windowClosingPerformed() {
                return true;
            }

            public boolean terminateApp() {
                return true;
            }

            public int getExitCode() {
                return n3;
            }
        });
    }

    public static void initWindow(Window window, String string, int n, int n2, boolean bl, boolean bl2, IWindowCloseListener iWindowCloseListener) {
        CWindowCloser.initObservation(window, iWindowCloseListener);
        GUIHelper.initWindow(window, string, n, n2, bl, bl2, null);
    }

    public static void centerWindow(Window window, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        window.validate();
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getPreferredSize();
        GUIHelper.centerWindow(window, dimension.width, dimension.height);
    }

    public static void setApplicationIcon(JFrame jFrame, ImageIcon imageIcon) {
        jFrame.setIconImage(imageIcon.getImage());
    }

    public static final void enableDynamicLayout(boolean bl) {
        Toolkit.getDefaultToolkit().setDynamicLayout(bl);
    }

    public static void copyToClipboard(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        try {
            class COwner
            implements ClipboardOwner {
                COwner() {
                }

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            }
            clipboard.setContents(stringSelection, new COwner());
        }
        catch (IllegalStateException illegalStateException) {
            MessageBox.showInfoDlg(null, ERROR_CLIPBOARD_TEXT, ERROR_CLIPBOARD_TITLE, MessageBox.EIcon.ERROR);
        }
    }

    public static void focusComponent(Component component) {
        if (component == null) {
            return;
        }
        if (!component.requestFocusInWindow()) {
            component.requestFocus();
        }
    }

    public static void forceFrameToFront(Frame frame) {
        if (frame.isFocusOwner()) {
            return;
        }
        CFrontListener cFrontListener = new CFrontListener(frame);
        frame.addWindowListener(cFrontListener);
        FocusManager.addContainerFocusListener(cFrontListener, frame, true);
        frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
        frame.setVisible(true);
        frame.setAlwaysOnTop(true);
        GUIHelper.focusComponent(frame);
        frame.toFront();
    }

    public static ImageIcon _createTransparentIcon(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        return new ImageIcon(bufferedImage);
    }

    private static class CFrontListener
    extends WindowAdapter
    implements IFocusListener {
        private final Frame m_oFrame;

        public CFrontListener(Frame frame) {
            this.m_oFrame = frame;
        }

        public void windowActivated(WindowEvent windowEvent) {
            this._finish();
        }

        public void focusChanged(Component component, Component component2, IFocusListener.EState eState) {
            this._finish();
        }

        private void _finish() {
            this.m_oFrame.removeWindowListener(this);
            FocusManager.removeFocusListener(this);
            this.m_oFrame.setAlwaysOnTop(false);
        }
    }
}

