/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane;

import com.mayastudios.mscl.MSCLResLoader;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.dockpane.ADockableTab;
import com.mayastudios.mscl.mwt.dockpane.DockPaneGfxFactory;
import com.mayastudios.mscl.mwt.dockpane.ITabListener;
import com.mayastudios.mscl.mwt.dockpane.ITabStateListener;
import com.mayastudios.mscl.mwt.widgets.ABoundsHelperPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class CTab
extends ABoundsHelperPanel
implements MouseListener,
MouseMotionListener {
    private static final int PADDING_LEFT = 6;
    private static final int PADDING_TOP = 2;
    private static final int PADDING_BOTTOM = 2;
    private static final int PADDING_RIGHT = 6;
    private static final ImageIcon CLOSE_TAB_IMAGE;
    private static final ImageIcon CLOSE_TAB_ACTIVE_IMAGE;
    private static final int CLOSE_BUTTON_GAP = 6;
    private static final int CLOSE_BUTTON_ADDITIONAL_MOUSE_SPACE = 2;
    private static final Color FOCUSED_TAB_UPPER_COLOR;
    private static final Color HOVER_TAB_UPPER_COLOR;
    private static final Font TAB_FONT;
    private static final Color UNFOCUSED_TEXT_COLOR;
    private static final Color FOCUSED_TEXT_COLOR;
    static final int MIN_TAB_WIDTH;
    static final int MIN_TAB_HEIGHT = 18;
    private final ADockableTab mf_oTab;
    private final JLabel mf_oCaption = new JLabel();
    private final Rectangle mf_oCloseButtonRect = new Rectangle(CLOSE_TAB_IMAGE.getIconWidth(), CLOSE_TAB_IMAGE.getIconHeight());
    private ETabState m_eState = ETabState.NORMAL;
    private Point m_oMouseOverPoint = null;
    private BufferedImage m_oComponentImage = null;
    private boolean m_bNeedRepaint = false;

    CTab(ADockableTab aDockableTab) {
        super(true);
        this.mf_oTab = aDockableTab;
        this.mf_oTab.setAssociatedTab(this);
        this.mf_oCaption.setFont(TAB_FONT);
        this.add(this.mf_oCaption);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mf_oCaption.addMouseListener(this);
        this.mf_oCaption.addMouseMotionListener(this);
        this.propertiesChangedListener();
    }

    void removeFromCurrentTabBar() {
        ((ITabListener)((Object)this.getParent())).removeTab(this);
        this.mf_oTab.setAssociatedTab(null);
    }

    ADockableTab getTab() {
        return this.mf_oTab;
    }

    ETabState getState() {
        return this.m_eState;
    }

    void setState(ETabState eTabState) {
        if (this.m_eState == eTabState) {
            return;
        }
        this.m_eState = eTabState;
        this._requestRepaint();
        switch (eTabState) {
            case FOCUSED: {
                this.mf_oTab.fireStateChangeEvent(ITabStateListener.EState.ACTIVATED);
                break;
            }
            case CURRENT: {
                this.mf_oTab.fireStateChangeEvent(ITabStateListener.EState.FOCUS_LOST);
                break;
            }
            default: {
                this.mf_oTab.fireStateChangeEvent(ITabStateListener.EState.DEACTIVATED);
            }
        }
    }

    void propertiesChangedListener() {
        this.mf_oCaption.setText(this.mf_oTab.getCaption());
        this.mf_oCaption.setIcon(this.mf_oTab.getIcon());
        this.mf_oCaption.setToolTipText(this.mf_oTab.getTooltip());
        this.mf_oCaption.validate();
        Dimension dimension = this.mf_oCaption.getPreferredSize();
        dimension.width += 12 + CLOSE_TAB_IMAGE.getIconWidth() + 6;
        dimension.height = Math.max(dimension.height, CLOSE_TAB_IMAGE.getIconHeight()) + 2 + 2;
        this.setPreferredSize(dimension);
        this._requestRepaint();
        if (this.getParent() != null) {
            ((ITabListener)((Object)this.getParent())).arrangeTabBar();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.m_oMouseOverPoint = mouseEvent.getPoint();
        if (this._isMouseOnCloseButton()) {
            this.mf_oTab.closeTab();
        } else {
            if (this.m_eState == ETabState.FOCUSED) {
                return;
            }
            ((ITabListener)((Object)this.getParent())).changeFocusedTab(this);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_oMouseOverPoint = mouseEvent.getPoint();
        this._requestRepaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_oMouseOverPoint = null;
        this._requestRepaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_oMouseOverPoint = mouseEvent.getPoint();
        this._requestRepaint();
    }

    private void _requestRepaint() {
        this.m_bNeedRepaint = true;
        super.repaint();
    }

    protected void boundsChanged(int n, int n2, ABoundsHelperPanel.EChangeType eChangeType) {
        Rectangle rectangle = new Rectangle();
        int n3 = this.mf_oCaption.getPreferredSize().height;
        if (eChangeType.isResized()) {
            this.m_oComponentImage = new BufferedImage(n, n2, 1);
        }
        this._requestRepaint();
        this.mf_oCloseButtonRect.x = n - 6 - this.mf_oCloseButtonRect.width;
        this.mf_oCloseButtonRect.y = (n2 - this.mf_oCloseButtonRect.height) / 2 + 1;
        rectangle.x = 6;
        rectangle.y = (n2 - n3) / 2;
        rectangle.width = this.mf_oCloseButtonRect.x - 6 - rectangle.x;
        rectangle.height = n3;
        if (rectangle.width > 10) {
            this.mf_oCaption.setBounds(rectangle);
            this.mf_oCaption.setVisible(true);
        } else {
            this.mf_oCaption.setVisible(false);
        }
    }

    private boolean _isMouseOnCloseButton() {
        if (this.m_oMouseOverPoint == null) {
            return false;
        }
        return this.m_oMouseOverPoint.x >= this.mf_oCloseButtonRect.x - 2 && this.m_oMouseOverPoint.x < this.mf_oCloseButtonRect.x + this.mf_oCloseButtonRect.width + 2 && this.m_oMouseOverPoint.y >= this.mf_oCloseButtonRect.y - 2 && this.m_oMouseOverPoint.y < this.mf_oCloseButtonRect.y + this.mf_oCloseButtonRect.height + 2;
    }

    protected void paintComponent(Graphics2D graphics2D) {
        if (this.m_oComponentImage != null) {
            if (this.m_bNeedRepaint && this.m_oComponentImage != null) {
                this._prepaintComponent();
                this.m_bNeedRepaint = false;
            }
            graphics2D.drawImage((Image)this.m_oComponentImage, 0, 0, this);
        }
    }

    private void _prepaintComponent() {
        Graphics2D graphics2D = (Graphics2D)this.m_oComponentImage.getGraphics();
        int n = this.getWidth();
        int n2 = this.getHeight();
        GeneralPath generalPath = new GeneralPath();
        Color color = UNFOCUSED_TEXT_COLOR;
        graphics2D.setColor(DockPaneGfxFactory.BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, n, n2);
        if (this.m_eState == ETabState.FOCUSED || this.m_eState == ETabState.CURRENT) {
            generalPath.moveTo(0.0f, n2);
            generalPath.lineTo(0.0f, 8.0f);
            generalPath.append(DockPaneGfxFactory.createRoundedCorner(0, 0, true, true), true);
            generalPath.lineTo(n - 8 - 1, 0.0f);
            generalPath.append(DockPaneGfxFactory.createRoundedCorner(n - 8 - 1, 0, false, true), true);
            generalPath.lineTo(n - 1, n2);
            GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
            generalPath2.closePath();
            Color color2 = FOCUSED_TAB_UPPER_COLOR;
            Color color3 = DockPaneGfxFactory.FOCUSED_FRAME_COLOR;
            color = FOCUSED_TEXT_COLOR;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n2, color3));
            graphics2D.fill(generalPath2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(DockPaneGfxFactory.FRAME_COLOR);
            graphics2D.draw(generalPath);
            if (this.getLocation().x == 0) {
                graphics2D.drawLine(7, 0, n - 1, 0);
            } else {
                graphics2D.drawLine(0, 0, n - 1, 0);
            }
        } else {
            generalPath.moveTo(n - 1, n2 - 1);
            generalPath.lineTo(0.0f, n2 - 1);
            if (this.getLocation().x == 0) {
                generalPath.lineTo(0.0f, 8.0f);
                generalPath.append(DockPaneGfxFactory.createRoundedCorner(0, 0, true, true), true);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                generalPath.moveTo(0.0f, 0.0f);
            }
            generalPath.lineTo(n - 1, 0.0f);
            if (this.m_oMouseOverPoint != null) {
                GeneralPath generalPath3;
                if (this.getLocation().x == 0) {
                    generalPath3 = (GeneralPath)generalPath.clone();
                    generalPath3.lineTo(n - 1, n2 - 1);
                } else {
                    generalPath3 = new GeneralPath();
                    generalPath3.append(new Rectangle2D.Double(0.0, 0.0, n - 1, n2 - 1), false);
                }
                Color color4 = DockPaneGfxFactory.BACKGROUND_COLOR;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, HOVER_TAB_UPPER_COLOR, 0.0f, n2, color4));
                graphics2D.fill(generalPath3);
            }
            if (this.m_eState != ETabState.NEXT_TO_CURRENT) {
                generalPath.lineTo(n - 1, n2 - 1);
            }
            graphics2D.setColor(DockPaneGfxFactory.FRAME_COLOR);
            graphics2D.draw(generalPath);
        }
        if (this.m_eState == ETabState.FOCUSED || this.m_eState == ETabState.CURRENT || this.m_oMouseOverPoint != null) {
            if (this._isMouseOnCloseButton()) {
                CLOSE_TAB_ACTIVE_IMAGE.paintIcon(this, graphics2D, this.mf_oCloseButtonRect.x, this.mf_oCloseButtonRect.y);
            } else {
                CLOSE_TAB_IMAGE.paintIcon(this, graphics2D, this.mf_oCloseButtonRect.x, this.mf_oCloseButtonRect.y);
            }
        }
        this.mf_oCaption.setForeground(color);
    }

    static {
        FOCUSED_TAB_UPPER_COLOR = new Color(2, 68, 228);
        HOVER_TAB_UPPER_COLOR = Color.WHITE;
        TAB_FONT = new Font("Dialog", 0, 11);
        UNFOCUSED_TEXT_COLOR = Color.BLACK;
        FOCUSED_TEXT_COLOR = Color.WHITE;
        try {
            CLOSE_TAB_IMAGE = MSCLResLoader.LOADER.getIconExcpt("mwt/dockpane/tab-close.png");
            CLOSE_TAB_ACTIVE_IMAGE = MSCLResLoader.LOADER.getIconExcpt("mwt/dockpane/tab-close-active.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
        MIN_TAB_WIDTH = 16 + CLOSE_TAB_IMAGE.getIconWidth() - 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ETabState {
        FOCUSED,
        CURRENT,
        NORMAL,
        NEXT_TO_CURRENT;

    }
}

