/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane;

import com.mayastudios.mscl.MSCLResLoader;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.dockpane.CTab;
import com.mayastudios.mscl.mwt.dockpane.CTabView;
import com.mayastudios.mscl.mwt.dockpane.DockPaneGfxFactory;
import com.mayastudios.mscl.mwt.popup.CPopup;
import com.mayastudios.mscl.mwt.popup.CTooltipStyledPopup;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CTabOverflowWidget
extends APaintHelperPanel
implements MouseListener {
    static final int PREFERRED_WIDTH = 28;
    private static final ImageIcon TAB_OVERFLOW_IMAGE;
    private static final Font TAB_OVERFLOW_FONT;
    private static final Color OVERFLOW_TEXT_COLOR;
    private final Vector<CTab> mf_oTabs;
    private int m_iTabOverflowCount = 0;
    private boolean m_bIsMouseOver = false;
    private CPopup m_oWindowList = null;
    private CPopupTabList m_oTabListContent = new CPopupTabList();

    CTabOverflowWidget(Vector<CTab> vector) {
        this.mf_oTabs = vector;
        this.addMouseListener(this);
    }

    void updateOverflowCount() {
        this.m_iTabOverflowCount = this.m_oTabListContent.updateList(this.mf_oTabs);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics2D graphics2D) {
        if (this.m_iTabOverflowCount == 0) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(DockPaneGfxFactory.BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, n, n2);
        if (this.m_bIsMouseOver) {
            DockPaneGfxFactory.paintRoundedBorder(graphics2D, new Rectangle(1, 1, n - 3, n2 - 3), true);
        }
        TAB_OVERFLOW_IMAGE.paintIcon(this, graphics2D, 5, 3);
        graphics2D.setFont(TAB_OVERFLOW_FONT);
        graphics2D.setColor(OVERFLOW_TEXT_COLOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString(Integer.toString(this.m_iTabOverflowCount), 9, 16);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        CTabView cTabView = (CTabView)this.getParent();
        if (this.m_oWindowList == null) {
            this.m_oWindowList = new CPopup((Window)this.getTopLevelAncestor(), this.m_oTabListContent);
        }
        cTabView.requestFocusOnContentPanel();
        this.m_oWindowList.show(this, 15, this.getHeight());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_bIsMouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.m_bIsMouseOver = false;
        this.repaint();
    }

    private void focusNewTab(CTab cTab) {
        ((CTabView)this.getParent()).changeFocusedTab(cTab);
    }

    static {
        TAB_OVERFLOW_FONT = new Font("Dialog", 0, 8);
        OVERFLOW_TEXT_COLOR = Color.BLACK;
        try {
            TAB_OVERFLOW_IMAGE = MSCLResLoader.LOADER.getIconExcpt("mwt/dockpane/tabbar-overflow.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CPopupTabList
    extends CTooltipStyledPopup {
        CPopupTabList() {
            this.setLayout(new GridLayout(0, 1));
        }

        int updateList(Vector<CTab> vector) {
            int n = 0;
            this.removeAll();
            for (int i = 0; i < vector.size(); ++i) {
                CTab cTab = vector.get(i);
                this.add(new CListEntry(cTab));
                if (cTab.isVisible()) continue;
                ++n;
            }
            return n;
        }

        private class CListEntry
        extends JLabel
        implements MouseListener {
            private CTab m_oAssociatedTab;

            CListEntry(CTab cTab) {
                this.m_oAssociatedTab = cTab;
                this.setText(cTab.getTab().getCaption());
                this.setIcon(cTab.getTab().getIcon());
                this.setBackground(DockPaneGfxFactory.TAB_OVERFLOW_LIST_HIGHLIGHT_COLOR);
                if (!cTab.isVisible()) {
                    this.setFont(DockPaneGfxFactory.TAB_OVERFLOW_LIST_FONT_BOLD);
                    this.setForeground(DockPaneGfxFactory.TAB_OVERFLOW_LIST_INVISIBLE_TEXT_COLOR);
                } else {
                    if (cTab.getState() == CTab.ETabState.FOCUSED || cTab.getState() == CTab.ETabState.CURRENT) {
                        this.setFont(DockPaneGfxFactory.TAB_OVERFLOW_LIST_FONT_BOLD);
                    } else {
                        this.setFont(DockPaneGfxFactory.TAB_OVERFLOW_LIST_FONT_PLAIN);
                    }
                    this.setForeground(DockPaneGfxFactory.TAB_OVERFLOW_LIST_VISIBLE_TEXT_COLOR);
                }
                this.addMouseListener(this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                CTabOverflowWidget.this.focusNewTab(this.m_oAssociatedTab);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.setOpaque(true);
                this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.setOpaque(false);
                this.repaint();
            }
        }
    }
}

