/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane;

import com.mayastudios.mscl.mwt.dockpane.ADockableTab;
import com.mayastudios.mscl.mwt.dockpane.ATabPanel;
import com.mayastudios.mscl.mwt.dockpane.AView;
import com.mayastudios.mscl.mwt.dockpane.CDockPane;
import com.mayastudios.mscl.mwt.dockpane.CTab;
import com.mayastudios.mscl.mwt.dockpane.CTabOverflowWidget;
import com.mayastudios.mscl.mwt.dockpane.DockPaneGfxFactory;
import com.mayastudios.mscl.mwt.dockpane.toolbar.CToolbar;
import com.mayastudios.mscl.mwt.focus.FocusManager;
import com.mayastudios.mscl.mwt.focus.IFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

class CTabView
extends AView {
    private static final int MIN_WIDTH = CTab.MIN_TAB_WIDTH + CTabView._getTabControlsWidth() + 28;
    private final Vector<CTab> mf_oTabs = new Vector();
    private final CTabOverflowWidget mf_oTabOverflowWidget = new CTabOverflowWidget(this.mf_oTabs);
    private final Dimension mf_oTabBarSize = new Dimension(0, 18);
    private final CRecentStack mf_oRecentStack = new CRecentStack();
    private boolean m_bIsFocused = false;
    private boolean m_bPushToolbarDown = false;

    CTabView(boolean bl) {
        super(bl, CTabView._calcMinimumSize(18));
        this.add(this.mf_oTabOverflowWidget);
    }

    private static Dimension _calcMinimumSize(int n) {
        return new Dimension(MIN_WIDTH, n + 1);
    }

    private int _getSpaceBelowTabbar() {
        if (this.mf_oRecentStack.getLength() == 0) {
            return 0;
        }
        CToolbar cToolbar = this.mf_oRecentStack.getFirst().getTab().getToolbar();
        if (cToolbar == null || !this.m_bPushToolbarDown) {
            return 0;
        }
        return cToolbar.getPreferredSize().height;
    }

    void addTab(ADockableTab aDockableTab) {
        CTab cTab = new CTab(aDockableTab);
        this.mf_oTabs.add(cTab);
        this.mf_oRecentStack.add(cTab);
        this.add(cTab);
        this._changeFocusedTab(cTab, true);
    }

    private static int _getTabControlsWidth() {
        return 8;
    }

    public void arrangeTabBar() {
        CTab cTab;
        if (this.mf_oTabs.size() == 0) {
            this.mf_oTabOverflowWidget.setVisible(false);
            return;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        CTab cTab2 = this.mf_oRecentStack.getFirst();
        int n = rectangle.width - CTabView._getTabControlsWidth() - 28;
        CToolbar cToolbar = cTab2.getTab().getToolbar();
        int n2 = 0;
        CTab cTab3 = null;
        int n3 = 0;
        boolean bl = true;
        this.mf_oTabBarSize.width = 0;
        this.mf_oTabBarSize.height = 18;
        if (cToolbar != null) {
            n2 = cToolbar.getPreferredSize().width;
        }
        this.m_bPushToolbarDown = false;
        this.mf_oRecentStack.resetIterator();
        while (this.mf_oRecentStack.hasNextElement()) {
            cTab = this.mf_oRecentStack.doIteration();
            Dimension dimension = cTab.getPreferredSize();
            if (bl) {
                if (this.mf_oTabBarSize.width + dimension.width > n - (this.m_bPushToolbarDown ? 0 : n2)) {
                    if (!this.m_bPushToolbarDown && n3 <= 3 && this.mf_oTabBarSize.width + dimension.width <= n) {
                        this.m_bPushToolbarDown = true;
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    cTab3 = cTab;
                    ++n3;
                    this.mf_oTabBarSize.width += dimension.width;
                }
            }
            if (cTab.getState() == CTab.ETabState.NEXT_TO_CURRENT) {
                cTab.setState(CTab.ETabState.NORMAL);
            }
            if (dimension.height > this.mf_oTabBarSize.height) {
                this.mf_oTabBarSize.height = dimension.height;
            }
            if (cTab.getTab().getToolbar() == null) continue;
            Dimension dimension2 = cTab.getTab().getToolbar().getPreferredSize();
            if (dimension2.height <= this.mf_oTabBarSize.height) continue;
            this.mf_oTabBarSize.height = dimension2.height;
        }
        this.mf_oTabBarSize.height += 2;
        this.setMinimumSize(CTabView._calcMinimumSize(this.mf_oTabBarSize.height));
        if (cTab3 == null) {
            for (int i = 0; i < this.mf_oTabs.size(); ++i) {
                this.mf_oTabs.get(i).setVisible(false);
            }
            cTab2.setBounds(0, 0, n, this.mf_oTabBarSize.height);
            cTab2.setVisible(true);
            this.mf_oTabOverflowWidget.setBounds(n, 1, 28, this.mf_oTabBarSize.height - 2);
            this.mf_oTabOverflowWidget.updateOverflowCount();
            this.mf_oTabOverflowWidget.setVisible(true);
        } else {
            cTab = null;
            int n4 = 0;
            int n5 = 0;
            block2: for (int i = 0; i < this.mf_oTabs.size(); ++i) {
                CTab cTab4 = this.mf_oTabs.get(i);
                if (n3 > 0) {
                    CTab cTab5;
                    int n6 = cTab4.getPreferredSize().width;
                    this.mf_oRecentStack.resetIterator();
                    do {
                        if ((cTab5 = this.mf_oRecentStack.doIteration()) != cTab4) continue;
                        cTab4.setBounds(n5, 0, n6, this.mf_oTabBarSize.height);
                        cTab4.setVisible(true);
                        --n3;
                        n5 += n6;
                        if ((cTab4.getState() == CTab.ETabState.FOCUSED || cTab4.getState() == CTab.ETabState.CURRENT) && cTab != null) {
                            cTab.setState(CTab.ETabState.NEXT_TO_CURRENT);
                        }
                        cTab = cTab4;
                        continue block2;
                    } while (cTab5 != cTab3);
                    cTab4.setVisible(false);
                    ++n4;
                    continue;
                }
                cTab4.setVisible(false);
                ++n4;
            }
            if (n4 == 0) {
                this.mf_oTabOverflowWidget.setVisible(false);
            } else {
                this.mf_oTabOverflowWidget.setBounds(this.mf_oTabBarSize.width, 1, 28, this.mf_oTabBarSize.height - 2);
                this.mf_oTabOverflowWidget.updateOverflowCount();
                this.mf_oTabOverflowWidget.setVisible(true);
            }
            if (cToolbar != null) {
                Dimension dimension = cToolbar.getPreferredSize();
                if (this.m_bPushToolbarDown) {
                    cToolbar.setBounds(rectangle.width - dimension.width - 3, this.mf_oTabBarSize.height + 2, dimension.width, dimension.height);
                } else {
                    cToolbar.setBounds(rectangle.width - CTabView._getTabControlsWidth() - dimension.width - 1, 1, dimension.width, dimension.height);
                }
                cToolbar.validate();
            }
            this._fitFocusedContentPanel();
        }
    }

    protected void paintComponent(Graphics2D graphics2D) {
        int n = 0;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this._getSpaceBelowTabbar();
        GeneralPath generalPath = new GeneralPath();
        graphics2D.setColor(DockPaneGfxFactory.BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, n2, n3);
        if (this.mf_oTabs.size() == 0) {
            generalPath.moveTo(0.0f, this.mf_oTabBarSize.height - 1);
            generalPath.lineTo(0.0f, 8.0f);
            generalPath.append(DockPaneGfxFactory.createRoundedCorner(0, 0, true, true), true);
        } else {
            generalPath.moveTo(this.mf_oTabBarSize.width, 0.0f);
        }
        generalPath.lineTo(n2 - 8 - 1, 0.0f);
        generalPath.append(DockPaneGfxFactory.createRoundedCorner(n2 - 8 - 1, 0, false, true), true);
        generalPath.lineTo(n2 - 1, this.mf_oTabBarSize.height);
        graphics2D.setColor(DockPaneGfxFactory.FRAME_COLOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.draw(generalPath);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        n = this.mf_oTabBarSize.height;
        graphics2D.drawRect(0, n - 1, n2 - 1, n3 - n);
        if (n4 != 0) {
            graphics2D.drawLine(0, n += n4 + 2, n2 - 1, n);
        }
        graphics2D.setColor(DockPaneGfxFactory.FOCUSED_FRAME_COLOR);
        graphics2D.drawRect(1, this.mf_oTabBarSize.height, n2 - 2 - 1, n3 - this.mf_oTabBarSize.height - 2);
        graphics2D.drawRect(2, this.mf_oTabBarSize.height + 1, n2 - 4 - 1, n3 - this.mf_oTabBarSize.height - 4);
    }

    protected void layoutContainer() {
        if (this.mf_oTabs.size() == 0) {
            return;
        }
        this.arrangeTabBar();
        this._fitFocusedContentPanel();
    }

    private void _fitFocusedContentPanel() {
        ATabPanel aTabPanel = this.mf_oRecentStack.getFirst().getTab().getContentPanel();
        ((Component)aTabPanel).setBounds(this._getContentRect());
        aTabPanel.validate();
    }

    private Rectangle _getContentRect() {
        Rectangle rectangle = new Rectangle(this.getSize());
        int n = this._getSpaceBelowTabbar();
        rectangle.x = 3;
        rectangle.y = this.mf_oTabBarSize.height + 2;
        rectangle.width -= 6;
        rectangle.height -= 5 + this.mf_oTabBarSize.height;
        if (n != 0) {
            rectangle.y += 1 + n;
            rectangle.height -= 1 + n;
        }
        return rectangle;
    }

    public void changeFocusedTab(CTab cTab) {
        this._changeFocusedTab(cTab, true);
    }

    private void _changeFocusedTab(CTab cTab, boolean bl) {
        ADockableTab aDockableTab;
        CTab cTab2 = null;
        assert (cTab == null || this.mf_oRecentStack.getLength() > 0);
        if (cTab != null && cTab.getState() == CTab.ETabState.FOCUSED) {
            assert (cTab == this.mf_oRecentStack.getFirst());
            return;
        }
        if (this.mf_oRecentStack.getLength() > 0) {
            cTab2 = this.mf_oRecentStack.getFirst();
        }
        if (cTab != null) {
            CDockPane cDockPane;
            aDockableTab = cTab.getTab();
            this.mf_oRecentStack.moveToFront(cTab);
            cTab.setState(CTab.ETabState.CURRENT);
            this._fitFocusedContentPanel();
            if (aDockableTab.getContentPanel().getParent() == null) {
                this.add(aDockableTab.getContentPanel());
                if (aDockableTab.getToolbar() != null) {
                    this.add(aDockableTab.getToolbar());
                }
            }
            if ((cDockPane = this.getDockPane()) != null) {
                cDockPane.setMostRecentTab(cTab.getTab());
            }
            this.requestFocusOnContentPanel();
        }
        if (cTab2 != null && cTab2 != cTab) {
            aDockableTab = cTab2.getTab();
            cTab2.setState(CTab.ETabState.NORMAL);
            assert (aDockableTab.getContentPanel().getParent() == this);
            this.remove(aDockableTab.getContentPanel());
            if (aDockableTab.getToolbar() != null) {
                this.remove(aDockableTab.getToolbar());
            }
        }
        this.validate();
        if (bl) {
            this.arrangeTabBar();
        }
    }

    void requestFocusOnContentPanel() {
        FocusManager.focusComponent(this.mf_oRecentStack.getFirst().getTab().getContentPanel());
    }

    public void removeAllTabs() {
        while (this.mf_oTabs.size() > 0) {
            this.removeTab(this.mf_oTabs.get(0));
        }
    }

    public void removeTab(CTab cTab) {
        int n;
        for (n = 0; n < this.mf_oTabs.size() && this.mf_oTabs.get(n) != cTab; ++n) {
        }
        CDockPane cDockPane = this.getDockPane();
        if (cDockPane != null) {
            cDockPane.removeFromRecentList(cTab.getTab());
        }
        if (cTab == this.mf_oRecentStack.getFirst()) {
            if (this.mf_oTabs.size() > 1) {
                if (n == this.mf_oTabs.size() - 1) {
                    this._changeFocusedTab(this.mf_oTabs.get(n - 1), false);
                } else {
                    this._changeFocusedTab(this.mf_oTabs.get(n + 1), false);
                }
            } else {
                this._changeFocusedTab(null, false);
            }
        }
        this.mf_oTabs.remove(n);
        this.mf_oRecentStack.remove(cTab);
        this.remove(cTab);
        this.arrangeTabBar();
        this.repaint();
        if (this.mf_oTabs.size() == 0) {
            this.m_bIsFocused = false;
        }
    }

    public boolean acceptClick(MouseEvent mouseEvent) {
        return true;
    }

    public void focusChanged(Component component, Component component2, IFocusListener.EState eState) {
        if (eState != IFocusListener.EState.LOST) {
            if (this.mf_oTabs.size() != 0) {
                ADockableTab aDockableTab = this.mf_oRecentStack.getFirst().getTab();
                this.getDockPane().setMostRecentTab(aDockableTab);
                if (component == this) {
                    FocusManager.focusComponent(aDockableTab.getContentPanel());
                }
            }
            this._focusRefresh(true);
        } else {
            this._focusRefresh(false);
        }
    }

    private void _focusRefresh(boolean bl) {
        boolean bl2 = false;
        if (this.mf_oTabs.size() != 0) {
            CTab.ETabState eTabState = bl ? CTab.ETabState.FOCUSED : CTab.ETabState.CURRENT;
            CTab cTab = this.mf_oRecentStack.getFirst();
            if (cTab.getState() != eTabState) {
                this.mf_oRecentStack.getFirst().setState(eTabState);
                bl2 = true;
            }
        }
        if (this.m_bIsFocused != bl) {
            this.m_bIsFocused = bl;
            bl2 = true;
        }
        if (bl2) {
            this.repaint();
        }
    }

    boolean isOnlyOneTabLeft() {
        return this.mf_oTabs.size() == 1;
    }

    ADockableTab getFocusedTab() {
        CTab cTab = this.mf_oRecentStack.getFirst();
        if (cTab != null && cTab.getState() == CTab.ETabState.FOCUSED) {
            return cTab.getTab();
        }
        return null;
    }

    private class CRecentStack {
        private LinkedList<CTab> m_oStack = new LinkedList();
        private ListIterator<CTab> m_oCurPos = null;

        private CRecentStack() {
        }

        final void add(CTab cTab) {
            this.m_oStack.addLast(cTab);
        }

        void remove(CTab cTab) {
            for (int i = 0; i < this.m_oStack.size(); ++i) {
                if (this.m_oStack.get(i) != cTab) continue;
                this.m_oStack.remove(i);
                return;
            }
            throw new IllegalArgumentException("tab is not in list");
        }

        final void moveToFront(CTab cTab) {
            this.remove(cTab);
            this.m_oStack.addFirst(cTab);
        }

        final CTab getFirst() {
            return this.m_oStack.getFirst();
        }

        final CTab getTabAt(int n) {
            return this.m_oStack.get(n);
        }

        final int getLength() {
            return this.m_oStack.size();
        }

        final void resetIterator() {
            this.m_oCurPos = this.m_oStack.listIterator();
        }

        final boolean hasNextElement() {
            return this.m_oCurPos.hasNext();
        }

        final CTab doIteration() {
            return this.m_oCurPos.next();
        }
    }
}

