/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane.statusbar;

import com.mayastudios.mscl.grafics.GrafixFactory;
import com.mayastudios.mscl.mwt.mouse.CMouseMotionManager;
import com.mayastudios.mscl.mwt.mouse.IMouseMotionManagerListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class CGripperControl
extends JComponent
implements IMouseMotionManagerListener {
    private static final BufferedImage GRIPPER_IMAGE = CGripperControl._createGripperImage();
    private Window m_oResizableWindow = null;
    private Dimension m_oOriginalWindowSize = null;
    private Point m_oInitialDragPoint = null;

    public CGripperControl() {
        Dimension dimension = new Dimension(GRIPPER_IMAGE.getWidth(), GRIPPER_IMAGE.getHeight());
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setCursor(Cursor.getPredefinedCursor(6));
        CMouseMotionManager cMouseMotionManager = new CMouseMotionManager(this, this);
        cMouseMotionManager.setDragMouseButtons(true, false, false);
    }

    public void setResizableWindow(Window window) {
        this.m_oResizableWindow = window;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(GRIPPER_IMAGE, this.getWidth() - GRIPPER_IMAGE.getWidth(), this.getHeight() - GRIPPER_IMAGE.getHeight(), this);
    }

    private static BufferedImage _createGripperImage() {
        int n = GrafixFactory.GRIPPER_POINT_SIZE.width + 1;
        int n2 = GrafixFactory.GRIPPER_POINT_SIZE.height + 1;
        BufferedImage bufferedImage = new BufferedImage(n * 3, n2 * 3, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        GrafixFactory.paintGripperPoint(graphics2D, 0, n2 * 2);
        GrafixFactory.paintGripperPoint(graphics2D, n, n2);
        GrafixFactory.paintGripperPoint(graphics2D, n, n2 * 2);
        GrafixFactory.paintGripperPoint(graphics2D, n * 2, 0);
        GrafixFactory.paintGripperPoint(graphics2D, n * 2, n2);
        GrafixFactory.paintGripperPoint(graphics2D, n * 2, n2 * 2);
        return bufferedImage;
    }

    public void beginDrag(Point point) {
        this.m_oInitialDragPoint = point;
        SwingUtilities.convertPointToScreen(this.m_oInitialDragPoint, this);
        this.m_oOriginalWindowSize = this.m_oResizableWindow.getSize();
    }

    public void endDrag() {
        this.m_oInitialDragPoint = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, this);
        int n = this.m_oOriginalWindowSize.width + (point.x - this.m_oInitialDragPoint.x);
        int n2 = this.m_oOriginalWindowSize.height + (point.y - this.m_oInitialDragPoint.y);
        this.m_oResizableWindow.setSize(n, n2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

