/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.focus;

import com.mayastudios.mscl.CConsoleHandler;
import com.mayastudios.mscl.Log;
import com.mayastudios.mscl.mwt.focus.IFocusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FocusManager {
    private static boolean s_bLogFocusChanges = false;

    private FocusManager() {
    }

    public static void addComponentFocusListener(IFocusListener iFocusListener, Component component) {
        FocusFilter.addListener(iFocusListener, component, false);
    }

    public static void addContainerFocusListener(IFocusListener iFocusListener, Container container, boolean bl) {
        FocusFilter.addListener(iFocusListener, container, bl);
    }

    public static void removeFocusListener(IFocusListener iFocusListener) {
        FocusFilter.removeListener(iFocusListener);
    }

    public static final void focusComponent(Component component) {
        FocusFilter.setMainFocusComponent(component);
        if (component.isShowing()) {
            ShowUpListener.setComponent(null);
            FocusManager._focusComponent(component);
        } else {
            if (s_bLogFocusChanges) {
                Log.print("Wait for component showing up", component, 29);
            }
            ShowUpListener.setComponent(component);
        }
    }

    private static void _focusComponent(Component component) {
        if (s_bLogFocusChanges) {
            Log.print("Request Focus", component, 29);
        }
        if (!component.requestFocusInWindow()) {
            component.requestFocus();
        }
    }

    public static final void enableLogging(boolean bl) {
        s_bLogFocusChanges = bl;
        FocusLogHandler.enableLogger(bl);
    }

    public static final boolean isLogging() {
        return s_bLogFocusChanges;
    }

    private static class ShowUpListener
    implements HierarchyListener,
    ComponentListener {
        private static ShowUpListener s_oInstance = new ShowUpListener();
        private static Component s_oObservedComponent = null;

        private ShowUpListener() {
        }

        static void setComponent(Component component) {
            if (s_oObservedComponent == component) {
                return;
            }
            if (s_oObservedComponent != null) {
                s_oObservedComponent.removeHierarchyListener(s_oInstance);
                s_oObservedComponent.removeComponentListener(s_oInstance);
            }
            if ((s_oObservedComponent = component) != null) {
                assert (!s_oObservedComponent.isShowing());
                s_oObservedComponent.addHierarchyListener(s_oInstance);
                s_oObservedComponent.addComponentListener(s_oInstance);
            }
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this._checkComponent();
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            this._checkComponent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        private void _checkComponent() {
            if (s_oObservedComponent.isShowing()) {
                Component component = s_oObservedComponent;
                s_oObservedComponent = null;
                component.removeHierarchyListener(this);
                component.removeComponentListener(this);
                FocusManager._focusComponent(component);
            }
        }
    }

    private static final class FocusFilter
    implements PropertyChangeListener {
        private static FocusFilter s_oInstance = new FocusFilter();
        private Vector<CFocusListenerInfo> m_oListenerList = new Vector();
        private Component m_oMainFocusComponent = null;

        private FocusFilter() {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addPropertyChangeListener(this);
        }

        static void addListener(IFocusListener iFocusListener, Component component, boolean bl) {
            FocusFilter.s_oInstance.m_oListenerList.add(new CFocusListenerInfo(iFocusListener, component, bl));
        }

        static synchronized void removeListener(IFocusListener iFocusListener) {
            int n = FocusFilter.s_oInstance.m_oListenerList.size();
            for (int i = 0; i < n; ++i) {
                if (FocusFilter.s_oInstance.m_oListenerList.get(i).getListener() != iFocusListener) continue;
                FocusFilter.s_oInstance.m_oListenerList.remove(i);
            }
        }

        static void setMainFocusComponent(Component component) {
            FocusFilter.s_oInstance.m_oMainFocusComponent = component;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"focusOwner".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Component component = (Component)propertyChangeEvent.getNewValue();
            Component component2 = (Component)propertyChangeEvent.getOldValue();
            if (FocusManager.isLogging()) {
                Log.print("focus changed:\n  to:   " + component + "\n  from: " + component2);
            }
            if (this.m_oMainFocusComponent != null && component == this.m_oMainFocusComponent) {
                this.m_oMainFocusComponent = null;
                this._checkFocusChange(component, component2, true);
            } else {
                this._checkFocusChange(component, component2, false);
            }
        }

        private synchronized void _checkFocusChange(Component component, Component component2, boolean bl) {
            int n = this.m_oListenerList.size();
            for (int i = 0; i < n; ++i) {
                this._handleListener(this.m_oListenerList.get(i), component, component2, bl);
            }
        }

        private void _handleListener(CFocusListenerInfo cFocusListenerInfo, Component component, Component component2, boolean bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (!cFocusListenerInfo.getObservedComponent().isShowing()) {
                return;
            }
            if (this.m_oMainFocusComponent == cFocusListenerInfo.getObservedComponent()) {
                return;
            }
            if (cFocusListenerInfo.doChildNotify()) {
                Container container = (Container)cFocusListenerInfo.getObservedComponent();
                if (container.isAncestorOf(this.m_oMainFocusComponent)) {
                    return;
                }
                if (this.m_oMainFocusComponent == null && (container == component || container.isAncestorOf(component))) {
                    bl2 = true;
                }
                if (container == component2 || container.isAncestorOf(component2)) {
                    bl3 = true;
                }
            } else {
                if (this.m_oMainFocusComponent == null && cFocusListenerInfo.getObservedComponent() == component) {
                    bl2 = true;
                }
                if (cFocusListenerInfo.getObservedComponent() == component2) {
                    bl3 = true;
                }
            }
            if (bl && bl2) {
                bl3 = false;
                component2 = null;
            }
            if (bl2 && bl3) {
                if (FocusManager.isLogging()) {
                    Log.print("---> notify: focus changed:\n  to:" + component + "\n  from:  " + component2, cFocusListenerInfo.getObservedComponent());
                }
                cFocusListenerInfo.getListener().focusChanged(component, component2, IFocusListener.EState.CHANGED);
            } else if (bl2) {
                if (FocusManager.isLogging()) {
                    Log.print("---> notify: focus gained:\n  to: " + component + "\n  from: " + component2, cFocusListenerInfo.getObservedComponent());
                }
                cFocusListenerInfo.getListener().focusChanged(component, component2, IFocusListener.EState.GAINED);
            } else if (bl3) {
                if (FocusManager.isLogging()) {
                    Log.print("---> notify: focus lost:\n  to:" + component + "\n  from:  " + component2, cFocusListenerInfo.getObservedComponent());
                }
                cFocusListenerInfo.getListener().focusChanged(component, component2, IFocusListener.EState.LOST);
            }
        }

        private static class CFocusListenerInfo {
            private Component m_oObservedComponent;
            private IFocusListener m_oListener;
            private boolean m_bChildNotify;

            CFocusListenerInfo(IFocusListener iFocusListener, Component component, boolean bl) {
                assert (component != null);
                assert (iFocusListener != null);
                this.m_oListener = iFocusListener;
                this.m_oObservedComponent = component;
                this.m_bChildNotify = bl;
            }

            final Component getObservedComponent() {
                return this.m_oObservedComponent;
            }

            final IFocusListener getListener() {
                return this.m_oListener;
            }

            final boolean doChildNotify() {
                return this.m_bChildNotify;
            }
        }
    }

    private static class FocusLogHandler {
        private static final String FOCUS_LOGGER_NAME = "java.awt.focus.Component";
        private static FocusLogHandler s_oInstance = new FocusLogHandler();
        private Logger m_oFocusLogger = Logger.getLogger("java.awt.focus.Component");
        private CConsoleHandler m_oHandler = new CConsoleHandler();

        private FocusLogHandler() {
            this.m_oHandler.setLevel(Level.ALL);
            this.m_oFocusLogger.addHandler(this.m_oHandler);
        }

        static void enableLogger(boolean bl) {
            FocusLogHandler.s_oInstance.m_oFocusLogger.setLevel(bl ? Level.ALL : Level.OFF);
        }
    }
}

