/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.tablelayout;

import com.mayastudios.mscl.mwt.tablelayout.ABaseCell;
import com.mayastudios.mscl.mwt.tablelayout.ACellConstructor;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoGlue;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoWidth;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoWidthBindTarget;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellBind;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellFixedWidth;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowAutoGlue;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowAutoHeight;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowFixedHeight;
import com.mayastudios.mscl.mwt.tablelayout.CLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class CTableLayout {
    private final CLayoutManager mf_oManager;
    public final CRowAdder addRow = new CRowAdder();
    public final CCellAdder addCell = new CCellAdder();
    public final CCellProps mf_oProps = new CCellProps();

    private CTableLayout(CLayoutManager cLayoutManager) {
        this.mf_oManager = cLayoutManager;
    }

    public static CTableLayout initLayout(Container container) {
        return CTableLayout.initLayout(container, 0, 0, 0, 0);
    }

    public static CTableLayout initLayout(Container container, int n, int n2, int n3, int n4) {
        CLayoutManager cLayoutManager = new CLayoutManager(container, n, n2, n3, n4);
        container.setLayout(cLayoutManager);
        CTableLayout cTableLayout = new CTableLayout(cLayoutManager);
        return cTableLayout;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.mf_oManager.setMargins(n, n2, n3, n4);
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void setPreferredSize(Dimension dimension) {
        this.mf_oManager.setPreferredSize(dimension);
    }

    public static class CDummyContent
    extends Component {
    }

    public static interface ICell {
    }

    public final class CCellAdder {
        private CCellAdder() {
        }

        public ICell AutoBindCell(Component component) {
            return this.AutoBindCell(component, CTableLayout.this.mf_oProps);
        }

        public ICell AutoBindCell(Component component, CCellProps cCellProps) {
            return this._addNewCell(component, new CInternalCellAutoWidthBindTarget(cCellProps));
        }

        public ICell AutoWidthCell(Component component) {
            return this.AutoWidthCell(component, CTableLayout.this.mf_oProps);
        }

        public ICell AutoWidthCell(Component component, CCellProps cCellProps) {
            return this._addNewCell(component, new CInternalCellAutoWidth(cCellProps));
        }

        public ICell AutoGlueCell(Component component) {
            return this.AutoGlueCell(component, CTableLayout.this.mf_oProps);
        }

        public ICell AutoGlueCell(Component component, CCellProps cCellProps) {
            return this._addNewCell(component, new CInternalCellAutoGlue(cCellProps));
        }

        public ICell BindCell(Component component, ICell iCell) {
            return this.BindCell(component, CTableLayout.this.mf_oProps, iCell);
        }

        public ICell BindCell(Component component, CCellProps cCellProps, ICell iCell) {
            return this.BindCell(component, cCellProps, iCell, false);
        }

        public ICell BindCell(Component component, ICell iCell, boolean bl) {
            return this.BindCell(component, CTableLayout.this.mf_oProps, iCell, bl);
        }

        public ICell BindCell(Component component, CCellProps cCellProps, ICell iCell, boolean bl) {
            return this._addNewCell(component, new CInternalCellBind((ABaseCell)iCell, bl, cCellProps));
        }

        public ICell FixedWidthCell(Component component, int n) {
            return this.FixedWidthCell(component, CTableLayout.this.mf_oProps, n);
        }

        public ICell FixedWidthCell(Component component, CCellProps cCellProps, int n) {
            return this._addNewCell(component, new CInternalCellFixedWidth(n, cCellProps));
        }

        public ICell Cell(Component component, ACellConstructor aCellConstructor) {
            switch (aCellConstructor.mf_eType) {
                case AUTO_WIDTH_BIND_TARGET_CELL: {
                    return this.AutoBindCell(component, aCellConstructor.mf_oProps);
                }
                case AUTO_WIDTH_CELL: {
                    return this.AutoWidthCell(component, aCellConstructor.mf_oProps);
                }
                case AUTO_GLUE_CELL: {
                    return this.AutoGlueCell(component, aCellConstructor.mf_oProps);
                }
                case BIND_CELL: {
                    ACellConstructor.CCellBind cCellBind = (ACellConstructor.CCellBind)aCellConstructor;
                    return this.BindCell(component, cCellBind.mf_oProps, cCellBind.mf_oBindTargetCell, cCellBind.mf_bIgnoreComponentsMinimumWidth);
                }
                case FIXED_WIDTH_CELL: {
                    ACellConstructor.CCellFixedWidth cCellFixedWidth = (ACellConstructor.CCellFixedWidth)aCellConstructor;
                    return this.FixedWidthCell(component, cCellFixedWidth.mf_oProps, cCellFixedWidth.mf_iWidth);
                }
            }
            throw new IllegalArgumentException("Unknown cell type");
        }

        private ICell _addNewCell(Component component, ABaseCell aBaseCell) {
            CTableLayout.this.mf_oManager.addNewCell(component, aBaseCell);
            return aBaseCell;
        }
    }

    public final class CRowAdder {
        private CRowAdder() {
        }

        public void AutoHeightRow() {
            CTableLayout.this.mf_oManager.addNewRow(new CInternalRowAutoHeight());
        }

        public void AutoGlueRow() {
            CTableLayout.this.mf_oManager.addNewRow(new CInternalRowAutoGlue());
        }

        public void FixedHeightRow(int n) {
            CTableLayout.this.mf_oManager.addNewRow(new CInternalRowFixedHeight(n));
        }
    }
}

