/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import com.mayastudios.mscl.mwt.mouse.CMouseMotionManager;
import com.mayastudios.mscl.mwt.mouse.IMouseMotionManagerListener;
import com.mayastudios.mscl.mwt.widgets.TooltipHack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;
import javax.swing.Timer;

public class DockedWindow {
    private final WindowImpl m_window;

    public DockedWindow(Component component, DockingBorder dockingBorder, Dimension dimension) {
        this.m_window = new WindowImpl(component, dockingBorder, dimension);
    }

    public Component getContent() {
        return this.m_window.getContent();
    }

    public void setDockingBorder(DockingBorder dockingBorder) {
        this.m_window.setDockBorder(dockingBorder);
    }

    public DockingBorder getDockingBorder() {
        return this.m_window.getDockBorder();
    }

    public boolean isCurrentlyShowing() {
        return this.m_window.isWindowShowing();
    }

    public boolean isVisible() {
        return this.m_window.isVisible();
    }

    public void setVisible(boolean bl) {
        this.m_window.setVisible(bl);
    }

    private static class WindowImpl
    extends JWindow
    implements ActionListener,
    IMouseMotionManagerListener {
        private static final int SNAP_IN_TOLERANCE = 15;
        private final Timer mf_oMouseTimer = new Timer(50, this);
        public final Dimension m_screenSize = new Dimension();
        public final Insets m_screenInsets = new Insets(0, 0, 0, 0);
        private final Component m_oContent;
        public final Dimension m_visibleBorderSize = new Dimension();
        private DockingBorder m_dockingBorder;
        private boolean m_bIsWindowShowing = false;
        private Point m_oLastDraggedPoint = null;

        public WindowImpl(Component component, DockingBorder dockingBorder, Dimension dimension) {
            this.m_oContent = component;
            this.m_visibleBorderSize.width = dimension.width;
            this.m_visibleBorderSize.height = dimension.height;
            this.updateScreenInformation();
            this.getLayeredPane().add(component);
            CMouseMotionManager cMouseMotionManager = new CMouseMotionManager(this, this);
            cMouseMotionManager.setDragMouseButtons(true, false, false);
            cMouseMotionManager = new CMouseMotionManager(component, this);
            cMouseMotionManager.setDragMouseButtons(true, false, false);
            this.setDockBorder(dockingBorder);
            this.setVisible(true);
            this.setAlwaysOnTop(true);
            this.mf_oMouseTimer.start();
        }

        public boolean isFocused() {
            if (TooltipHack.useHack()) {
                return true;
            }
            return super.isFocused();
        }

        public Component getContent() {
            return this.m_oContent;
        }

        public void setDockBorder(DockingBorder dockingBorder) {
            this.m_dockingBorder = dockingBorder;
            this.hideWindow();
        }

        public DockingBorder getDockBorder() {
            return this.m_dockingBorder;
        }

        public boolean isWindowShowing() {
            return this.m_bIsWindowShowing;
        }

        void updateScreenInformation() {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.m_screenSize.width = dimension.width;
            this.m_screenSize.height = dimension.height;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            this.m_screenInsets.left = insets.left;
            this.m_screenInsets.right = insets.right;
            this.m_screenInsets.top = insets.top;
            this.m_screenInsets.bottom = insets.bottom;
        }

        public void showWindow() {
            Rectangle rectangle = this._getCenterRect();
            switch (this.m_dockingBorder) {
                case LEFT: {
                    rectangle.x = this.m_screenInsets.left;
                    break;
                }
                case RIGHT: {
                    rectangle.x = this.m_screenSize.width - this.m_screenInsets.right - rectangle.width;
                    break;
                }
                case TOP: {
                    rectangle.y = this.m_screenInsets.top;
                    break;
                }
                case BOTTOM: {
                    rectangle.y = this.m_screenSize.height - this.m_screenInsets.bottom - rectangle.height;
                }
            }
            this.setBounds(rectangle);
            this.getRootPane().setSize(rectangle.width, rectangle.height);
            this.getLayeredPane().setSize(rectangle.width, rectangle.height);
            this.m_oContent.setBounds(0, 0, rectangle.width, rectangle.height);
            this.m_bIsWindowShowing = true;
        }

        public void hideWindow() {
            Rectangle rectangle = this._getCenterRect();
            this.m_oContent.setSize(rectangle.width, rectangle.height);
            switch (this.m_dockingBorder) {
                case LEFT: {
                    this.m_oContent.setLocation(this.m_visibleBorderSize.width - rectangle.width, 0);
                    rectangle.x = this.m_screenInsets.left;
                    rectangle.width = this.m_visibleBorderSize.width;
                    break;
                }
                case RIGHT: {
                    rectangle.x = this.m_screenSize.width - this.m_screenInsets.right - this.m_visibleBorderSize.width;
                    rectangle.width = this.m_visibleBorderSize.width;
                    break;
                }
                case TOP: {
                    this.m_oContent.setLocation(0, this.m_visibleBorderSize.height - rectangle.height);
                    rectangle.y = this.m_screenInsets.top;
                    rectangle.height = this.m_visibleBorderSize.height;
                    break;
                }
                case BOTTOM: {
                    rectangle.y = this.m_screenSize.height - this.m_screenInsets.bottom - this.m_visibleBorderSize.height;
                    rectangle.height = this.m_visibleBorderSize.height;
                }
            }
            this.setBounds(rectangle);
            this.m_bIsWindowShowing = false;
        }

        private Rectangle _getCenterRect() {
            Dimension dimension = this.m_oContent.getPreferredSize();
            return new Rectangle((this.m_screenSize.width - dimension.width) / 2, (this.m_screenSize.height - dimension.height) / 2, dimension.width, dimension.height);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowImpl windowImpl = this;
            if (!windowImpl.isVisible() || this.m_oLastDraggedPoint != null) {
                return;
            }
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            this.updateScreenInformation();
            Point point = pointerInfo.getLocation();
            boolean bl = false;
            switch (windowImpl.getDockBorder()) {
                case LEFT: {
                    bl = this.m_screenInsets.left == 0 ? point.x < this.m_visibleBorderSize.width : point.x < this.m_screenInsets.left + this.m_visibleBorderSize.width + 15;
                    bl = bl && point.y >= 0 && point.y <= this.m_screenSize.height;
                    break;
                }
                case RIGHT: {
                    bl = this.m_screenInsets.right == 0 ? point.x > this.m_screenSize.width - this.m_visibleBorderSize.width : point.x > this.m_screenSize.width - this.m_screenInsets.right - this.m_visibleBorderSize.width - 15;
                    bl = bl && point.y >= 0 && point.y <= this.m_screenSize.height;
                    break;
                }
                case TOP: {
                    bl = this.m_screenInsets.top == 0 ? point.y < this.m_visibleBorderSize.height : point.y < this.m_screenInsets.top + this.m_visibleBorderSize.height + 15;
                    bl = bl && point.x >= 0 && point.x <= this.m_screenSize.width;
                    break;
                }
                case BOTTOM: {
                    bl = this.m_screenInsets.bottom == 0 ? point.y > this.m_screenSize.height - this.m_visibleBorderSize.height : point.y > this.m_screenSize.height - this.m_screenInsets.bottom - this.m_visibleBorderSize.height - 15;
                    boolean bl2 = bl = bl && point.x >= 0 && point.x <= this.m_screenSize.width;
                }
            }
            if (!bl) {
                bl = windowImpl.getBounds().contains(point);
            }
            if (bl && !windowImpl.isWindowShowing()) {
                windowImpl.showWindow();
                windowImpl.toFront();
            } else if (!bl && windowImpl.isWindowShowing()) {
                windowImpl.hideWindow();
            }
        }

        public void beginDrag(Point point) {
            this.m_oLastDraggedPoint = point;
            this.showWindow();
        }

        public void endDrag() {
            if (this.m_oLastDraggedPoint == null) {
                return;
            }
            Point point = new Point(MouseInfo.getPointerInfo().getLocation());
            Dimension dimension = this.getSize();
            point.x -= this.m_oLastDraggedPoint.x;
            point.y -= this.m_oLastDraggedPoint.y;
            if (point.x <= this.m_screenInsets.left + 15) {
                this.m_dockingBorder = DockingBorder.LEFT;
            } else if (point.x + dimension.width >= this.m_screenSize.width - this.m_screenInsets.right - 15) {
                this.m_dockingBorder = DockingBorder.RIGHT;
            } else if (point.y <= this.m_screenInsets.top + 15) {
                this.m_dockingBorder = DockingBorder.TOP;
            } else if (point.y + dimension.height >= this.m_screenSize.height - this.m_screenInsets.bottom - 15) {
                this.m_dockingBorder = DockingBorder.BOTTOM;
            }
            this.m_oLastDraggedPoint = null;
            this.hideWindow();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_oLastDraggedPoint == null) {
                return;
            }
            Point point = new Point(MouseInfo.getPointerInfo().getLocation());
            Dimension dimension = this.getSize();
            point.x -= this.m_oLastDraggedPoint.x;
            point.y -= this.m_oLastDraggedPoint.y;
            if (point.x <= this.m_screenInsets.left + 15) {
                point.x = 0;
            } else if (point.x + dimension.width >= this.m_screenSize.width - this.m_screenInsets.right - 15) {
                point.x = this.m_screenSize.width;
            } else if (point.y <= this.m_screenInsets.top + 15) {
                point.y = 0;
            } else if (point.y + dimension.height >= this.m_screenSize.height - this.m_screenInsets.bottom - 15) {
                point.y = this.m_screenSize.height;
            }
            point.x = Math.max(point.x, this.m_screenInsets.left);
            point.x = Math.min(point.x, this.m_screenSize.width - this.m_screenInsets.right - dimension.width);
            point.y = Math.max(point.y, this.m_screenInsets.top);
            point.y = Math.min(point.y, this.m_screenSize.height - this.m_screenInsets.bottom - dimension.height);
            this.setLocation(point);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DockingBorder {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

