/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets.button;

import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.mscl.grafics.CGrayFilter;
import com.mayastudios.mscl.grafics.CHighlightFilter;
import com.mayastudios.mscl.mwt.widgets.button.CButtonEvent;
import com.mayastudios.mscl.mwt.widgets.button.IButtonListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class CFramelessButton
extends JLabel {
    public static final int DEFAULT_HIGHLIGHT_DIFF = 35;
    private EventManager m_oEventManager = new EventManager();
    private ImageIcon m_oDefaultIcon;
    private ImageIcon m_oHoverIcon;

    public CFramelessButton(ImageIcon imageIcon, int n) {
        this(imageIcon, CFramelessButton.createHighlightedIcon(imageIcon, n));
    }

    public CFramelessButton(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this(imageIcon, imageIcon2, null);
    }

    public CFramelessButton(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        this.setDefaultIcon(imageIcon);
        this.setHoverIcon(imageIcon2);
        if (imageIcon3 == null) {
            imageIcon3 = CGrayFilter.createDisabledIcon(imageIcon);
        }
        this.setDisabledIcon(imageIcon3);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.addMouseListener(new CMouseListener());
    }

    public void setDefaultIcon(ImageIcon imageIcon) {
        this.m_oDefaultIcon = imageIcon;
        super.setIcon(imageIcon);
    }

    public ImageIcon getDefaultIcon() {
        return this.m_oDefaultIcon;
    }

    @Deprecated
    public void setIcon(Icon icon) {
        super.setIcon(icon);
    }

    @Deprecated
    public Icon getIcon() {
        return super.getIcon();
    }

    public void setHoverIcon(ImageIcon imageIcon) {
        this.m_oHoverIcon = imageIcon;
    }

    public ImageIcon getHoverIcon() {
        return this.m_oHoverIcon;
    }

    public static ImageIcon createHighlightedIcon(ImageIcon imageIcon, int n) {
        CHighlightFilter cHighlightFilter = new CHighlightFilter(n);
        return cHighlightFilter.filterIcon(imageIcon);
    }

    public void addButtonListener(IButtonListener iButtonListener, BaseEventManager.ERefType eRefType) {
        this.m_oEventManager.addListener(iButtonListener, eRefType);
    }

    public void removeButtonListener(IButtonListener iButtonListener) {
        this.m_oEventManager.removeListener(iButtonListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventManager
    extends BaseEventManager<IButtonListener, CButtonEvent> {
        private EventManager() {
        }

        public void fireEvent(CButtonEvent cButtonEvent) {
            super.fireEvent((Object)cButtonEvent);
        }

        protected void notifyListener(IButtonListener iButtonListener, CButtonEvent cButtonEvent) {
            iButtonListener.buttonActionPerformed(cButtonEvent);
        }
    }

    private class CMouseListener
    extends MouseAdapter {
        private CMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1 || !CFramelessButton.this.isEnabled()) {
                return;
            }
            CFramelessButton.this.m_oEventManager.fireEvent(new CButtonEvent(mouseEvent.getComponent(), mouseEvent.getComponent()));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!CFramelessButton.this.isEnabled()) {
                return;
            }
            CFramelessButton.this.setIcon(CFramelessButton.this.getHoverIcon());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!CFramelessButton.this.isEnabled()) {
                return;
            }
            CFramelessButton.this.setIcon(CFramelessButton.this.getDefaultIcon());
        }
    }
}

