/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets.inputcontols;

import com.mayastudios.mscl.mwt.widgets.inputcontols.AValidatingTextField;
import com.mayastudios.mscl.mwt.widgets.inputcontols.IInvalidableCtrl;
import com.mayastudios.mscl.mwt.widgets.inputcontols.IInvalidableCtrlWrapper;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Pattern;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;

public class CTimeDurationEditField
extends JSpinner
implements IInvalidableCtrlWrapper {
    private final CTimeEditor m_oEditor;
    private final CTimeModel m_oModel;

    public CTimeDurationEditField(boolean bl, boolean bl2) {
        this(Integer.MAX_VALUE, bl, bl2);
    }

    public CTimeDurationEditField(int n, boolean bl, boolean bl2) {
        this.m_oModel = new CTimeModel(n, bl);
        this.setModel(this.m_oModel);
        this.m_oEditor = new CTimeEditor(this, bl2);
        this.setEditor(this.m_oEditor);
        this.m_oEditor.addFocusListener(new CFocusListener());
    }

    public void highlightControl(boolean bl) {
        this.m_oEditor.highlightControl(bl);
    }

    public boolean evaluateContent() {
        return this.m_oEditor.evaluateContent();
    }

    public void setSecondsCount(int n) {
        this.m_oModel.setSecondsCount(n);
    }

    public int getSecondsCount() {
        return this.m_oModel.getSecondsCount();
    }

    @Deprecated
    public void setValue(Object object) {
        super.setValue(object);
    }

    @Deprecated
    public Object getValue() {
        return super.getValue();
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
    }

    private void _redispatchFocusEvent(FocusEvent focusEvent) {
        FocusEvent focusEvent2 = new FocusEvent(this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent());
        this.processFocusEvent(focusEvent2);
    }

    private static final class CTimeEditor
    extends AValidatingTextField
    implements ChangeListener,
    CaretListener {
        private static final String DELIMETER = ":";
        private static final Pattern SPLIT_PATTERN = Pattern.compile("[:]");
        private static final int DEFAULT_COLUMNS = 9;
        private CTimeModel m_oModel;
        private boolean m_bPerformingModelUpdate = false;
        private boolean m_bPerformingCaretUpdate = false;

        CTimeEditor(CTimeDurationEditField cTimeDurationEditField, boolean bl) {
            super(CTimeEditor._formatTime((CTimeModel)cTimeDurationEditField.getModel()), 9, bl, true);
            this.m_oModel = (CTimeModel)cTimeDurationEditField.getModel();
            this.setHorizontalAlignment(4);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.m_oModel.associateEditor(this);
            this.addCaretListener(this);
        }

        public boolean evaluateContent(IInvalidableCtrl.EEvalType eEvalType) {
            if (eEvalType != IInvalidableCtrl.EEvalType.FOCUS_LOST) {
                return this.m_oModel.getSecondsCount() != -1;
            }
            int n = this.calcSecondsCount();
            this._updateModel(n);
            return n != -1;
        }

        public void restoreContent(Object object) {
            super.restoreContent(object);
            if (this.m_oModel == null) {
                return;
            }
            this._updateModel(this.calcSecondsCount());
        }

        private String[] _splitText() {
            String[] stringArray = SPLIT_PATTERN.split(this.getText());
            if (this.m_oModel.useSeconds() ? stringArray.length != 3 : stringArray.length != 2) {
                return null;
            }
            return stringArray;
        }

        int calcSecondsCount() {
            int n;
            String[] stringArray = this._splitText();
            if (stringArray == null) {
                return -1;
            }
            try {
                n = Integer.parseInt(stringArray[0]) * 3600;
                n += Integer.parseInt(stringArray[1]) * 60;
                if (this.m_oModel.useSeconds()) {
                    n += Integer.parseInt(stringArray[2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            return n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.m_bPerformingModelUpdate) {
                return;
            }
            this.m_bPerformingCaretUpdate = true;
            this.setText(CTimeEditor._formatTime(this.m_oModel));
            this.m_bPerformingCaretUpdate = false;
            this._resetSelection(this.m_oModel.getSelState());
        }

        private void _updateModel(int n) {
            this.m_bPerformingModelUpdate = true;
            this.m_oModel.setValue(new Integer(n));
            this.m_bPerformingModelUpdate = false;
        }

        private static String _formatTime(CTimeModel cTimeModel) {
            int n = cTimeModel.getSecondsCount();
            int n2 = n / 3600;
            int n3 = n % 3600 / 60;
            String string = cTimeModel.useSeconds() ? String.format("%02d%s%02d%s%02d", n2, DELIMETER, n3, DELIMETER, n %= 60) : String.format("%02d%s%02d", n2, DELIMETER, n3);
            return string;
        }

        ESelState getActivePart() {
            String[] stringArray = this._splitText();
            if (stringArray == null) {
                return this.m_oModel.useSeconds() ? ESelState.SECONDS : ESelState.MINUTES;
            }
            Caret caret = this.getCaret();
            int n = Math.min(caret.getDot(), caret.getMark());
            if (n <= stringArray[0].length()) {
                return ESelState.HOURS;
            }
            if (!this.m_oModel.useSeconds()) {
                return ESelState.MINUTES;
            }
            if (n <= stringArray[0].length() + 1 + stringArray[1].length()) {
                return ESelState.MINUTES;
            }
            return ESelState.SECONDS;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (this.m_bPerformingCaretUpdate) {
                return;
            }
            this.m_oModel.invalidateChangingPart();
        }

        private void _resetSelection(ESelState eSelState) {
            String[] stringArray = this._splitText();
            int n = 0;
            int n2 = 0;
            if (stringArray != null) {
                switch (eSelState) {
                    case HOURS: {
                        n = 0;
                        n2 = stringArray[0].length();
                        break;
                    }
                    case MINUTES: {
                        n = stringArray[0].length() + 1;
                        n2 = stringArray[1].length();
                        break;
                    }
                    case SECONDS: {
                        n = stringArray[0].length() + stringArray[1].length() + 2;
                        n2 = stringArray[2].length();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown selection state");
                    }
                }
            }
            this.m_bPerformingCaretUpdate = true;
            this.setCaretPosition(n);
            this.moveCaretPosition(n + n2);
            this.m_bPerformingCaretUpdate = false;
        }
    }

    private static final class CTimeModel
    extends AbstractSpinnerModel {
        private CTimeEditor m_oEditor = null;
        private boolean m_bUseSeconds;
        private ESelState m_eSelState;
        private int m_iCurValue = 0;
        private int m_iMaxValue;

        public CTimeModel(int n, boolean bl) {
            this.m_iMaxValue = n;
            this.m_bUseSeconds = bl;
            this.m_eSelState = bl ? ESelState.SECONDS : ESelState.MINUTES;
        }

        void associateEditor(CTimeEditor cTimeEditor) {
            this.m_oEditor = cTimeEditor;
            this.addChangeListener(cTimeEditor);
        }

        boolean useSeconds() {
            return this.m_bUseSeconds;
        }

        public void setSecondsCount(int n) {
            if (n != this.m_iCurValue) {
                this.m_iCurValue = n;
                if (this.m_eSelState == null) {
                    this.m_eSelState = this.m_oEditor.getActivePart();
                }
                this.fireStateChanged();
            }
        }

        public int getSecondsCount() {
            return this.m_iCurValue;
        }

        void invalidateChangingPart() {
            this.m_eSelState = null;
        }

        ESelState getSelState() {
            return this.m_eSelState;
        }

        public Object getValue() {
            return new Integer(this.m_iCurValue);
        }

        public void setValue(Object object) {
            this.setSecondsCount((Integer)object);
        }

        public Object getNextValue() {
            if (this.m_oEditor == null) {
                return null;
            }
            int n = this._getBaseValue() + this._getStepSize();
            if (n > this.m_iMaxValue) {
                return null;
            }
            return new Integer(n);
        }

        public Object getPreviousValue() {
            if (this.m_oEditor == null) {
                return null;
            }
            int n = this._getBaseValue() - this._getStepSize();
            if (n < 0) {
                return null;
            }
            return new Integer(n);
        }

        private int _getBaseValue() {
            int n = this.m_iCurValue;
            int n2 = this.m_oEditor.calcSecondsCount();
            if (n != n2 && n2 != -1) {
                n = n2;
            }
            return n;
        }

        private int _getStepSize() {
            if (this.m_eSelState == null) {
                this.m_eSelState = this.m_oEditor.getActivePart();
            }
            switch (this.m_eSelState) {
                case HOURS: {
                    return 3600;
                }
                case MINUTES: {
                    return 60;
                }
                case SECONDS: {
                    return 1;
                }
            }
            throw new IllegalStateException("unknown state");
        }
    }

    private final class CFocusListener
    implements FocusListener {
        private CFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            CTimeDurationEditField.this._redispatchFocusEvent(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            CTimeDurationEditField.this._redispatchFocusEvent(focusEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ESelState {
        HOURS,
        MINUTES,
        SECONDS;

    }
}

