/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets.inputcontols;

import com.mayastudios.mscl.mwt.focus.FocusManager;
import com.mayastudios.mscl.mwt.focus.IFocusListener;
import com.mayastudios.mscl.mwt.widgets.inputcontols.IInvalidableCtrl;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class InvalidContentNotifier {
    private InvalidContentNotifier() {
    }

    public static void associateWithControl(IInvalidableCtrl iInvalidableCtrl) {
        InvalidContentNotifier.associateWithControl(iInvalidableCtrl, true);
    }

    public static void associateWithControl(IInvalidableCtrl iInvalidableCtrl, boolean bl) {
        InvalidContentNotifier.associateWithControl(iInvalidableCtrl, null, bl);
    }

    public static void associateWithControl(IInvalidableCtrl iInvalidableCtrl, Object object) {
        InvalidContentNotifier.associateWithControl(iInvalidableCtrl, object, true);
    }

    public static void associateWithControl(IInvalidableCtrl iInvalidableCtrl, Object object, boolean bl) {
        assert (iInvalidableCtrl.getControl().isFocusable());
        if (object != null) {
            iInvalidableCtrl.restoreContent(object);
        }
        new CFocusListener(iInvalidableCtrl, object, bl);
    }

    private static class CFocusListener
    implements IFocusListener,
    ActionListener {
        private IInvalidableCtrl m_oControl;
        private Object m_oLastValidContent = null;
        private Timer m_oHighlightTimer = null;

        CFocusListener(IInvalidableCtrl iInvalidableCtrl, Object object, boolean bl) {
            this.m_oControl = iInvalidableCtrl;
            if (bl) {
                this.m_oLastValidContent = object;
                this.m_oHighlightTimer = new Timer(2000, this);
                this.m_oHighlightTimer.setRepeats(false);
            }
            if (iInvalidableCtrl.getControl() instanceof Container) {
                FocusManager.addContainerFocusListener(this, (Container)iInvalidableCtrl.getControl(), true);
            } else {
                FocusManager.addComponentFocusListener(this, iInvalidableCtrl.getControl());
            }
        }

        public void focusChanged(Component component, Component component2, IFocusListener.EState eState) {
            if (eState == IFocusListener.EState.LOST) {
                if (!this.m_oControl.evaluateContent(IInvalidableCtrl.EEvalType.FOCUS_LOST)) {
                    this.m_oControl.highlightControl(true);
                    if (this.m_oHighlightTimer != null && this.m_oLastValidContent != null) {
                        this.m_oControl.restoreContent(this.m_oLastValidContent);
                        this.m_oHighlightTimer.start();
                    }
                }
            } else if (eState == IFocusListener.EState.GAINED) {
                this.m_oControl.highlightControl(false);
                if (this.m_oHighlightTimer != null) {
                    if (this.m_oHighlightTimer.isRunning()) {
                        this.m_oHighlightTimer.stop();
                    }
                    if (this.m_oControl.evaluateContent(IInvalidableCtrl.EEvalType.FOCUS_GAINED)) {
                        this.m_oLastValidContent = this.m_oControl.getContent();
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_oControl.highlightControl(false);
        }
    }
}

