/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.commands;

import com.mayastudios.ixml.commands.BaseCommandController;
import com.mayastudios.ixml.commands.base.Command;
import com.mayastudios.ixml.commands.base.Enablable;
import com.mayastudios.ixml.commands.menu.IXMLContextMenu;
import com.mayastudios.ixml.commands.menu.IXMLMenu;
import com.mayastudios.ixml.commands.menu.IXMLMenuBar;
import com.mayastudios.ixml.commands.menu.MenuCompFactory;
import com.mayastudios.ixml.common.LabelCaption;
import com.mayastudios.ixml.common.SimplifiedSAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JSeparator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseLayoutController<EnableType>
implements Enablable.IEnableController<EnableType> {
    private static final String SCHEMA_SOURCE_NAME = "layoutlist.xsd";
    private static final SimplifiedSAXParser SAX_PARSER;
    private final Class<EnableType> mf_oEnableTypeClass;

    public BaseLayoutController(Class<EnableType> p_oEnableTypeClass) {
        this.mf_oEnableTypeClass = p_oEnableTypeClass;
    }

    @Override
    public Class<EnableType> getEnableTypeClass() {
        return this.mf_oEnableTypeClass;
    }

    protected IXMLMenuBar<EnableType> createMenuBar(List<BaseMenuNode<EnableType>> p_oMenuList, MenuCompFactory<EnableType> p_oFactory) {
        IXMLMenuBar<EnableType> oMenuBar = p_oFactory.createMenuBar();
        for (BaseMenuNode<EnableType> oNode : p_oMenuList) {
            if (oNode.isMenuItem()) {
                if (oNode instanceof MenuItemNode) {
                    MenuItemNode oItemNode = (MenuItemNode)oNode;
                    oMenuBar.add(p_oFactory.createMenuItem(oItemNode.mf_oMenuItemCommand, oItemNode.mf_bHideIcon, oItemNode.mf_bIsDefaultItem));
                    continue;
                }
                oMenuBar.add(new JSeparator(1));
                continue;
            }
            oMenuBar.add(this._createMenu((MenuNode)oNode, p_oFactory));
        }
        return oMenuBar;
    }

    protected IXMLContextMenu<EnableType> createContextMenu(List<BaseMenuNode<EnableType>> p_oMenuList, MenuCompFactory<EnableType> p_oFactory) {
        IXMLContextMenu<EnableType> oContextMenu = p_oFactory.createContextMenu();
        for (BaseMenuNode<EnableType> oNode : p_oMenuList) {
            if (oNode.isMenuItem()) {
                if (oNode instanceof MenuItemNode) {
                    MenuItemNode oItemNode = (MenuItemNode)oNode;
                    oContextMenu.add(p_oFactory.createMenuItem(oItemNode.mf_oMenuItemCommand, oItemNode.mf_bHideIcon, oItemNode.mf_bIsDefaultItem));
                    continue;
                }
                oContextMenu.addSeparator();
                continue;
            }
            oContextMenu.add(this._createMenu((MenuNode)oNode, p_oFactory));
        }
        return oContextMenu;
    }

    private IXMLMenu<EnableType> _createMenu(MenuNode<EnableType> p_oMenuNode, MenuCompFactory<EnableType> p_oFactory) {
        IXMLMenu<EnableType> oMenu = p_oFactory.createMenu(p_oMenuNode.mf_oCaption, p_oMenuNode.mf_oMenuEnablable);
        for (BaseMenuNode oNode : p_oMenuNode.getChildNodes()) {
            if (oNode.isMenuItem()) {
                if (oNode instanceof MenuItemNode) {
                    MenuItemNode oItemNode = (MenuItemNode)oNode;
                    oMenu.add(p_oFactory.createMenuItem(oItemNode.mf_oMenuItemCommand, oItemNode.mf_bHideIcon, oItemNode.mf_bIsDefaultItem));
                    continue;
                }
                oMenu.addSeparator();
                continue;
            }
            oMenu.add(this._createMenu((MenuNode)oNode, p_oFactory));
        }
        return oMenu;
    }

    protected HashMap<String, List<BaseMenuNode<EnableType>>> loadLayouts(InputStream p_oXIMLDataStream, List<Command<EnableType>> p_oCommandList) throws SAXException, IOException {
        MenuHandler oHandler = new MenuHandler(p_oCommandList);
        SAX_PARSER.parse(p_oXIMLDataStream, (DefaultHandler)((Object)oHandler));
        return oHandler.mf_oTypeList;
    }

    static {
        URL oSchemaURL = BaseCommandController.class.getResource(SCHEMA_SOURCE_NAME);
        if (oSchemaURL == null) {
            throw new ExceptionInInitializerError("Could not find labels schema file.");
        }
        SAX_PARSER = new SimplifiedSAXParser(oSchemaURL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MenuHandler
    extends SimplifiedSAXParser.SimplifiedDefaultHandler {
        private static final String ROOT_TAG = "layoutlist";
        private static final String CONTAINER_TAG = "layout";
        private static final String ID_ATTRIB = "id";
        private static final String DEFAULTITEM_ATTRIB = "defaultItem";
        private static final String MENU_TAG = "menu";
        private static final String CAPTION_ATTRIB = "caption";
        private static final String ENABLED_ATTRIB = "enabled";
        private static final String COMMAND_TAG = "command";
        private static final String HIDEICON_ATTRIB = "hideicon";
        private static final String SEPARATOR_TAG = "separator";
        public final HashMap<String, List<BaseMenuNode<EnableType>>> mf_oTypeList = new HashMap();
        private final List<Command<EnableType>> mf_oCommandList;
        private String m_strCurID;
        private String m_strDefaultItemID;
        private List<BaseMenuNode<EnableType>> m_oCurBaseContainer = null;
        private MenuNode<EnableType> m_oCurMenuNode = null;
        private List<BaseMenuNode<EnableType>> m_oCurContainer = null;

        public MenuHandler(List<Command<EnableType>> p_oCommandList) {
            this.mf_oCommandList = p_oCommandList;
        }

        public void startElement(String p_strTagName, Attributes p_oAttributes) throws SAXException {
            if (ROOT_TAG.equals(p_strTagName)) {
                return;
            }
            if (CONTAINER_TAG.equals(p_strTagName)) {
                this.m_strCurID = p_oAttributes.getValue(ID_ATTRIB);
                this.m_strDefaultItemID = p_oAttributes.getValue(DEFAULTITEM_ATTRIB);
                this.m_oCurBaseContainer = new LinkedList();
                this.m_oCurContainer = this.m_oCurBaseContainer;
            } else if (MENU_TAG.equals(p_strTagName)) {
                LabelCaption oCaption = new LabelCaption(p_oAttributes.getValue(CAPTION_ATTRIB));
                Enablable oEnablable = new Enablable(BaseLayoutController.this, p_oAttributes.getValue(ID_ATTRIB), p_oAttributes.getValue(ENABLED_ATTRIB));
                this.m_oCurMenuNode = new MenuNode(oEnablable, oCaption, this.m_oCurMenuNode);
                this.m_oCurContainer.add(this.m_oCurMenuNode);
                this.m_oCurContainer = this.m_oCurMenuNode.getChildNodes();
            } else if (COMMAND_TAG.equals(p_strTagName)) {
                String strID = p_oAttributes.getValue(ID_ATTRIB);
                boolean bFoundCommand = false;
                for (Command oCommand : this.mf_oCommandList) {
                    if (!oCommand.mf_strID.equals(strID)) continue;
                    boolean bHideIcon = Boolean.parseBoolean(p_oAttributes.getValue(HIDEICON_ATTRIB));
                    boolean bIsDefault = false;
                    if (this.m_strDefaultItemID != null) {
                        bIsDefault = this.m_strDefaultItemID.equals(strID);
                    }
                    this.m_oCurContainer.add(new MenuItemNode(oCommand, bHideIcon, bIsDefault));
                    bFoundCommand = true;
                    break;
                }
                if (!bFoundCommand) {
                    BaseLayoutController.this.error("Could not find command for ID: " + strID);
                }
            } else if (SEPARATOR_TAG.equals(p_strTagName)) {
                this.m_oCurContainer.add(new SeparatorNode());
            } else {
                throw new IllegalStateException("Unkown tag found:" + p_strTagName);
            }
        }

        public void endElement(String p_strTagName) {
            if (CONTAINER_TAG.equals(p_strTagName)) {
                this.mf_oTypeList.put(this.m_strCurID, this.m_oCurContainer);
            } else if (MENU_TAG.equals(p_strTagName)) {
                this.m_oCurMenuNode = this.m_oCurMenuNode.mf_oParentNode;
                this.m_oCurContainer = this.m_oCurMenuNode == null ? this.m_oCurBaseContainer : this.m_oCurMenuNode.getChildNodes();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeparatorNode<EnableType>
    extends BaseMenuNode<EnableType> {
        public SeparatorNode() {
            super(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MenuItemNode<EnableType>
    extends BaseMenuNode<EnableType> {
        public final Command<EnableType> mf_oMenuItemCommand;
        public final boolean mf_bHideIcon;
        public final boolean mf_bIsDefaultItem;

        public MenuItemNode(Command<EnableType> p_oMenuItemCommand, boolean p_bHideIcon, boolean p_bIsDefaultItem) {
            super(false);
            this.mf_oMenuItemCommand = p_oMenuItemCommand;
            this.mf_bHideIcon = p_bHideIcon;
            this.mf_bIsDefaultItem = p_bIsDefaultItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MenuNode<EnableType>
    extends BaseMenuNode<EnableType> {
        public final Enablable<EnableType> mf_oMenuEnablable;
        public final LabelCaption mf_oCaption;
        public final MenuNode<EnableType> mf_oParentNode;

        public MenuNode(Enablable<EnableType> p_oMenuEnablable, LabelCaption p_oCaption, MenuNode<EnableType> p_oParentNode) {
            super(false);
            this.mf_oMenuEnablable = p_oMenuEnablable;
            this.mf_oCaption = p_oCaption;
            this.mf_oParentNode = p_oParentNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseMenuNode<EnableType> {
        private final LinkedList<BaseMenuNode<EnableType>> mf_oChildList;

        public BaseMenuNode(boolean p_bIsMenuItem) {
            this.mf_oChildList = p_bIsMenuItem ? null : new LinkedList();
        }

        public boolean isMenuItem() {
            return this.mf_oChildList.size() == 0;
        }

        public List<BaseMenuNode<EnableType>> getChildNodes() {
            return this.mf_oChildList;
        }
    }
}

