/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.commands.base;

import com.mayastudios.ixml.commands.base.Enablable;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.common.BaseSimpleEventManager;
import com.mayastudios.ixml.common.LabelCaption;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command<EnableType>
extends Enablable<EnableType> {
    private final ICommandController<EnableType> mf_oCommandController;
    private final Method mf_oInvokeMethod;
    private final Method mf_oToggleStateMethod;
    private final ToggleListeners mf_oListeners;
    public final String mf_strID;
    public final LabelCaption mf_oCaption;
    public final ImageIcon mf_oIcon;
    public final KeyStroke mf_oAccelerator;
    public final boolean mf_bIsToggleCommand;

    public Command(ICommandController<EnableType> p_oCommandController, String p_strID, LabelCaption p_oCaption, ImageIcon p_oIcon, String p_strEnabled, KeyStroke p_oAccelerator, boolean p_bIsToggleCommand) throws SAXException {
        super(p_oCommandController, p_strID, p_strEnabled);
        Class<?> oControllerClass = p_oCommandController.getClass();
        this.mf_oCommandController = p_oCommandController;
        this.mf_strID = p_strID;
        this.mf_oCaption = p_oCaption;
        this.mf_oIcon = p_oIcon;
        this.mf_oAccelerator = p_oAccelerator;
        this.mf_bIsToggleCommand = p_bIsToggleCommand;
        this.mf_oListeners = p_bIsToggleCommand ? new ToggleListeners() : null;
        Method oInvokeMethod = null;
        try {
            oInvokeMethod = oControllerClass.getMethod(p_oCommandController.getInvokePrefix() + p_strID, new Class[0]);
            if (!Modifier.isPublic(oInvokeMethod.getModifiers())) {
                oInvokeMethod = null;
                p_oCommandController.error(String.format("%s%s(): Method is not public.", p_oCommandController.getInvokePrefix(), p_strID));
            }
        }
        catch (NoSuchMethodException oException) {
            p_oCommandController.error(String.format("%s%s(): Cannot find this method.", p_oCommandController.getInvokePrefix(), p_strID));
        }
        Method oToggleStateMethod = null;
        if (p_bIsToggleCommand) {
            try {
                oToggleStateMethod = oControllerClass.getMethod(p_oCommandController.getToggleStatePrefix() + p_strID, new Class[0]);
                if (!Modifier.isPublic(oToggleStateMethod.getModifiers())) {
                    oToggleStateMethod = null;
                    p_oCommandController.error(String.format("%s%s(): Method is not public.", p_oCommandController.getToggleStatePrefix(), p_strID));
                } else if (oToggleStateMethod.getReturnType() != Boolean.TYPE) {
                    oToggleStateMethod = null;
                    p_oCommandController.error(String.format("%s%s(): Method does not return a boolean value.", p_oCommandController.getToggleStatePrefix(), p_strID));
                }
            }
            catch (NoSuchMethodException oException) {
                p_oCommandController.error(String.format("%s%s(): Cannot find this method.", p_oCommandController.getToggleStatePrefix(), p_strID));
            }
        }
        this.mf_oInvokeMethod = oInvokeMethod;
        this.mf_oToggleStateMethod = oToggleStateMethod;
    }

    public void addToggleListener(IToggleCommandListener p_oListener, BaseEventManager.ERefType p_eRefType) {
        if (!this.mf_bIsToggleCommand) {
            return;
        }
        this.mf_oListeners.addListener(p_oListener, p_eRefType);
    }

    public void removeToggleListener(IToggleCommandListener p_oListener) {
        if (!this.mf_bIsToggleCommand) {
            return;
        }
        this.mf_oListeners.removeListener(p_oListener);
    }

    public void invoke() {
        this._invokeMethod(this.mf_oInvokeMethod);
    }

    public void updateToggleState() {
        if (!this.mf_bIsToggleCommand) {
            return;
        }
        Object oReturnVal = this._invokeMethod(this.mf_oToggleStateMethod);
        if (oReturnVal != null) {
            this.mf_oListeners.m_bCurrentToggleValue = (Boolean)oReturnVal;
            this.mf_oListeners.fireEvent();
        }
    }

    private Object _invokeMethod(Method p_oMethod) {
        if (p_oMethod == null) {
            return null;
        }
        try {
            return p_oMethod.invoke(this.mf_oCommandController, new Object[0]);
        }
        catch (IllegalArgumentException oException) {
            throw new IllegalStateException(oException);
        }
        catch (IllegalAccessException oException) {
            throw new IllegalStateException(oException);
        }
        catch (InvocationTargetException oException) {
            Throwable oInnerException = oException.getTargetException();
            if (oInnerException instanceof RuntimeException) {
                throw (RuntimeException)oInnerException;
            }
            if (oInnerException instanceof Error) {
                throw (Error)oInnerException;
            }
            this.mf_oCommandController.handleInvokationException((Exception)oInnerException);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICommandController<EnableType>
    extends Enablable.IEnableController<EnableType> {
        public String getInvokePrefix();

        public String getToggleStatePrefix();

        public void handleInvokationException(Exception var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToggleListeners
    extends BaseSimpleEventManager<IToggleCommandListener> {
        public boolean m_bCurrentToggleValue = false;

        protected void notifyListener(IToggleCommandListener p_oListener) {
            p_oListener.updateToggleState(this.m_bCurrentToggleValue);
        }
    }

    public static interface IToggleCommandListener {
        public void updateToggleState(boolean var1);
    }
}

