/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.swing.JComponent;
import org.xml.sax.Attributes;

public class IXMLControlNode
extends IXMLBaseElement {
    public IXMLControlNode(String p_strID) {
        super(EIXMLType.CONTROL, p_strID, false);
    }

    protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError {
        String strClassName = this.getAttributeAsString(EIXMLAttrib.CLASS);
        if (strClassName == null) {
            throw new IXMLError("No class specified for this control.", new Object[0]);
        }
        try {
            Class<?> oClass = Class.forName(strClassName);
            if (!JComponent.class.isAssignableFrom(oClass)) {
                throw new IXMLError("The specified class '" + strClassName + "' is not derived from the Component class.", new Object[0]);
            }
            if (Modifier.isAbstract(oClass.getModifiers())) {
                throw new IXMLError("The specified class '" + strClassName + "' is an abstract class.", new Object[0]);
            }
            Constructor<?>[] aoConstructors = oClass.getConstructors();
            Constructor<?> oSimpleConstructor = null;
            Constructor<?> oIXMLConstructor = null;
            for (Constructor<?> oConstructor : aoConstructors) {
                if (!Modifier.isPublic(oConstructor.getModifiers())) continue;
                Class<?>[] oParameterTypes = oConstructor.getParameterTypes();
                switch (oParameterTypes.length) {
                    case 0: {
                        oSimpleConstructor = oConstructor;
                        break;
                    }
                    case 1: {
                        if (!IXMLBaseElement.class.isAssignableFrom(oParameterTypes[0])) break;
                        oIXMLConstructor = oConstructor;
                    }
                }
                if (oIXMLConstructor != null) break;
            }
            if (oIXMLConstructor != null) {
                return (JComponent)oIXMLConstructor.newInstance(this);
            }
            if (oSimpleConstructor != null) {
                return (JComponent)oSimpleConstructor.newInstance(new Object[0]);
            }
            throw new IXMLError("No valid constructor could be found for class '" + strClassName + "'.", new Object[0]);
        }
        catch (ClassNotFoundException oException) {
            throw new IXMLError((Throwable)oException);
        }
        catch (IllegalArgumentException oException) {
            throw new IllegalStateException(oException);
        }
        catch (InstantiationException oException) {
            throw new IllegalStateException(oException);
        }
        catch (IllegalAccessException oException) {
            throw new IllegalStateException(oException);
        }
        catch (InvocationTargetException oException) {
            throw new IXMLError((Throwable)oException);
        }
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("control"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLControlNode(p_oAttributes.getValue("id"));
            }
        });
    }
}

