/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.comp.impl.NumberTextfield;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.xml.sax.Attributes;

public class IXMLTextBoxNode
extends IXMLBaseElement {
    private final IXMLBaseElement.NodeCompFactory<JFormattedTextField> mf_oNodeFactory = new IXMLBaseElement.NodeCompFactory<JFormattedTextField>(this, JFormattedTextField.class, "createTextbox");
    private final IXMLBaseElement.NodeCompFactory<NumberTextfield> mf_oNumberNodeFactory = new IXMLBaseElement.NodeCompFactory<NumberTextfield>(this, NumberTextfield.class, "createNumberTextbox");
    private final IXMLBaseElement.NodeCompFactory<JPasswordField> mf_oPasswordNodeFactory = new IXMLBaseElement.NodeCompFactory<JPasswordField>(this, JPasswordField.class, "createPasswordTextbox");
    private final IXMLBaseElement.NodeCompFactory<JTextArea> mf_oMLNodeFactory = new IXMLBaseElement.NodeCompFactory<JTextArea>(this, JTextArea.class, "createMultilineTextbox");

    public IXMLTextBoxNode(String p_strID) {
        super(EIXMLType.TEXTBOX, p_strID, false);
    }

    protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError {
        JComponent oComponent;
        int iRowCount = this.getAttributeAsInt(EIXMLAttrib.ROWS, 1);
        Integer oColCount = this.getAttributeAsInt(EIXMLAttrib.COLS);
        boolean bIsEditable = this.getAttributeAsBoolean(EIXMLAttrib.EDITABLE, true);
        if (iRowCount == 1) {
            int iOption = this.getAttributeAsOption(EIXMLAttrib.TEXTBOX_TYPE);
            if (iOption == EIXMLAttrib.TEXTBOX_TYPE_VALUE_NUMBER) {
                NumberTextfield oNumberField = this.mf_oNumberNodeFactory.create(p_oCreateInfo, new Object[0]);
                Integer oValue = this.getAttributeAsInt(EIXMLAttrib.MIN);
                int iMin = oValue != null ? oValue : Integer.MIN_VALUE;
                oValue = this.getAttributeAsInt(EIXMLAttrib.MAX);
                int iMax = oValue != null ? oValue : Integer.MAX_VALUE;
                oValue = this.getAttributeAsInt(EIXMLAttrib.INCREMENT);
                int iIncrement = oValue != null ? oValue : 1;
                oNumberField.setData(0, iMin, iMax, iIncrement);
                if (oColCount != null) {
                    oNumberField.setColumns(oColCount);
                }
                oNumberField.setEditable(bIsEditable);
                oComponent = oNumberField;
            } else {
                JTextField oTextField = iOption == EIXMLAttrib.TEXTBOX_TYPE_VALUE_PASSWORD ? (JTextField)this.mf_oPasswordNodeFactory.create(p_oCreateInfo, new Object[0]) : (JTextField)this.mf_oNodeFactory.create(p_oCreateInfo, new Object[0]);
                if (oColCount != null) {
                    oTextField.setColumns(oColCount);
                }
                oTextField.setEditable(bIsEditable);
                oComponent = oTextField;
            }
        } else {
            JTextArea oTextArea = this.mf_oMLNodeFactory.create(p_oCreateInfo, new Object[0]);
            oTextArea.setRows(iRowCount);
            if (oColCount != null) {
                oTextArea.setColumns(oColCount);
            }
            oTextArea.setLineWrap(this.getAttributeAsBoolean(EIXMLAttrib.WRAP, true));
            oTextArea.setWrapStyleWord(true);
            oTextArea.setEditable(bIsEditable);
            JScrollPane oScrollPane = new JScrollPane(oTextArea, 20, 30);
            oComponent = oScrollPane;
        }
        return oComponent;
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("textbox"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLTextBoxNode(p_oAttributes.getValue("id"));
            }
        });
    }
}

