/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.impl;

import com.mayastudios.ixml.document.IXMLPanel;
import com.mayastudios.ixml.misc.NullLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class TitledPanel
extends IXMLPanel {
    private final TitleArea mf_oTitleArea;
    private final IXMLPanel mf_oContentPanel;

    public TitledPanel(String p_strTitle, String p_strSubTitle, Icon p_oIcon, Icon p_oBackground, IXMLPanel p_oContentPanel) {
        super(new BorderLayout());
        this.mf_oTitleArea = new TitleArea(p_strTitle, p_strSubTitle, p_oIcon, p_oBackground);
        this.mf_oContentPanel = p_oContentPanel;
        this.add((Component)this.mf_oTitleArea, (Object)"First", null);
        this.add((Component)this.mf_oContentPanel, (Object)"Center", null);
    }

    public IXMLPanel getContentPanel() {
        return this.mf_oContentPanel;
    }

    public TitleArea getTitleArea() {
        return this.mf_oTitleArea;
    }

    private static class SmoothLabel
    extends JLabel {
        public SmoothLabel(String p_strLabel) {
            super(p_strLabel);
        }

        protected void paintComponent(Graphics p_oPainter) {
            ((Graphics2D)p_oPainter).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(p_oPainter);
        }
    }

    public static class TitleArea
    extends NullLayoutPanel {
        public static final Color BG_COLOR = Color.WHITE;
        private static final int TITLEBAR_MIN_HEIGHT = 30;
        private static final int MARGIN = 10;
        private static final int TITLE_SUBTITLE_GAP = 5;
        private static final Font SUBTITLE_FONT = new JLabel().getFont().deriveFont(0);
        private static final Font TITLE_FONT = SUBTITLE_FONT.deriveFont(1, SUBTITLE_FONT.getSize2D() * 1.2f);
        private final SmoothLabel mf_oTitle;
        private final JLabel mf_oSubTitle;
        private final Icon mf_oIcon;
        private final Icon mf_oBackground;
        private final JSeparator mf_oSeperator = new JSeparator(0);

        public TitleArea(String p_strTitle, String p_strSubTitle, Icon p_oIcon, Icon p_oBackground) {
            this.mf_oIcon = p_oIcon;
            this.mf_oBackground = p_oBackground;
            this.mf_oTitle = new SmoothLabel(p_strTitle);
            this.mf_oTitle.setFont(TITLE_FONT);
            Dimension oTitleSize = this.mf_oTitle.getPreferredSize();
            this.mf_oTitle.setBounds(10, 10, oTitleSize.width, oTitleSize.height);
            this.add(this.mf_oTitle);
            this.mf_oSubTitle = new JLabel("<html>" + p_strSubTitle);
            this.mf_oSubTitle.setHorizontalAlignment(2);
            this.mf_oSubTitle.setVerticalAlignment(1);
            this.mf_oSubTitle.setLocation(10, 10 + oTitleSize.height + 5);
            this.mf_oSubTitle.setFont(SUBTITLE_FONT);
            this.add(this.mf_oSubTitle);
            this.add(this.mf_oSeperator);
            int iHeight = oTitleSize.height + 5;
            JLabel oTestLabel = new JLabel();
            oTestLabel.setFont(SUBTITLE_FONT);
            oTestLabel.setText("<html>test<br>test");
            if (this.mf_oIcon != null && this.mf_oIcon.getIconHeight() > (iHeight += oTestLabel.getPreferredSize().height)) {
                iHeight = this.mf_oIcon.getIconHeight();
            }
            iHeight = Math.max(30, iHeight);
            this.setPreferredSize(new Dimension(0, iHeight += this.mf_oSeperator.getPreferredSize().height + 20));
        }

        public String getTitleText() {
            return this.mf_oTitle.getText();
        }

        public void setTitleText(String p_strTitle) {
            this.mf_oTitle.setText(p_strTitle);
        }

        public JLabel getSubTitle() {
            return this.mf_oSubTitle;
        }

        protected void sizeChanged(int p_iWidth, int p_iHeight) {
            int iIconWidth = this.mf_oIcon != null ? this.mf_oIcon.getIconWidth() : 0;
            Point oPos = this.mf_oSubTitle.getLocation();
            int iSeperatorHeight = this.mf_oSeperator.getPreferredSize().height;
            this.mf_oSubTitle.setSize(p_iWidth - iIconWidth - 20, p_iHeight - oPos.y);
            this.mf_oSeperator.setBounds(0, p_iHeight - iSeperatorHeight, p_iWidth, iSeperatorHeight);
        }

        protected void paintComponent(Graphics p_oDC) {
            Dimension oSize = this.getSize();
            p_oDC.setColor(BG_COLOR);
            p_oDC.fillRect(0, 0, oSize.width, oSize.height);
            if (this.mf_oBackground != null) {
                int iXPos = oSize.width - this.mf_oBackground.getIconWidth();
                int iHeight = this.mf_oBackground.getIconHeight();
                for (int y = 0; y < oSize.height; y += iHeight) {
                    this.mf_oBackground.paintIcon(this, p_oDC, iXPos, y);
                }
            }
            if (this.mf_oIcon != null) {
                this.mf_oIcon.paintIcon(this, p_oDC, oSize.width - this.mf_oIcon.getIconWidth() - 10, (oSize.height - this.mf_oIcon.getIconHeight()) / 2);
            }
        }
    }
}

