/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.misc;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IxmlVersionInfo {
    public static final String LIBRARY_VERSION = "0.1";
    public static final int LIBRARY_REVISION = PackageVersionInfo.REVISION;
    public static final Calendar LIBRARY_BUILD_DATE = PackageVersionInfo.BUILD_DATE;

    public static void main(String[] args) {
        System.out.println(String.format("Version: %s-b%d", LIBRARY_VERSION, LIBRARY_REVISION));
        System.out.println("Build Date: " + PackageVersionInfo.BUILD_DATE_STRING);
    }

    private static final class PackageVersionInfo {
        private static final Pattern REVISION_PATTERN = Pattern.compile("\\$LastChangedRevision[:]?[ ]*(\\d+)[ ]*\\$");
        private static final String REVISION_BASE = "$LastChangedRevision: 57 $";
        private static final Pattern BUILD_DATE_PATTERN = Pattern.compile("\\$LastChangedDate[:]?[ ]*(\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) ([+-]\\d{4})[ ]*.*\\$");
        private static final String BUILD_DATE_BASE = "$LastChangedDate: 2009-02-18 19:11:24 +0100 $";
        private static final String VERSION_BASE = "0.1";
        public static final int UNKNOWN_REVISION = -1;
        public static final Calendar UNKNOWN_BUILD_DATE = new GregorianCalendar();
        public static final String VERSION = "0.1";
        public static final int REVISION;
        public static final Calendar BUILD_DATE;
        public static final String BUILD_DATE_STRING;

        private PackageVersionInfo() {
        }

        private static int getRevision() {
            Matcher matcher = REVISION_PATTERN.matcher(REVISION_BASE);
            if (!matcher.matches()) {
                return -1;
            }
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        private static Calendar getBuildDate() {
            Matcher matcher = BUILD_DATE_PATTERN.matcher(BUILD_DATE_BASE);
            if (!matcher.matches()) {
                return UNKNOWN_BUILD_DATE;
            }
            try {
                GregorianCalendar date = new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
                date.setTimeZone(TimeZone.getTimeZone("GMT" + matcher.group(7)));
                return date;
            }
            catch (NumberFormatException e) {
                return UNKNOWN_BUILD_DATE;
            }
        }

        static {
            UNKNOWN_BUILD_DATE.setTimeInMillis(0L);
            REVISION = PackageVersionInfo.getRevision();
            BUILD_DATE = PackageVersionInfo.getBuildDate();
            DateFormat formatter = DateFormat.getDateTimeInstance(1, 1);
            BUILD_DATE_STRING = formatter.format(BUILD_DATE.getTime());
        }
    }
}

