/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.HashMap;

public class StackLayout
implements LayoutManager2 {
    private final HashMap<Component, Point> mf_oConstraints = new HashMap();

    public void addLayoutComponent(String p_name, Component p_comp) {
    }

    public void addLayoutComponent(Component p_oComponent, Object p_oConstraints) {
        if (p_oConstraints == null) {
            return;
        }
        if (!(p_oConstraints instanceof Point)) {
            throw new IllegalArgumentException("Only Point constraints are allowed.");
        }
        this.mf_oConstraints.put(p_oComponent, (Point)p_oConstraints);
    }

    public void removeLayoutComponent(Component p_oComponent) {
        this.mf_oConstraints.remove(p_oComponent);
    }

    public float getLayoutAlignmentX(Container p_target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container p_target) {
        return 0.0f;
    }

    public Dimension minimumLayoutSize(Container p_oLayoutedContainer) {
        Component[] aoComponents = p_oLayoutedContainer.getComponents();
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        for (Component oComponent : aoComponents) {
            Dimension oCompSize = oComponent.getMinimumSize();
            Point oPos = this.mf_oConstraints.get(oComponent);
            if (oPos != null) {
                oCompSize.width += oPos.x;
                oCompSize.height += oPos.y;
            }
            oSize.width = Math.max(oSize.width, oCompSize.width);
            oSize.height = Math.max(oSize.height, oCompSize.height);
        }
        oSize.width += oInsets.left + oInsets.right;
        oSize.height += oInsets.top + oInsets.bottom;
        return oSize;
    }

    public Dimension preferredLayoutSize(Container p_oLayoutedContainer) {
        Component[] aoComponents = p_oLayoutedContainer.getComponents();
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        for (Component oComponent : aoComponents) {
            Dimension oCompSize = oComponent.getPreferredSize();
            Point oPos = this.mf_oConstraints.get(oComponent);
            if (oPos != null) {
                oCompSize.width += oPos.x;
                oCompSize.height += oPos.y;
            }
            oSize.width = Math.max(oSize.width, oCompSize.width);
            oSize.height = Math.max(oSize.height, oCompSize.height);
        }
        oSize.width += oInsets.left + oInsets.right;
        oSize.height += oInsets.top + oInsets.bottom;
        return oSize;
    }

    public Dimension maximumLayoutSize(Container p_oLayoutedContainer) {
        Component[] aoComponents = p_oLayoutedContainer.getComponents();
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        for (Component oComponent : aoComponents) {
            Dimension oCompSize = oComponent.getMaximumSize();
            Point oPos = this.mf_oConstraints.get(oComponent);
            if (oPos != null) {
                oCompSize.width += oPos.x;
                if (oCompSize.width > Short.MAX_VALUE) {
                    oCompSize.width = Short.MAX_VALUE;
                }
                oCompSize.height += oPos.y;
                if (oCompSize.height > Short.MAX_VALUE) {
                    oCompSize.height = Short.MAX_VALUE;
                }
            }
            oSize.width = Math.min(oSize.width, oCompSize.width);
            oSize.height = Math.min(oSize.height, oCompSize.height);
        }
        oSize.width += oInsets.left + oInsets.right;
        oSize.height += oInsets.top + oInsets.bottom;
        if (oSize.width > Short.MAX_VALUE) {
            oSize.width = Short.MAX_VALUE;
        }
        if (oSize.height > Short.MAX_VALUE) {
            oSize.height = Short.MAX_VALUE;
        }
        return oSize;
    }

    public void invalidateLayout(Container p_target) {
    }

    public void layoutContainer(Container p_oLayoutedContainer) {
        Component[] aoComponents = p_oLayoutedContainer.getComponents();
        Dimension oSize = p_oLayoutedContainer.getSize();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        oSize.width -= oInsets.left + oInsets.right;
        oSize.height -= oInsets.top + oInsets.bottom;
        for (Component oComponent : aoComponents) {
            Point oPos = this.mf_oConstraints.get(oComponent);
            if (oPos != null) {
                oComponent.setBounds(oInsets.left + oPos.x, oInsets.top + oPos.y, oSize.width, oSize.height);
                continue;
            }
            oComponent.setBounds(oInsets.left, oInsets.top, oSize.width, oSize.height);
        }
    }
}

