/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.controller.CServerController;
import com.mayastudios.fred.client.controller.CViewController;
import com.mayastudios.fred.client.controller.MacUIListener;
import com.mayastudios.fred.client.controller.TrayIconController;
import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import com.mayastudios.fred.client.exceptions.CWorkfileVersionException;
import com.mayastudios.fred.client.exceptions.CXMLException;
import com.mayastudios.fred.client.filehandling.CEffortExportCSVSettings;
import com.mayastudios.fred.client.filehandling.CWorkfile;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.filehandling.Export;
import com.mayastudios.fred.client.filehandling.LastWorkFileInfo;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortTree;
import com.mayastudios.fred.client.model.CEffortVector;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.CURLList;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DataMask;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.GlobalSettings;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.ManualHelper;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.servertuning.CReplicationServiceEx;
import com.mayastudios.fred.client.servertuning.IEffortEx;
import com.mayastudios.fred.client.view.CMainWindow;
import com.mayastudios.fred.client.view.CView;
import com.mayastudios.fred.client.view.FredStatusBar;
import com.mayastudios.fred.client.view.QuickBar;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.ADialogEx2;
import com.mayastudios.fred.client.view.dialogs.CDlgExtrasGlobalSettings;
import com.mayastudios.fred.client.view.dialogs.CDlgExtrasOptions;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortCollectEffortsProjects;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortCollectNotification;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortEditEffort;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortExportCSVFormat;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortExportEffortsPath;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortReplicateNotification;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortSetCategoryForAll;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortSetTaskForAll;
import com.mayastudios.fred.client.view.dialogs.file.CDlgFileOpenWorkfile;
import com.mayastudios.fred.client.view.dialogs.file.CDlgFileSaveWorkfileAs;
import com.mayastudios.fred.client.view.dialogs.file.CDlgFileShowProperties;
import com.mayastudios.fred.client.view.dialogs.file.CreateWorkFileDlg;
import com.mayastudios.fred.client.view.dialogs.help.CDlgHelpQuickStart;
import com.mayastudios.fred.client.view.dialogs.help.CDlgHelpShowAbout;
import com.mayastudios.fred.client.view.dialogs.project.CDlgProjectBroadcastProject;
import com.mayastudios.fred.client.view.dialogs.project.CDlgProjectCreate;
import com.mayastudios.fred.client.view.dialogs.project.CDlgProjectProperties;
import com.mayastudios.fred.client.view.dialogs.project.CDlgProjectSubscribeProjectList;
import com.mayastudios.fred.client.view.dialogs.project.CDlgProjectSubscribeProjectURL;
import com.mayastudios.fred.client.view.dialogs.task.CDlgTaskCreateTask;
import com.mayastudios.fred.client.view.dialogs.task.CDlgTaskProperties;
import com.mayastudios.fred.client.view.dialogs.task.CDlgTaskSubscribeTaskList;
import com.mayastudios.fred.client.view.dialogs.task.CDlgTaskSubscribeTaskProject;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.ixml.labels.LabelGroup;
import com.mayastudios.ixml.labels.LabelsCore;
import com.mayastudios.launcher.AppInfo;
import com.mayastudios.mscl.CExecutionTime;
import com.mayastudios.mscl.ResourceLoaderInstance;
import com.mayastudios.mscl.mwt.ExceptionDlg;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.dockpane.ITabStateListener;
import com.mayastudios.mscl.mwt.widgets.DockedWindow;
import com.mayastudios.mscl.mwt.widgets.SplashScreen;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import com.mayastudios.mscl.mwt.windowcloser.IWindowCloseListener;
import de.sopra06.domainmodel.Project;
import de.sopra06.domainmodel.Task;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class MainController
extends Observable {
    public static final Logger LOGGER = LoggerFactory.getLogger(MainController.class);
    private static MainController s_oInstance = null;
    private ResourceLoaderInstance m_oResourceLoader;
    private CMainWindow.EWindowContent m_eWindowContent;
    private final Vector<CViewController> m_oViewControllers = new Vector();
    private CViewController m_oCurrentViewController;
    private CMainWindow m_oMainWindow;
    private CURLList m_oURLList;
    private CPersonImpl m_oUser;
    private CWorkfile m_oWorkfile;
    private int m_exitCode = 0;
    private File m_lastKnownWorkFileDirectory;
    private DataMask.MutableDataMask m_oCurrentStatusMask;
    private String strLabelNoFileLoaded = "";

    private MainController() {
    }

    public static MainController getInstance() {
        return s_oInstance;
    }

    public static void initMainController(ResourceLoaderInstance resourceLoaderInstance) {
        if (s_oInstance != null) {
            throw new Error("MainController has been already initialized!");
        }
        MainController.initExceptionDialog();
        s_oInstance = new MainController();
        MainController.s_oInstance.m_oResourceLoader = resourceLoaderInstance;
        WorkFileSettings.initialize();
        try {
            LabelsCore.setLocale((Locale)GlobalSettings.getLanguage().getLocale());
        }
        catch (LabelGroup.LocaleLoadException localeLoadException) {
            throw new ExceptionInInitializerError(localeLoadException);
        }
        MainController.s_oInstance.m_oMainWindow = new CMainWindow();
        CWindowCloser.initObservation((Window)MainController.s_oInstance.m_oMainWindow, (IWindowCloseListener)new IWindowCloseListener(){

            public boolean windowClosingPerformed() {
                return s_oInstance.closeWorkfile();
            }

            public int getExitCode() {
                return s_oInstance.m_exitCode;
            }

            public boolean terminateApp() {
                return true;
            }
        });
        s_oInstance.setContent(null);
        TrayIconController.init();
        try {
            Object obj = Class.forName("com.mayastudios.fred.client.controller.MacUIHandler").newInstance();
            Method method = obj.getClass().getDeclaredMethod("setListener", MacUIListener.class);
            method.invoke(obj, new CMacOSListener());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MainController.s_oInstance.strLabelNoFileLoaded = Labels.get("NO_FILE_LOADED", new Object[0]);
    }

    private static void initExceptionDialog() {
        ExceptionDlg.setMainWindowManager((ExceptionDlg.IMainWindowManager)new ExceptionDlg.IMainWindowManager(){

            public Window getMainWindow() {
                if (s_oInstance == null) {
                    return null;
                }
                return s_oInstance.m_oMainWindow;
            }

            public Image getMainWindowIcon() {
                return CMainWindow.MAIN_ICON.getImage();
            }

            public String getMainWindowTitle() {
                return "Fred 2009";
            }
        });
        ExceptionDlg.setReportABugListener((ExceptionDlg.IReportABugListener)new ExceptionDlg.IReportABugListener(){

            public String getButtonTooltipText() {
                return "Opens Fred's bug tracker in a browser window.";
            }

            public void onReportABug(Throwable throwable) {
                MainController.incomingHelpBugReporting();
            }
        });
    }

    public static ResourceLoaderInstance getResLoader() {
        return MainController.getInstance().m_oResourceLoader;
    }

    public void startUp() {
        this.m_oCurrentStatusMask = new DataMask.MutableDataMask();
        if (AppInfo.getAppArgs().length == 0) {
            this._initializeRecentPath();
            this._initializeWorkfile(LastWorkFileInfo.getLastOpenedWorkFilePath());
        } else {
            File file = new File(AppInfo.getAppArgs()[0]);
            if (!file.isAbsolute()) {
                file = new File(AppInfo.getWorkingDir(), file.getPath());
            }
            this._initializeWorkfile(file.getAbsoluteFile());
        }
        if (this.m_oMainWindow.getContent() == null) {
            throw new IllegalStateException();
        }
        LOGGER.info("Start up complete.");
    }

    private void _initializeRecentPath() {
        File file = LastWorkFileInfo.getLastOpenedWorkFilePath();
        if (file != null) {
            while (!file.exists()) {
                if (FredMessageBox.showOptionDlg(Labels.get("MsgBox.Workfile.RetryLoading", file.getAbsolutePath()), Labels.get("TITLE_OPENING_WORKFILE", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO) != MessageBox.EButton.NO) continue;
                LastWorkFileInfo.setLastOpenedWorkFilePath(null);
                file = null;
                break;
            }
        }
        this.setLastKnownWorkfileDirectory(file);
        LOGGER.info("Workfile that shall be loaded: " + file);
    }

    private boolean _initializeWorkfile(File file) {
        if (file == null) {
            this.setContent(CMainWindow.EWindowContent.StartScreen);
            return false;
        }
        return this._loadWorkfile(file);
    }

    private boolean _loadWorkfile(File file) {
        CExecutionTime cExecutionTime = new CExecutionTime();
        Exception exception = null;
        String string = null;
        this.m_oViewControllers.clear();
        try {
            this.m_oWorkfile = null;
            cExecutionTime.startTimer();
            this.m_oWorkfile = CWorkfile.load(file);
            cExecutionTime.stopTimer();
            if (this.m_oWorkfile == null) {
                this._clearEverything();
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = Labels.get("INFORMATION_LOADING_ERROR_NOTFOUND", new Object[0]);
            exception = fileNotFoundException;
        }
        catch (CXMLException cXMLException) {
            string = Labels.get("INFORMATION_LOADING_ERROR_PARSING", new Object[0]);
            exception = cXMLException.getCause() != null ? (Exception)cXMLException.getCause() : cXMLException;
        }
        catch (IOException iOException) {
            string = !file.exists() ? Labels.get("INFORMATION_LOADING_ERROR_FILELOST", new Object[0]) : Labels.get("INFORMATION_LOADING_ERROR_IO", new Object[0]);
            exception = iOException;
        }
        catch (CWorkfileVersionException cWorkfileVersionException) {
            string = cWorkfileVersionException.getMessage();
            exception = cWorkfileVersionException;
        }
        if (exception != null) {
            LOGGER.error("", (Throwable)exception);
            FredMessageBox.showInfoDlg(String.format(Labels.get("INFORMATION_LOADING_ERROR", new Object[0]), file, string), Labels.get("TITLE_OPENING_WORKFILE", new Object[0]), MessageBox.EIcon.ERROR, exception);
            this._clearEverything();
            return false;
        }
        FredStatusBar.setTextForInterval(String.format(Labels.get("STATUSBAR_WORKFILE_LOADED", new Object[0]), DateTime.getExactDurationString(cExecutionTime.getTimeDiffInMillis())));
        this.setContent(CMainWindow.EWindowContent.Views);
        if (this.m_oViewControllers.size() == 0) {
            MainController.incomingViewNewView();
        }
        return true;
    }

    private void _clearEverything() {
        ProjectList.clearInstance();
        ObjectFactoryImpl.destroyInstance();
        this.m_oURLList = null;
        this.m_oUser = null;
        DefaultTask.set(null);
        this.m_oWorkfile = null;
        this.m_oViewControllers.clear();
        this.m_oCurrentViewController = null;
        this.setContent(CMainWindow.EWindowContent.StartScreen);
    }

    private void setLastKnownWorkfileDirectory(File file) {
        if (file != null && file.exists()) {
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.m_lastKnownWorkFileDirectory = file;
        } else {
            this.m_lastKnownWorkFileDirectory = DirectoryUtil.getDefaultFileChooserDir();
        }
    }

    private void addViewControllerToTop(CViewController cViewController) {
        if (this.m_oCurrentViewController != cViewController) {
            if (!this.m_oViewControllers.contains(cViewController)) {
                this.m_oViewControllers.addElement(cViewController);
            }
            this.m_oCurrentViewController = cViewController;
            cViewController.updateNotification(EUpdateMessage.BecomesVisible, null, true);
        }
    }

    private CViewController _getCurrentViewController() {
        if (this.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            return this.m_oCurrentViewController;
        }
        return null;
    }

    private String _getErrorMessageByStatusShort(int n) {
        switch (n) {
            case 100: 
            case 500: {
                return Labels.get("INFORMATION_SERVER_ERROR_SHORT", new Object[0]);
            }
            case 300: {
                return Labels.get("INFORMATION_SERVER_PROJECT_CLOSED_SHORT", new Object[0]);
            }
            case 10000: {
                return Labels.get("INFORMATION_SERVER_EXCEPTION_SHORT", new Object[0]);
            }
            case 11000: {
                return Labels.get("INFORMATION_SERVER_USER_HAS_ABORTED_SHORT", new Object[0]);
            }
        }
        return "";
    }

    private void _refreshTitleBar() {
        String string;
        if (this.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            string = String.format("%s - %s - %s", "Fred 2009", this.getUser().toString(), this.getPathToWorkFile());
            if (this.m_oWorkfile.hasChanged()) {
                if (SystemInfo.OSSUBTYPE == SystemInfo.EOSSubType.MacOSX) {
                    this.getMainWindow().getRootPane().putClientProperty("windowModified", Boolean.TRUE);
                } else {
                    string = string + "*";
                }
            }
        } else {
            string = String.format("%s - %s", "Fred 2009", this.strLabelNoFileLoaded);
        }
        this.getMainWindow().setTitle(string);
    }

    void publishStatusMask() {
        this.m_oCurrentStatusMask = new DataMask.MutableDataMask();
        if (this.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            CViewController cViewController = this._getCurrentViewController();
            ProjectList projectList = ProjectList.getInstance();
            if (cViewController != null) {
                this.m_oCurrentStatusMask = cViewController.getStatusMask();
            }
            this.m_oCurrentStatusMask.isFileOpened = true;
            this.m_oCurrentStatusMask.isViewOpened = this.m_oViewControllers != null && this.m_oViewControllers.size() > 0;
            this.m_oCurrentStatusMask.isOpenLocalProjectAvailable = projectList.existsBroadcastableProject();
            this.m_oCurrentStatusMask.isOpenTeamProjectAvailable = projectList.existsBroadcastedUnclosedProject();
            this.m_oCurrentStatusMask.isOpenTeamTaskAvailable = projectList.existsBroadcastedUnclosedTask();
            this.m_oCurrentStatusMask.isOpenProjectAvailable = projectList.getProjectForTaskCreation() != null;
            this.m_oCurrentStatusMask.isOpenTaskAvailable = DefaultTask.isSet();
        } else {
            this.m_oCurrentStatusMask.isFileOpened = false;
        }
        this.notifyObservers();
    }

    @Override
    public void notifyObservers() {
        this.m_oCurrentStatusMask.madeChanges = this.m_oWorkfile != null && this.m_oWorkfile.hasChanged();
        super.setChanged();
        this.notifyObservers(this.m_oCurrentStatusMask.readonly());
        super.clearChanged();
        this._refreshTitleBar();
    }

    public void notifyControllers(EUpdateMessage eUpdateMessage, Collection<?> collection) {
        if (this.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            CViewController cViewController = this._getCurrentViewController();
            if (cViewController != null) {
                cViewController.updateNotification(eUpdateMessage, collection, true);
            }
            for (CViewController cViewController2 : this.m_oViewControllers) {
                if (cViewController2 == cViewController) continue;
                cViewController2.updateNotification(eUpdateMessage, collection, false);
            }
            if (cViewController != null) {
                cViewController.updateNotification(EUpdateMessage.VisualUpdate, null, true);
            }
            this.m_oWorkfile.setChanged();
            this.notifyObservers();
        }
    }

    public CMainWindow.EWindowContent getContent() {
        return this.m_eWindowContent;
    }

    public void setContent(CMainWindow.EWindowContent eWindowContent) {
        if (this.m_eWindowContent == eWindowContent) {
            return;
        }
        this.m_eWindowContent = eWindowContent;
        this.m_oMainWindow.setContent(this.m_eWindowContent);
        this.publishStatusMask();
        this._refreshTitleBar();
    }

    public CPersonImpl getUser() {
        return this.m_oUser;
    }

    public Vector<CPersonImpl> getUserVector() {
        Vector<CPersonImpl> vector = new Vector<CPersonImpl>(1);
        vector.add(this.getUser());
        return vector;
    }

    public File getPathToWorkFile() {
        return this.m_oWorkfile.getWorkFilePath();
    }

    public static void bringMainWindowToFront() {
        if (MainController.s_oInstance.m_oMainWindow != null) {
            GUIHelper.forceFrameToFront((Frame)MainController.s_oInstance.m_oMainWindow);
        }
    }

    public CMainWindow getMainWindow() {
        return this.m_oMainWindow;
    }

    public CURLList getURLList() {
        return this.m_oURLList;
    }

    public DataMask getCurrentStatusMask() {
        return this.m_oCurrentStatusMask.readonly();
    }

    public Calendar getCreatedAt() {
        return this.m_oWorkfile.getCreatedAt();
    }

    public Calendar getLastSaved() {
        return this.m_oWorkfile.getLastSaved();
    }

    public void createURLList() {
        if (this.m_oURLList == null) {
            this.m_oURLList = new CURLList();
        }
    }

    public static void incomingFileCreateWorkfile() {
        if (!s_oInstance.closeWorkfile()) {
            return;
        }
        CreateWorkFileDlg createWorkFileDlg = new CreateWorkFileDlg();
        if (createWorkFileDlg.showDialog() == ADialogEx.EReturnValue.OK) {
            ObjectFactoryImpl.createInstance();
            ProjectList.createInstance();
            WorkFileSettings.initialize();
            MainController.s_oInstance.m_oUser = CPersonImpl.create();
            MainController.s_oInstance.m_oUser.setFirstName(createWorkFileDlg.getFirstName());
            MainController.s_oInstance.m_oUser.setName(createWorkFileDlg.getLastName());
            MainController.s_oInstance.m_oUser.setInitials(createWorkFileDlg.getParaph());
            MainController.s_oInstance.m_oURLList = new CURLList();
            File file = createWorkFileDlg.getWorkFilePath();
            s_oInstance.setLastKnownWorkfileDirectory(file);
            MainController.s_oInstance.m_oViewControllers.clear();
            MainController.s_oInstance.m_oWorkfile = CWorkfile.createWorkfile(file);
            if (MainController.s_oInstance.m_oWorkfile == null) {
                s_oInstance._clearEverything();
                return;
            }
            s_oInstance.setContent(CMainWindow.EWindowContent.Views);
            MainController.incomingViewNewView();
            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_WORKFILE_CREATED", new Object[0]));
        }
    }

    public static void incomingFileOpenWorkfile() {
        if (!s_oInstance.closeWorkfile()) {
            return;
        }
        CDlgFileOpenWorkfile cDlgFileOpenWorkfile = MainController.s_oInstance.m_lastKnownWorkFileDirectory == null ? new CDlgFileOpenWorkfile() : new CDlgFileOpenWorkfile(MainController.s_oInstance.m_lastKnownWorkFileDirectory);
        File file = cDlgFileOpenWorkfile.getWorkFilePath();
        if (file == null) {
            return;
        }
        s_oInstance.setLastKnownWorkfileDirectory(file);
        if (s_oInstance._initializeWorkfile(file)) {
            LastWorkFileInfo.setLastOpenedWorkFilePath(file);
        }
    }

    public static boolean incomingFileSaveWorkfile() {
        return MainController._saveWorkfile(false);
    }

    public static void incomingFileSaveWorkfileAs() {
        CWorkfile cWorkfile = MainController.s_oInstance.m_oWorkfile;
        CDlgFileSaveWorkfileAs cDlgFileSaveWorkfileAs = new CDlgFileSaveWorkfileAs(MainController.s_oInstance.m_lastKnownWorkFileDirectory);
        if (!cDlgFileSaveWorkfileAs.wasSuccessful()) {
            return;
        }
        MainController.s_oInstance.m_oWorkfile = MainController.s_oInstance.m_oWorkfile.clone(cDlgFileSaveWorkfileAs.getWorkFilePath());
        if (MainController._saveWorkfile(true)) {
            s_oInstance.setLastKnownWorkfileDirectory(MainController.s_oInstance.m_oWorkfile.getWorkFilePath());
        } else {
            MainController.s_oInstance.m_oWorkfile = cWorkfile;
        }
    }

    private static boolean _saveWorkfile(boolean bl) {
        CExecutionTime cExecutionTime = new CExecutionTime();
        cExecutionTime.startTimer();
        if (MainController.s_oInstance.m_oWorkfile.save(bl)) {
            cExecutionTime.stopTimer();
            s_oInstance.notifyObservers();
            FredStatusBar.setTextForInterval(String.format(Labels.get("STATUSBAR_WORKFILE_SAVED", new Object[0]), DateTime.getExactDurationString(cExecutionTime.getTimeDiffInMillis())));
            return true;
        }
        FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_WORKFILE_NOT_SAVED", new Object[0]));
        return false;
    }

    public static void incomingFileShowProperties() {
        CDlgFileShowProperties.showDialog(s_oInstance.getUser(), s_oInstance.getPathToWorkFile());
    }

    public static boolean incomingFileClose() {
        if (!s_oInstance.closeWorkfile()) {
            return false;
        }
        LastWorkFileInfo.setLastOpenedWorkFilePath(null);
        return true;
    }

    private boolean closeWorkfile() {
        if (this.m_eWindowContent != CMainWindow.EWindowContent.Views) {
            return true;
        }
        if (QuickBar.getInstance().isRecording()) {
            Object[] objectArray = new String[]{Labels.get("BUTTON_MEASURE", new Object[0]), Labels.get("BUTTON_DISCARD", new Object[0]), Labels.get("BUTTON_CANCEL", new Object[0])};
            MainController.bringMainWindowToFront();
            int n = JOptionPane.showOptionDialog(this.getMainWindow(), Labels.get("OPTION_QUICKBAR_ONCLOSE", new Object[0]), Labels.get("OPTION_QUICKBAR_ONCLOSE_TITLE", new Object[0]), 1, 3, null, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    if (QuickBar.getInstance().stopRecording(false)) break;
                    return false;
                }
                case 1: {
                    QuickBar.getInstance().stopRecording(true);
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        if (!this.m_oWorkfile.close()) {
            return false;
        }
        this._clearEverything();
        return true;
    }

    public static void incomingFileExit() {
        MainController.exit(0);
    }

    public static void exit(int n) {
        if (s_oInstance.closeWorkfile()) {
            MainController.s_oInstance.m_exitCode = n;
            CWindowCloser.closeWindow((Window)MainController.s_oInstance.m_oMainWindow);
        }
    }

    public static void incomingViewNewView() {
        s_oInstance._newViewByFilter(null);
    }

    private void _newViewByFilter(AFilter aFilter) {
        this._newViewByFilter(aFilter, null);
    }

    private void _newViewByFilter(AFilter aFilter, String string) {
        new CViewController(aFilter, string);
    }

    public static void incomingViewDuplicateView() {
        s_oInstance._getCurrentViewController().duplicate();
    }

    public static void incomingViewCloseView() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            MainController.s_oInstance.m_oMainWindow.removeView(cViewController.getView());
        }
    }

    public void eventViewClosed(CViewController cViewController) {
        CViewController cViewController2;
        this.m_oViewControllers.remove(cViewController);
        if (this.m_oCurrentViewController == cViewController) {
            this.m_oCurrentViewController = null;
        }
        if ((cViewController2 = this._getCurrentViewController()) != null) {
            cViewController2.updateNotification(EUpdateMessage.BecomesVisible, null, true);
            this.addViewControllerToTop(cViewController2);
        } else {
            FredStatusBar.resetEffortData();
            this.publishStatusMask();
        }
    }

    public static void incomingViewQuickbar() {
        QuickBar quickBar;
        quickBar.setVisible(!(quickBar = QuickBar.getInstance()).isVisible());
    }

    public static void incomingViewQuickbarLeft() {
        QuickBar quickBar = QuickBar.getInstance();
        quickBar.setVisible(true);
        quickBar.setDockingBorder(DockedWindow.DockingBorder.LEFT);
    }

    public static void incomingViewQuickbarTop() {
        QuickBar quickBar = QuickBar.getInstance();
        quickBar.setVisible(true);
        quickBar.setDockingBorder(DockedWindow.DockingBorder.TOP);
    }

    public static void incomingViewQuickbarRight() {
        QuickBar quickBar = QuickBar.getInstance();
        quickBar.setVisible(true);
        quickBar.setDockingBorder(DockedWindow.DockingBorder.RIGHT);
    }

    public static void incomingViewQuickbarBottom() {
        QuickBar quickBar = QuickBar.getInstance();
        quickBar.setVisible(true);
        quickBar.setDockingBorder(DockedWindow.DockingBorder.BOTTOM);
    }

    public static void incomingViewCustomizeColumns() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            cViewController.incomingViewCustomizeColumns();
        }
    }

    public static void incomingProjectCreate() {
        if (MainController.s_oInstance.m_eWindowContent != CMainWindow.EWindowContent.Views) {
            throw new IllegalStateException();
        }
        CDlgProjectCreate cDlgProjectCreate = new CDlgProjectCreate();
        if (cDlgProjectCreate.showDialog() == ADialogEx.EReturnValue.OK) {
            CProjectImpl cProjectImpl = cDlgProjectCreate.getProject();
            ProjectList.getInstance().addProject(cProjectImpl, true);
            s_oInstance.notifyControllers(EUpdateMessage.ProjectCreated, Collections.singleton(cProjectImpl));
            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_CREATED", new Object[0]));
        }
    }

    public static void incomingProjectProperties() {
        CProjectImpl cProjectImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cProjectImpl = cViewController.getSelectedProject()) != null) {
            CDlgProjectProperties cDlgProjectProperties = new CDlgProjectProperties(cProjectImpl);
            if (cDlgProjectProperties.showDialog() == ADialogEx.EReturnValue.OK) {
                if (!cProjectImpl.isClosed() && cDlgProjectProperties.isClosed()) {
                    MainController.incomingProjectClose();
                }
                s_oInstance.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_EDITED", new Object[0]));
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingProjectClose() {
        CProjectImpl cProjectImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cProjectImpl = cViewController.getSelectedProject()) != null) {
            if (cProjectImpl.isClosed()) {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_ALREADY_CLOSED", new Object[0]) + "\n" + cProjectImpl.toString(), Labels.get("TITLE_CLOSE_PROJECT", new Object[0]), MessageBox.EIcon.WARNING);
                return;
            }
            if (!cProjectImpl.isUserProjectLeader()) {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_CLOSE_NOT_PROJECTLEADER", new Object[0]) + "\n" + cProjectImpl.toString(), Labels.get("TITLE_CLOSE_PROJECT", new Object[0]), MessageBox.EIcon.ERROR);
                return;
            }
            MessageBox.EButton eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_CLOSE_PROJECT", new Object[0]) + "\n" + cProjectImpl.toString(), Labels.get("TITLE_CLOSE_PROJECT", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO);
            if (eButton == MessageBox.EButton.YES) {
                if (cProjectImpl.isTeamProject()) {
                    CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                    cReplicationServiceEx.setURL(cProjectImpl.getServerURL());
                    cReplicationServiceEx.setObjectFactory(ObjectFactoryImpl.getInstance());
                    cReplicationServiceEx.setProjects(cProjectImpl.toVector());
                    cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                    CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.closeProject);
                    cServerController.start();
                    if (cServerController.getStatus() != 200) {
                        s_oInstance._checkAndCloseProject(cServerController.getStatus(), cProjectImpl);
                    } else {
                        FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_CLOSED_ON_SERVER", new Object[0]), Labels.get("TITLE_CLOSE_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                        cProjectImpl.close();
                        if (cProjectImpl == DefaultTask.getProject()) {
                            DefaultTask.set(null);
                            FredMessageBox.showInfoDlg(Labels.get("DefaultTask.Unavailable.MsgBoxText", new Object[0]), Labels.get("DefaultTask.Unavailable.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
                        }
                        s_oInstance.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
                        FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_CLOSED", new Object[0]));
                    }
                } else {
                    cProjectImpl.close();
                    if (cProjectImpl == DefaultTask.getProject()) {
                        DefaultTask.set(null);
                        FredMessageBox.showInfoDlg(Labels.get("DefaultTask.Unavailable.MsgBoxText", new Object[0]), Labels.get("DefaultTask.Unavailable.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
                    }
                    s_oInstance.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_CLOSED", new Object[0]));
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    private void _checkAndCloseProject(int n, CProjectImpl cProjectImpl) {
        if (n == 300 && !cProjectImpl.isClosed()) {
            cProjectImpl.setClosed(true);
            this.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
        }
    }

    public static void incomingProjectDeleteProject() {
        CProjectImpl cProjectImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cProjectImpl = cViewController.getSelectedProject()) != null) {
            MessageBox.EButton eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_DELETE_PROJECT", cProjectImpl), Labels.get("TITLE_DELETE_PROJECT", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO);
            if (eButton == MessageBox.EButton.YES) {
                if (cProjectImpl == DefaultTask.getProject()) {
                    DefaultTask.set(null);
                    FredMessageBox.showInfoDlg(Labels.get("DefaultTask.Unavailable.MsgBoxText", new Object[0]), Labels.get("DefaultTask.Unavailable.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
                }
                ProjectList.getInstance().removeProject(cProjectImpl);
                ObjectFactoryImpl.destroy(cProjectImpl);
                s_oInstance.notifyControllers(EUpdateMessage.ProjectDeleted, Collections.singleton(cProjectImpl));
                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_DELETED", new Object[0]));
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingProjectBroadcastProject() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            CDlgProjectBroadcastProject cDlgProjectBroadcastProject;
            CProjectImpl cProjectImpl = cViewController.getSelectedProject();
            if (cProjectImpl != null && (cProjectImpl.isClosed() || !cProjectImpl.isUserProjectLeader() || cProjectImpl.isTeamProject())) {
                cProjectImpl = null;
            }
            if ((cDlgProjectBroadcastProject = new CDlgProjectBroadcastProject(cProjectImpl, null, false)).showDialog() == ADialogEx.EReturnValue.OK) {
                cProjectImpl = cDlgProjectBroadcastProject.getSelectedProject();
                CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                cReplicationServiceEx.setURL(cDlgProjectBroadcastProject.getSelectedURL());
                cReplicationServiceEx.setProjects(cProjectImpl.toVector());
                cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.sendNewProject);
                cServerController.start();
                if (cServerController.getStatus() == 200) {
                    cProjectImpl.setServerURL(cDlgProjectBroadcastProject.getSelectedURL());
                    cProjectImpl.setTeamproject(true);
                    s_oInstance.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
                    Vector<CTaskImpl> vector = cDlgProjectBroadcastProject.getSelectedTaskList();
                    if (vector.size() > 0) {
                        cReplicationServiceEx = new CReplicationServiceEx();
                        cReplicationServiceEx.setURL(cDlgProjectBroadcastProject.getSelectedURL());
                        cReplicationServiceEx.setProjects(cProjectImpl.toVector());
                        cReplicationServiceEx.setTasks(vector);
                        cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                        cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.sendNewTasks);
                        cServerController.start();
                        if (cServerController.getStatus() == 200) {
                            Iterator<CTaskImpl> iterator = vector.iterator();
                            while (iterator.hasNext()) {
                                iterator.next().setTeamTask(true);
                            }
                            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_AND_TASKS_BROADCASTED", new Object[0]), Labels.get("TITLE_BROADCAST_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                            s_oInstance.notifyControllers(EUpdateMessage.TaskUpdated, vector);
                            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_AND_TASKS_BROADCASTED", new Object[0]));
                        }
                    } else {
                        FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_BROADCASTED", new Object[0]), Labels.get("TITLE_BROADCAST_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                        s_oInstance.notifyControllers(EUpdateMessage.ProjectUpdated, Collections.singleton(cProjectImpl));
                        FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_BROADCASTED", new Object[0]));
                    }
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingProjectSubscribeProject() {
        if (MainController.s_oInstance.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            CDlgProjectSubscribeProjectURL cDlgProjectSubscribeProjectURL = new CDlgProjectSubscribeProjectURL(MainController.s_oInstance.m_oURLList.getURLVector());
            if (cDlgProjectSubscribeProjectURL.showDialog() == ADialogEx.EReturnValue.OK) {
                CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                cReplicationServiceEx.setObjectFactory(ObjectFactoryImpl.getInstance());
                cReplicationServiceEx.setURL(cDlgProjectSubscribeProjectURL.getURL());
                CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.receiveProjects);
                cServerController.start();
                if (cServerController.getStatus() == 200) {
                    Vector<? extends Project> vector = cReplicationServiceEx.getProjects();
                    ProjectList projectList = ProjectList.getInstance();
                    projectList.deleteContained(vector);
                    CDlgProjectSubscribeProjectList cDlgProjectSubscribeProjectList = new CDlgProjectSubscribeProjectList(vector);
                    if (cDlgProjectSubscribeProjectList.showDialog() == ADialogEx.EReturnValue.OK) {
                        CProjectImpl cProjectImpl = cDlgProjectSubscribeProjectList.getProject();
                        if (!projectList.isProjectNameValid(cProjectImpl, cProjectImpl.getName())) {
                            FredMessageBox.showInfoDlg(Labels.get("PROJECT_NAME_EXISTS_LOCAL", new Object[0]) + "\n" + cProjectImpl.getName(), Labels.get("TITLE_SUBSCRIBE_PROJECT", new Object[0]), MessageBox.EIcon.WARNING);
                        } else {
                            cProjectImpl.setSubscribedNow();
                            cProjectImpl.setTeamproject(true);
                            cProjectImpl.setServerURL(cDlgProjectSubscribeProjectURL.getURL());
                            projectList.addProject(cProjectImpl, true);
                            s_oInstance.notifyControllers(EUpdateMessage.ProjectCreated, Collections.singleton(cProjectImpl));
                            vector.removeElement(cProjectImpl);
                            if (cDlgProjectSubscribeProjectList.startSubscribeTasks()) {
                                int n = s_oInstance._localTaskSubscribeTasks(cProjectImpl);
                                if (n > 0) {
                                    FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_AND_TASK_SUBSCRIBED", new Object[0]) + "\n" + cProjectImpl.getName(), Labels.get("TITLE_SUBSCRIBE_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_SUBSCRIBED", new Object[0]));
                                } else if (n == 0) {
                                    FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_SUBSCRIBED_NO_TASKS", new Object[0]) + "\n" + cProjectImpl.getName(), Labels.get("TITLE_SUBSCRIBE_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_AND_TASKS_SUBSCRIBED", new Object[0]));
                                }
                            } else {
                                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_PROJECT_SUBSCRIBED", new Object[0]) + "\n" + cProjectImpl.getName(), Labels.get("TITLE_SUBSCRIBE_PROJECT", new Object[0]), MessageBox.EIcon.INFORMATION);
                                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_PROJECT_SUBSCRIBED", new Object[0]));
                            }
                        }
                    }
                    ObjectFactoryImpl.destroy(vector);
                    return;
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingTaskCreateTask() {
        CDlgTaskCreateTask cDlgTaskCreateTask;
        if (MainController.s_oInstance.m_eWindowContent != CMainWindow.EWindowContent.Views) {
            throw new IllegalStateException();
        }
        if (ProjectList.getInstance().getProjectForTaskCreation() == null) {
            FredMessageBox.showInfoDlg(Labels.get("Tasks.Create.MsgBoxText", new Object[0]), Labels.get("Tasks.Create.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
            return;
        }
        CViewController cViewController = s_oInstance._getCurrentViewController();
        CProjectImpl cProjectImpl = null;
        CategoryList.CCategory cCategory = null;
        if (cViewController != null) {
            cProjectImpl = cViewController.getSelectedProject();
            if (cProjectImpl != null && !cProjectImpl.isUserProjectLeader()) {
                cProjectImpl = null;
            }
            cCategory = cViewController.getSelectedCategory();
        }
        if ((cDlgTaskCreateTask = new CDlgTaskCreateTask(cProjectImpl, cCategory)).showDialog() == ADialogEx.EReturnValue.OK) {
            CTaskImpl cTaskImpl = cDlgTaskCreateTask.getCreatedTask();
            CProjectImpl cProjectImpl2 = cTaskImpl.getProject();
            cProjectImpl2.addTask(cTaskImpl, true);
            if (!DefaultTask.isSet()) {
                DefaultTask.set(cTaskImpl);
            }
            s_oInstance.notifyControllers(EUpdateMessage.TasksCreated, Collections.singleton(cTaskImpl));
            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_TASK_CREATED", new Object[0]));
        }
    }

    public static void incomingTaskProperties() {
        CTaskImpl cTaskImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cTaskImpl = cViewController.getSelectedTask()) != null) {
            CDlgTaskProperties cDlgTaskProperties = new CDlgTaskProperties(cTaskImpl);
            if (cDlgTaskProperties.showDialog() == ADialogEx.EReturnValue.OK) {
                s_oInstance.notifyControllers(EUpdateMessage.TaskUpdated, Collections.singleton(cTaskImpl));
                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_TASK_EDITED", new Object[0]));
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingTaskDefaultTask() {
        CTaskImpl cTaskImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cTaskImpl = cViewController.getSelectedTask()) != null) {
            if (cTaskImpl.getProject().isClosed()) {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_DEFAULT_TASK_CLOSED", new Object[0]), Labels.get("TITLE_DEFAULT_TASK", new Object[0]), MessageBox.EIcon.WARNING);
            } else {
                CTaskImpl cTaskImpl2 = DefaultTask.get();
                DefaultTask.set(cTaskImpl);
                ArrayList<CTaskImpl> arrayList = new ArrayList<CTaskImpl>(2);
                arrayList.add(cTaskImpl2);
                arrayList.add(cTaskImpl);
                s_oInstance.notifyControllers(EUpdateMessage.DefaultTaskChanged, arrayList);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingTaskDeleteTask() {
        CTaskImpl cTaskImpl;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null && (cTaskImpl = cViewController.getSelectedTask()) != null) {
            MessageBox.EButton eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_DELETE_TASK", cTaskImpl), Labels.get("TITLE_DELETE_TASK", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO);
            if (eButton == MessageBox.EButton.YES) {
                if (cTaskImpl == DefaultTask.get()) {
                    DefaultTask.set(null);
                    FredMessageBox.showInfoDlg(Labels.get("DefaultTask.Unavailable.MsgBoxText", new Object[0]), Labels.get("DefaultTask.Unavailable.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
                }
                cTaskImpl.getProject().removeTask(cTaskImpl);
                ObjectFactoryImpl.destroy(cTaskImpl);
                s_oInstance.notifyControllers(EUpdateMessage.TaskDeleted, Collections.singleton(cTaskImpl));
                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_TASK_DELETED", new Object[0]));
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingTaskSubscribeTask() {
        if (MainController.s_oInstance.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            CDlgTaskSubscribeTaskProject cDlgTaskSubscribeTaskProject;
            CViewController cViewController = s_oInstance._getCurrentViewController();
            CProjectImpl cProjectImpl = null;
            if (cViewController != null && (cProjectImpl = cViewController.getSelectedProject()) != null && (!cProjectImpl.isTeamProject() || cProjectImpl.isUserProjectLeader())) {
                cProjectImpl = null;
            }
            if ((cDlgTaskSubscribeTaskProject = new CDlgTaskSubscribeTaskProject(cProjectImpl, ProjectList.getInstance().getSubscribedProjectComboBoxModel())).showDialog() == ADialogEx.EReturnValue.OK) {
                int n = s_oInstance._localTaskSubscribeTasks(cDlgTaskSubscribeTaskProject.getProject());
                if (n == 0) {
                    FredMessageBox.showInfoDlg(Labels.get("INFORMATION_NO_TASKS_AVAILABLE", new Object[0]), Labels.get("TITLE_SUBSCRIBE_TASK", new Object[0]), MessageBox.EIcon.WARNING);
                } else if (n > 0) {
                    FredMessageBox.showInfoDlg(Labels.get("INFORMATION_TASK_SUBSCRIBED", new Object[0]), Labels.get("TITLE_SUBSCRIBE_TASK", new Object[0]), MessageBox.EIcon.INFORMATION);
                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_TASK_SUBSCRIBED", new Object[0]));
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    private int _localTaskSubscribeTasks(CProjectImpl cProjectImpl) {
        int n = -1;
        CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
        cReplicationServiceEx.setObjectFactory(ObjectFactoryImpl.getInstance());
        cReplicationServiceEx.setURL(cProjectImpl.getServerURL());
        cReplicationServiceEx.setProjects(cProjectImpl.toVector());
        cReplicationServiceEx.setPersons(this.getUserVector());
        CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.receiveTasks);
        cServerController.start();
        if (cServerController.getStatus() != 200) {
            this._checkAndCloseProject(cServerController.getStatus(), cProjectImpl);
        } else {
            Vector<? extends Task> vector = cReplicationServiceEx.getTasks();
            cProjectImpl.deleteContained(vector);
            if (vector.size() == 0) {
                n = 0;
            } else {
                CDlgTaskSubscribeTaskList cDlgTaskSubscribeTaskList = new CDlgTaskSubscribeTaskList(vector);
                if (cDlgTaskSubscribeTaskList.showDialog() == ADialogEx.EReturnValue.OK) {
                    Vector<CTaskImpl> vector2 = cDlgTaskSubscribeTaskList.getTaskVector();
                    Vector<CTaskImpl> vector3 = new Vector<CTaskImpl>();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (vector2.size() > 0) {
                        for (CTaskImpl cTaskImpl : vector2) {
                            if (cProjectImpl.isTaskNameValid(null, cTaskImpl.getName()) && cProjectImpl.isTaskShortNameValid(null, cTaskImpl.getShortName())) {
                                vector3.add(cTaskImpl);
                                cTaskImpl.setTeamTask(true);
                                cTaskImpl.setSubscribedNow();
                                cTaskImpl.setProject(cProjectImpl);
                                cProjectImpl.addTask(cTaskImpl, true);
                                vector.removeElement(cTaskImpl);
                                if (DefaultTask.get() != null) continue;
                                DefaultTask.set(cTaskImpl);
                                continue;
                            }
                            stringBuffer.append(cTaskImpl.toString() + "\n");
                        }
                        if (stringBuffer.length() > 0) {
                            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_TASKNAME_ALREADY_USED", new Object[0]) + "\n" + stringBuffer.toString(), Labels.get("TITLE_SUBSCRIBE_TASK", new Object[0]), MessageBox.EIcon.WARNING);
                        }
                        this.notifyControllers(EUpdateMessage.TasksCreated, vector3);
                        n = vector3.size();
                    } else {
                        n = 0;
                    }
                }
            }
            ObjectFactoryImpl.destroy(vector);
        }
        return n;
    }

    public static void incomingTaskBroadcastTask() {
        if (MainController.s_oInstance.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            Vector<CTaskImpl> vector;
            CDlgProjectBroadcastProject cDlgProjectBroadcastProject;
            CProjectImpl cProjectImpl = null;
            CTaskImpl cTaskImpl = null;
            CViewController cViewController = s_oInstance._getCurrentViewController();
            if (cViewController != null) {
                cProjectImpl = cViewController.getSelectedProject();
                cTaskImpl = cViewController.getSelectedTask();
                if (cTaskImpl != null) {
                    cProjectImpl = cTaskImpl.getProject();
                    if (cProjectImpl.isClosed() || !cProjectImpl.isUserProjectLeader() || cTaskImpl.isTeamTask()) {
                        cProjectImpl = null;
                        cTaskImpl = null;
                    }
                } else if (!(cProjectImpl == null || !cProjectImpl.isClosed() && cProjectImpl.isUserProjectLeader() && cProjectImpl.isTeamProject())) {
                    cProjectImpl = null;
                }
            }
            if ((cDlgProjectBroadcastProject = new CDlgProjectBroadcastProject(cProjectImpl, cTaskImpl, true)).showDialog() == ADialogEx.EReturnValue.OK && (vector = cDlgProjectBroadcastProject.getSelectedTaskList()).size() > 0) {
                CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                cReplicationServiceEx.setURL(cDlgProjectBroadcastProject.getSelectedURL());
                cReplicationServiceEx.setProjects(vector.get(0).getProject().toVector());
                cReplicationServiceEx.setTasks(vector);
                cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.sendNewTasks);
                cServerController.start();
                if (cServerController.getStatus() != 200) {
                    s_oInstance._checkAndCloseProject(cServerController.getStatus(), vector.get(0).getProject());
                } else {
                    Iterator<CTaskImpl> iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().setTeamTask(true);
                    }
                    FredMessageBox.showInfoDlg(Labels.get("INFORMATION_TASK_BROADCASTED", new Object[0]), Labels.get("TITLE_BROADCAST_TASK", new Object[0]), MessageBox.EIcon.INFORMATION);
                    s_oInstance.notifyControllers(EUpdateMessage.TaskUpdated, vector);
                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_TASK_BROADCASTED", new Object[0]));
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortCreateEffort() {
        Object object;
        if (MainController.s_oInstance.m_eWindowContent != CMainWindow.EWindowContent.Views) {
            return;
        }
        if (!DefaultTask.isSet()) {
            FredMessageBox.showInfoDlg(Labels.get("DefaultTask.Unavailable.MsgBoxText", new Object[0]), Labels.get("DefaultTask.Unavailable.MsgBoxTitle", new Object[0]), MessageBox.EIcon.WARNING);
            return;
        }
        CEffortImpl cEffortImpl = CEffortImpl.create();
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            object = cViewController.getSelectedTask();
            CProjectImpl cProjectImpl = cViewController.getSelectedProject();
            AFilter.CCategoryProjectMapper cCategoryProjectMapper = cViewController.getSelectedCategoryMapped();
            if (object != null && !((CTaskImpl)object).getProject().isClosed()) {
                cEffortImpl.setTask((Task)object);
                cEffortImpl.setCategory(((CTaskImpl)object).getDefaultCategory());
            } else if (cProjectImpl != null && cProjectImpl != DefaultTask.getProject() && cProjectImpl.getTaskCount() > 0 && !cProjectImpl.isClosed()) {
                object = cProjectImpl.getTaskIterator().next();
                cEffortImpl.setTask((Task)object);
                cEffortImpl.setCategory(((CTaskImpl)object).getDefaultCategory());
            } else if (cCategoryProjectMapper != null && (cProjectImpl = cCategoryProjectMapper.getProject()).getTaskCount() > 0 && !cProjectImpl.isClosed()) {
                object = cProjectImpl.getTaskIterator().next();
                cEffortImpl.setTask((Task)object);
                cEffortImpl.setCategory(cCategoryProjectMapper.getCategory());
            }
        }
        if (((ADialogEx)(object = new CDlgEffortEditEffort(cEffortImpl, false, true))).showDialog() == ADialogEx.EReturnValue.OK) {
            cEffortImpl.setTask(((CDlgEffortEditEffort)object).getNewTask());
            cEffortImpl.setBegin(((CDlgEffortEditEffort)object).getBegin());
            cEffortImpl.setDuration(((CDlgEffortEditEffort)object).getWorkDuration());
            cEffortImpl.setPauseDuration(((CDlgEffortEditEffort)object).getPauseDuration());
            ProjectList.getInstance().addEffort(cEffortImpl);
            s_oInstance.notifyControllers(EUpdateMessage.EffortsCreated, Collections.singleton(cEffortImpl));
            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_CREATED", new Object[0]));
        }
    }

    public static void incomingEffortEditEffort() {
        CEffortImpl cEffortImpl = null;
        CDlgEffortEditEffort cDlgEffortEditEffort = null;
        CViewController cViewController = null;
        cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            cEffortImpl = cViewController.getSelectedEffort();
        }
        if (cEffortImpl == null) {
            throw new IllegalStateException();
        }
        cDlgEffortEditEffort = new CDlgEffortEditEffort(cEffortImpl, false, false);
        if (cDlgEffortEditEffort.showDialog() == ADialogEx.EReturnValue.OK) {
            if (cEffortImpl.getTask() != cDlgEffortEditEffort.getNewTask()) {
                ProjectList.getInstance().removeEffort(cEffortImpl);
                cEffortImpl.setTask(cDlgEffortEditEffort.getNewTask());
                cEffortImpl.setBegin(cDlgEffortEditEffort.getBegin());
                cEffortImpl.setDuration(cDlgEffortEditEffort.getWorkDuration());
                cEffortImpl.setPauseDuration(cDlgEffortEditEffort.getPauseDuration());
                ProjectList.getInstance().addEffort(cEffortImpl);
            } else if (!cEffortImpl.getBegin().equals(cDlgEffortEditEffort.getBegin()) || cEffortImpl.getDuration() != cDlgEffortEditEffort.getWorkDuration() || cEffortImpl.getPauseDuration() != cDlgEffortEditEffort.getPauseDuration()) {
                CTaskImpl cTaskImpl = cEffortImpl.getTask();
                cTaskImpl.repositionEffort(cEffortImpl, cDlgEffortEditEffort.getBegin(), cDlgEffortEditEffort.getWorkDuration(), cDlgEffortEditEffort.getPauseDuration());
            }
            if (!cEffortImpl.isColliding()) {
                cEffortImpl.setIgnoreMistake(false);
            }
            s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, Collections.singleton(cEffortImpl));
            FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_EDITED", new Object[0]));
        }
    }

    public static void incomingEffortDeleteEfforts() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            CEffortTree cEffortTree = new CEffortTree();
            cEffortTree.addAll(cViewController.getSelectedEfforts());
            if (cEffortTree.size() > 0) {
                MessageBox.EButton eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_DELETE_EFFORTS", cEffortTree.size()), Labels.get("TITLE_DELETE_EFFORTS", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO);
                if (eButton == MessageBox.EButton.YES) {
                    Iterator iterator = cEffortTree.iterator();
                    ProjectList projectList = ProjectList.getInstance();
                    while (iterator.hasNext()) {
                        CEffortImpl cEffortImpl = (CEffortImpl)iterator.next();
                        projectList.removeEffort(cEffortImpl);
                        ObjectFactoryImpl.destroy(cEffortImpl);
                    }
                    s_oInstance.notifyControllers(EUpdateMessage.EffortsDeleted, cEffortTree);
                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_DELETED", new Object[0]));
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortShowCollidators() {
        CEffortImpl cEffortImpl = null;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController == null) {
            throw new CFredRuntimeException("oCurrentViewController is null");
        }
        cEffortImpl = cViewController.getSelectedEffort();
        if (cEffortImpl == null || !cEffortImpl.isColliding()) {
            throw new IllegalStateException();
        }
        AFilter aFilter = AFilter.createEmptyFilter(CViewController.DEFAULT_TREE_TYPE);
        aFilter.setUseThisFilter(true);
        aFilter.addAllTasks();
        aFilter.addPerson(cEffortImpl.getPerson());
        aFilter.addAllCategories();
        aFilter.setStart(cEffortImpl.getEarliestColidersStart());
        aFilter.setEnd(cEffortImpl.getLatestColidersEnd());
        aFilter.setRelevantMaskBit(4, true);
        aFilter.setDataMaskBit(4, true);
        aFilter.setColidingReference(cEffortImpl);
        String string = cViewController.getName() + "+" + Labels.get("COLIDINGS", new Object[0]);
        s_oInstance._newViewByFilter(aFilter, string);
    }

    public static void incomingEffortExportEfforts() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            Serializable serializable;
            Collection<CEffortImpl> collection = cViewController.getSelectedEfforts();
            Vector<CColumnModel.EColumnType> vector = cViewController.getColumns().getVisibleColumTypes();
            if (collection.size() > 0) {
                serializable = new CEffortTree();
                serializable.addAll(collection);
            } else {
                serializable = cViewController.getEffortVector();
            }
            s_oInstance._incomingEffortExportEfforts((Collection<CEffortImpl>)((Object)serializable), vector);
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortExportEffortsContext() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            Vector<CColumnModel.EColumnType> vector = cViewController.getColumns().getVisibleColumTypes();
            CProjectImpl cProjectImpl = cViewController.getSelectedProject();
            CTaskImpl cTaskImpl = cViewController.getSelectedTask();
            AFilter.CTasksInTreeFilter cTasksInTreeFilter = new AFilter.CTasksInTreeFilter();
            cTasksInTreeFilter.setUseThisFilter(false);
            if (cProjectImpl != null) {
                cTasksInTreeFilter.addTasksOfProject(cProjectImpl);
                CEffortVector cEffortVector = ProjectList.getInstance().getContainedEfforts(cTasksInTreeFilter);
                s_oInstance._incomingEffortExportEfforts(cEffortVector, vector);
                return;
            }
            if (cTaskImpl != null) {
                cTasksInTreeFilter.addTask(cTaskImpl);
                CEffortVector cEffortVector = ProjectList.getInstance().getContainedEfforts(cTasksInTreeFilter);
                s_oInstance._incomingEffortExportEfforts(cEffortVector, vector);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void _incomingEffortExportEfforts(Collection<CEffortImpl> collection, Vector<CColumnModel.EColumnType> vector) {
        if (collection.size() > 0) {
            CDlgEffortExportEffortsPath cDlgEffortExportEffortsPath = new CDlgEffortExportEffortsPath(WorkFileSettings.getAsString(WorkFileSettings.EConf.LastExportPath));
            if (cDlgEffortExportEffortsPath.wasSuccessful()) {
                boolean bl;
                CDlgEffortExportEffortsPath.EExportFormat eExportFormat = cDlgEffortExportEffortsPath.getDestinationFormat();
                String string = cDlgEffortExportEffortsPath.getDestinationFile();
                WorkFileSettings.set(WorkFileSettings.EConf.LastExportPath, string);
                boolean bl2 = false;
                if (eExportFormat == CDlgEffortExportEffortsPath.EExportFormat.CSV) {
                    CDlgEffortExportCSVFormat cDlgEffortExportCSVFormat = new CDlgEffortExportCSVFormat();
                    if (cDlgEffortExportCSVFormat.showDialog() == ADialogEx.EReturnValue.OK) {
                        CEffortExportCSVSettings cEffortExportCSVSettings = cDlgEffortExportCSVFormat.geSelectedSettings();
                        bl = Export.exportToCSV(string, collection, vector, cEffortExportCSVSettings);
                    } else {
                        bl2 = true;
                        bl = false;
                    }
                } else {
                    bl = Export.exportToHTML(string, collection, vector);
                }
                if (!bl2) {
                    if (bl) {
                        FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_EXPORTED", new Object[0]));
                    } else {
                        FredMessageBox.showInfoDlg(Labels.get("INFORMATION_EXPORT_ERROR", new Object[0]), Labels.get("TITLE_EXPORT_EFFORTS", new Object[0]), MessageBox.EIcon.ERROR);
                    }
                }
            }
        } else {
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_EXPORT_NO_EFFORTS", new Object[0]), Labels.get("TITLE_EXPORT_EFFORTS", new Object[0]), MessageBox.EIcon.WARNING);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void incomingEffortReplicateEfforts() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            Iterable iterable;
            CTaskImpl cTaskImpl;
            CEffortTree cEffortTree = new CEffortTree();
            if (cViewController.getSelectedEffortCount() == 0) {
                cEffortTree.addAll(cViewController.getEffortVector());
            } else {
                cEffortTree.addAll(cViewController.getSelectedEfforts());
            }
            Vector<String[]> vector = new Vector<String[]>();
            boolean bl = false;
            TreeMap<CTaskImpl, Vector<CEffortImpl>> treeMap = new TreeMap<CTaskImpl, Vector<CEffortImpl>>();
            for (CEffortImpl object : cEffortTree) {
                cTaskImpl = object.getTask();
                if (!object.isApproved() || object.isReplicated() || !cTaskImpl.isSubscibed()) continue;
                iterable = (Vector<CEffortImpl>)treeMap.get(cTaskImpl);
                if (iterable == null) {
                    iterable = new Vector<CEffortImpl>();
                    treeMap.put(cTaskImpl, (Vector<CEffortImpl>)iterable);
                }
                ((Vector)iterable).add(object);
            }
            if (treeMap.size() > 0) {
                if (FredMessageBox.showOptionDlg(Labels.get("OPTION_REPLICATE_EFFORTS", new Object[0]), Labels.get("OPTION_REPLICATE_EFFORTS_TITLE", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO) == MessageBox.EButton.NO) {
                    return;
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    String[] stringArray;
                    cTaskImpl = (CTaskImpl)entry.getKey();
                    iterable = cTaskImpl.getProject();
                    Vector vector2 = (Vector)entry.getValue();
                    CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                    cReplicationServiceEx.setURL(((CProjectImpl)iterable).getServerURL());
                    cReplicationServiceEx.setObjectFactory(ObjectFactoryImpl.getInstance());
                    cReplicationServiceEx.setProjects(((CProjectImpl)iterable).toVector());
                    cReplicationServiceEx.setTasks(cTaskImpl.toVector());
                    cReplicationServiceEx.setEfforts(vector2);
                    cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                    CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.sendNewEfforts);
                    cServerController.start();
                    if (cServerController.getStatus() != 200) {
                        s_oInstance._checkAndCloseProject(cServerController.getStatus(), (CProjectImpl)iterable);
                        stringArray = new String[]{((CProjectImpl)iterable).getName() + " - " + cTaskImpl.getName(), s_oInstance._getErrorMessageByStatusShort(cServerController.getStatus())};
                        vector.add(stringArray);
                        continue;
                    }
                    stringArray = new String[]{((CProjectImpl)iterable).getName() + " - " + cTaskImpl.getName(), Integer.toString(vector2.size())};
                    vector.add(stringArray);
                    Iterator iterator = vector2.iterator();
                    while (iterator.hasNext()) {
                        ((CEffortImpl)iterator.next()).setReplicated(true);
                    }
                    bl = true;
                }
                if (bl) {
                    s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, cEffortTree);
                    FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_REPLICATED", new Object[0]));
                }
                if (vector.size() > 0) {
                    void var6_10;
                    Iterator<Object> iterator = new String[vector.size()][];
                    boolean bl2 = false;
                    while (var6_10 < vector.size()) {
                        iterator[var6_10] = (String[])vector.get((int)var6_10);
                        ++var6_10;
                    }
                    new CDlgEffortReplicateNotification((String[][])iterator);
                    return;
                }
            }
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_NOTHING_TO_REPLICATE", new Object[0]), Labels.get("TITLE_REPLICATE_EFFORTS", new Object[0]), MessageBox.EIcon.INFORMATION);
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortAcceptEfforts() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            MessageBox.EButton eButton;
            Collection<CEffortImpl> collection = cViewController.getSelectedEfforts();
            if (collection.size() > 0 && (eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_ACCEPT_EFFORTS", new Object[0]), Labels.get("TITLE_ACCEPT_EFFORTS", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO)) == MessageBox.EButton.YES) {
                Iterator<CEffortImpl> iterator = collection.iterator();
                Vector<CEffortImpl> vector = new Vector<CEffortImpl>(collection.size());
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl = iterator.next();
                    if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.Accepted) continue;
                    cEffortImpl.setAccepted(CEffortImpl.EAccepted.Accepted);
                    vector.add(cEffortImpl);
                }
                s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, vector);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortDiscardEfforts() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            MessageBox.EButton eButton;
            Collection<CEffortImpl> collection = cViewController.getSelectedEfforts();
            if (collection.size() > 0 && (eButton = FredMessageBox.showOptionDlg(Labels.get("CONFIRM_DISCARD_EFFORTS", new Object[0]), Labels.get("TITLE_DISCARD_EFFORTS", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO)) == MessageBox.EButton.YES) {
                Iterator<CEffortImpl> iterator = collection.iterator();
                Vector<CEffortImpl> vector = new Vector<CEffortImpl>(collection.size());
                while (iterator.hasNext()) {
                    CEffortImpl cEffortImpl = iterator.next();
                    if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.NotAccepted) continue;
                    cEffortImpl.setAccepted(CEffortImpl.EAccepted.NotAccepted);
                    vector.add(cEffortImpl);
                }
                s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, vector);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortCollectEfforts() {
        Vector<CProjectImpl> vector;
        CDlgEffortCollectEffortsProjects cDlgEffortCollectEffortsProjects;
        CViewController cViewController = s_oInstance._getCurrentViewController();
        CProjectImpl cProjectImpl = null;
        if (!(cViewController == null || (cProjectImpl = cViewController.getSelectedProject()) == null || !cProjectImpl.isClosed() && cProjectImpl.isUserProjectLeader() && cProjectImpl.isTeamProject())) {
            cProjectImpl = null;
        }
        if ((cDlgEffortCollectEffortsProjects = new CDlgEffortCollectEffortsProjects(vector = ProjectList.getInstance().getBroadcastedProjects(), cProjectImpl)).showDialog() == ADialogEx.EReturnValue.OK) {
            IXMLizable iXMLizable;
            Vector<CProjectImpl> vector2 = cDlgEffortCollectEffortsProjects.getProjectVector();
            ProjectList projectList = ProjectList.getInstance();
            String[][] stringArray = new String[vector2.size()][2];
            CEffortTree cEffortTree = new CEffortTree();
            for (int i = 0; i < vector2.size(); ++i) {
                iXMLizable = vector2.get(i);
                CReplicationServiceEx cReplicationServiceEx = new CReplicationServiceEx();
                cReplicationServiceEx.setURL(((CProjectImpl)iXMLizable).getServerURL());
                cReplicationServiceEx.setObjectFactory(ObjectFactoryImpl.getInstance());
                cReplicationServiceEx.setProjects(((CProjectImpl)iXMLizable).toVector());
                cReplicationServiceEx.setPersons(s_oInstance.getUserVector());
                CServerController cServerController = new CServerController(cReplicationServiceEx, CServerController.EReplicationJob.receiveEfforts);
                cServerController.start();
                stringArray[i] = new String[2];
                stringArray[i][0] = ((CProjectImpl)iXMLizable).getName();
                if (cServerController.getStatus() != 200) {
                    s_oInstance._checkAndCloseProject(cServerController.getStatus(), (CProjectImpl)iXMLizable);
                    stringArray[i][1] = s_oInstance._getErrorMessageByStatusShort(cServerController.getStatus());
                    continue;
                }
                ((CProjectImpl)iXMLizable).resetCollectedLastAt();
                Vector<? extends IEffortEx> vector3 = cReplicationServiceEx.getEfforts();
                if (vector3.size() == 0) {
                    stringArray[i][1] = Labels.get("TITLE_EFFORTS_NONE_SHORT", new Object[0]);
                    continue;
                }
                int n = 0;
                for (CEffortImpl cEffortImpl : vector3) {
                    cEffortImpl.setAccepted(CEffortImpl.EAccepted.NotYetAccepted);
                    cEffortImpl.setReplicated(true);
                    cEffortImpl.setApproved(true);
                    if (!projectList.addEffort(cEffortImpl)) continue;
                    ++n;
                    cEffortTree.add(cEffortImpl);
                }
                stringArray[i][1] = String.valueOf(n);
            }
            CDlgEffortCollectNotification cDlgEffortCollectNotification = new CDlgEffortCollectNotification(stringArray);
            if (cDlgEffortCollectNotification.showCollectedEfforts()) {
                iXMLizable = new AFilter.CTasksInTreeFilter();
                ((AFilter)iXMLizable).setUseThisFilter(true);
                ((AFilter)iXMLizable).setRelevantMaskBit(1, true);
                ((AFilter)iXMLizable).setDataMaskBit(1, false);
                ((AFilter)iXMLizable).addAllTasks();
                ((AFilter.CTasksInTreeFilter)iXMLizable).addAllCategories();
                ((AFilter)iXMLizable).addAllPersons();
                s_oInstance._newViewByFilter((AFilter)iXMLizable);
            }
            if (cEffortTree.size() > 0) {
                s_oInstance.notifyControllers(EUpdateMessage.EffortsCreated, cEffortTree);
                FredStatusBar.setTextForInterval(Labels.get("STATUSBAR_EFFORT_COLLECTED", new Object[0]));
            }
        }
    }

    public static void incomingEffortSetTaskForAll() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            Collection<CEffortImpl> collection = cViewController.getSelectedEfforts();
            ArrayList<CEffortImpl> arrayList = new ArrayList<CEffortImpl>(collection.size());
            for (CEffortImpl iXMLizable : collection) {
                if (iXMLizable.getProject().isClosed()) continue;
                arrayList.add(iXMLizable);
            }
            if (arrayList.size() > 0) {
                CDlgEffortSetTaskForAll cDlgEffortSetTaskForAll = new CDlgEffortSetTaskForAll(((CEffortImpl)arrayList.iterator().next()).getTask(), arrayList.size());
                if (cDlgEffortSetTaskForAll.showDialog() == ADialogEx.EReturnValue.OK) {
                    ProjectList projectList = ProjectList.getInstance();
                    CTaskImpl cTaskImpl = cDlgEffortSetTaskForAll.getSelectedTask();
                    for (CEffortImpl cEffortImpl : arrayList) {
                        projectList.removeEffort(cEffortImpl);
                        cEffortImpl.setTask(cTaskImpl);
                        projectList.addEffort(cEffortImpl);
                    }
                    s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, arrayList);
                }
            } else {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_SET_TASK_FOR_EFFORTS", new Object[0]), Labels.get("TITLE_SET_TASK_FOR_EFFORTS", new Object[0]), MessageBox.EIcon.WARNING);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingEffortSetCategoryForAll() {
        CViewController cViewController = s_oInstance._getCurrentViewController();
        if (cViewController != null) {
            Collection<CEffortImpl> collection = cViewController.getSelectedEfforts();
            ArrayList<CEffortImpl> arrayList = new ArrayList<CEffortImpl>(collection.size());
            for (CEffortImpl object : collection) {
                if (object.getProject().isClosed()) continue;
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                CDlgEffortSetCategoryForAll cDlgEffortSetCategoryForAll = new CDlgEffortSetCategoryForAll(((CEffortImpl)arrayList.iterator().next()).getCCategory(), arrayList.size());
                if (cDlgEffortSetCategoryForAll.showDialog() == ADialogEx.EReturnValue.OK) {
                    CategoryList.CCategory cCategory = cDlgEffortSetCategoryForAll.getSelectedCategory();
                    for (CEffortImpl cEffortImpl : arrayList) {
                        cEffortImpl.setCategory(cCategory);
                    }
                    s_oInstance.notifyControllers(EUpdateMessage.EffortsUpdated, arrayList);
                }
            } else {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_SET_CATEGORY_FOR_EFFORTS", new Object[0]), Labels.get("TITLE_SET_CATEGORY_FOR_EFFORTS", new Object[0]), MessageBox.EIcon.WARNING);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingExtrasLanguageGerman() {
        MainController._setLanguage(GlobalSettings.ELanguage.GERMAN);
    }

    public static void incomingExtrasLanguageFrench() {
        MainController._setLanguage(GlobalSettings.ELanguage.FRENCH);
    }

    public static void incomingExtrasLanguageEnglish() {
        MainController._setLanguage(GlobalSettings.ELanguage.ENGLISH);
    }

    private static void _setLanguage(GlobalSettings.ELanguage eLanguage) {
        boolean bl;
        String string = Labels.get("Text.Language.ChangeTitle.en", new Object[0]);
        String string2 = Labels.get("Text.Language.ChangeWarning.en", new Object[0]);
        if (eLanguage != GlobalSettings.ELanguage.ENGLISH) {
            string = Labels.get("Text.Language.ChangeTitle." + eLanguage.getLocale().getLanguage().toLowerCase(), new Object[0]) + "/" + string;
            string2 = Labels.get("Text.Language.ChangeWarning." + eLanguage.getLocale().getLanguage().toLowerCase(), new Object[0]) + "\n\n" + string2;
        }
        if (FredMessageBox.showOptionDlg(string2, string, MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO) == MessageBox.EButton.NO) {
            return;
        }
        boolean bl2 = bl = MainController.s_oInstance.m_oWorkfile != null;
        if (bl && !s_oInstance.closeWorkfile()) {
            return;
        }
        GlobalSettings.setLanguage(eLanguage);
        GlobalSettings.saveGlobalSettings();
        MainController.exit(255);
    }

    public static void incomingExtrasOptions() {
        if (MainController.s_oInstance.m_eWindowContent == CMainWindow.EWindowContent.Views) {
            CDlgExtrasOptions cDlgExtrasOptions = null;
            cDlgExtrasOptions = new CDlgExtrasOptions();
            if (cDlgExtrasOptions.showDialog() == ADialogEx.EReturnValue.OK) {
                CPersonImpl cPersonImpl = MainController.getInstance().getUser();
                cPersonImpl.setFirstName(cDlgExtrasOptions.getFirstName());
                cPersonImpl.setName(cDlgExtrasOptions.getUserName());
                cPersonImpl.setInitials(cDlgExtrasOptions.getInitials());
                MainController.s_oInstance.m_oWorkfile.setChanged();
                s_oInstance.notifyObservers();
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static void incomingExtrasGlobalSettings() {
        try {
            CDlgExtrasGlobalSettings cDlgExtrasGlobalSettings = new CDlgExtrasGlobalSettings();
            cDlgExtrasGlobalSettings.showDialog();
        }
        catch (Exception exception) {
            ADialogEx2.showDialogCreateException(exception);
        }
    }

    public static void incomingHelpShowHelp() {
        String string = GlobalSettings.getManualPath();
        if (string == null) {
            string = ManualHelper.getDefaultManualPath();
            if (!new File(string).exists()) {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_HELP_AUTOMANUALPATH_ERROR", new Object[0]) + string, Labels.get("TITLE_HELP", new Object[0]), MessageBox.EIcon.ERROR);
                return;
            }
        } else if (!new File(string).exists()) {
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_HELP_PATH_ERROR", new Object[0]), Labels.get("TITLE_HELP", new Object[0]), MessageBox.EIcon.ERROR);
            return;
        }
        try {
            ManualHelper.showManual(GlobalSettings.getPDFReaderPath(), string);
        }
        catch (Exception exception) {
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_HELP_SHOW_ERROR", new Object[0]), Labels.get("TITLE_HELP", new Object[0]), MessageBox.EIcon.ERROR, exception);
        }
    }

    public static void incomingHelpQuickstart() {
        CDlgHelpQuickStart.showQuickstartDlg();
    }

    public static void incomingHelpBugReporting() {
        try {
            BrowserLauncher browserLauncher = new BrowserLauncher(null);
            browserLauncher.openURLinBrowser("http://fred.mayastudios.com/bugtracking/");
        }
        catch (BrowserLaunchingInitializingException browserLaunchingInitializingException) {
            JOptionPane.showMessageDialog(null, "Could not start your browser. Please report the bug to:\n\nhttp://fred.mayastudios.com/bugtracking/", "Error", 0);
        }
        catch (UnsupportedOperatingSystemException unsupportedOperatingSystemException) {
            JOptionPane.showMessageDialog(null, "Could not start your browser. Please report the bug to:\n\nhttp://fred.mayastudios.com/bugtracking/", "Error", 0);
        }
    }

    public static void incomingHelpShowAbout() {
        new CDlgHelpShowAbout();
    }

    public static void incomingTabChange(ITabStateListener.EState eState) {
        CView cView;
        if (eState == ITabStateListener.EState.ACTIVATED && (cView = MainController.s_oInstance.m_oMainWindow.getCurrentView()) != null) {
            CViewController cViewController = cView.getViewController();
            CViewController cViewController2 = s_oInstance._getCurrentViewController();
            if (cViewController2 == null || cViewController2 != cViewController) {
                s_oInstance.addViewControllerToTop(cViewController);
            }
        }
    }

    public static void incomingDebugFunction() {
    }

    public static void incomingInofficialFunction() {
        if (ProjectList.getInstance().getProjectCount() == 0) {
            return;
        }
        CProjectImpl cProjectImpl = ProjectList.getInstance().getProjectIterator().next();
        CategoryList.CCategory[] cCategoryArray = CategoryList.getCategories();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - (long)(Math.random() * 3.1536E10));
        for (CTaskImpl cTaskImpl : cProjectImpl) {
            for (int i = 1; i <= 50; ++i) {
                CEffortImpl cEffortImpl = CEffortImpl.create();
                cEffortImpl.setDescription(i + "\n" + Math.random());
                cEffortImpl.setBegin(calendar);
                int n = 1 + (int)(Math.random() * 20.0);
                cEffortImpl.setDuration(n);
                calendar.add(12, n + 1);
                n = 0 + (int)(Math.random() * 5.0);
                cEffortImpl.setPauseDuration(n);
                calendar.add(12, n);
                cEffortImpl.setApproved(true);
                cEffortImpl.setCategory(cCategoryArray[(int)(Math.random() * (double)cCategoryArray.length)]);
                cTaskImpl.addEffort(cEffortImpl, true, true);
            }
        }
    }

    public void prepareSplashScreenClose(JFrame jFrame) {
        jFrame.addWindowListener(new IMainWindowListener());
    }

    public static class CXMLRootElementView
    implements IXMLizable {
        public static final String XML_GUI_TAG_NAME = "guidata";
        public static final String XML_QUICKBAR_TAG_NAME = "quickbar";
        public static final String XML_QUICKBAR_ATT_POS = "dockborder";
        public static final String XML_VIEWS_TAG_NAME = "views";

        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            new CXMLElementDefaultTask().xmlize(cSimpleXMLStream);
            WorkFileSettings.xmlizeConfiguration(cSimpleXMLStream);
            cSimpleXMLStream.startElement(XML_GUI_TAG_NAME);
            cSimpleXMLStream.startElement(XML_QUICKBAR_TAG_NAME);
            String string = QuickBar.getInstance().getDockingBorder().name();
            cSimpleXMLStream.addAttribute(XML_QUICKBAR_ATT_POS, string);
            cSimpleXMLStream.endElement(XML_QUICKBAR_TAG_NAME);
            if (WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.SaveViews)) {
                cSimpleXMLStream.startElement(XML_VIEWS_TAG_NAME);
                for (CViewController cViewController : MainController.getInstance().m_oViewControllers) {
                    cViewController.xmlize(cSimpleXMLStream);
                }
                cSimpleXMLStream.endElement(XML_VIEWS_TAG_NAME);
            }
            cSimpleXMLStream.endElement(XML_GUI_TAG_NAME);
        }
    }

    public static class CXMLElementDefaultTask
    implements IXMLizable {
        public static final String XML_DEFAULT_TASK_TAG_NAME = "defaulttask";
        private static final String XML_DEFAULT_TASK_ATT_ID = "id";

        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            if (DefaultTask.isSet()) {
                cSimpleXMLStream.startElement(XML_DEFAULT_TASK_TAG_NAME);
                cSimpleXMLStream.addAttribute(XML_DEFAULT_TASK_ATT_ID, DefaultTask.get().getID());
                cSimpleXMLStream.endElement(XML_DEFAULT_TASK_TAG_NAME);
            }
        }
    }

    public static class CXMLElementUser
    implements IXMLizable {
        public static final String XML_USER_TAG_NAME = "user";
        private static final String XML_USER_ATT_ID = "id";

        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            cSimpleXMLStream.startElement(XML_USER_TAG_NAME);
            cSimpleXMLStream.addAttribute(XML_USER_ATT_ID, MainController.getInstance().getUser().getID());
            cSimpleXMLStream.endElement(XML_USER_TAG_NAME);
        }
    }

    public static class CXMLRootElementModel
    implements IXMLizable {
        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            ObjectFactoryImpl.getInstance().xmlize(cSimpleXMLStream);
            ObjectFactoryImpl.getInstance().xmlizePersons(cSimpleXMLStream);
            new CXMLElementUser().xmlize(cSimpleXMLStream);
            MainController.getInstance().getURLList().xmlize(cSimpleXMLStream);
            ProjectList.getInstance().xmlize(cSimpleXMLStream);
        }
    }

    public static class CViewsContainer
    extends AXMLObjectContainer<Object> {
        private static final CViewController.CViewStoreContainer VIEW_STORE_CONTAINER = new CViewController.CViewStoreContainer();

        @Override
        protected Object createContainedObject(Attributes attributes, int n) {
            MainController.getInstance().m_oViewControllers.clear();
            return null;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("view")) {
                VIEW_STORE_CONTAINER.reset();
                return VIEW_STORE_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            MainController.getInstance().addViewControllerToTop((CViewController)object);
        }
    }

    public static class CQuickbarContainer
    extends AChildlessXMLObjectContainer<DockedWindow.DockingBorder> {
        @Override
        protected DockedWindow.DockingBorder createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("dockborder");
            return DockedWindow.DockingBorder.valueOf((String)string);
        }
    }

    public static class CDefaultTaskContainer
    extends AChildlessXMLObjectContainer<CTaskImpl> {
        @Override
        protected CTaskImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            CTaskImpl cTaskImpl = ObjectFactoryImpl.createTaskImpl(string);
            DefaultTask.set(cTaskImpl);
            return cTaskImpl;
        }
    }

    public static class CUserContainer
    extends AChildlessXMLObjectContainer<CPersonImpl> {
        @Override
        protected CPersonImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            CPersonImpl cPersonImpl = ObjectFactoryImpl.createPersonImpl(string);
            MainController.getInstance().m_oUser = cPersonImpl;
            return cPersonImpl;
        }
    }

    public static enum EUpdateMessage {
        ProjectCreated,
        ProjectUpdated,
        ProjectDeleted,
        TasksCreated,
        TaskUpdated,
        TaskDeleted,
        DefaultTaskChanged,
        EffortsCreated,
        EffortsUpdated,
        EffortsDeleted,
        PersonsAdded,
        PersonsDeleted,
        VisualUpdate,
        BecomesVisible;

    }

    private static class CMacOSListener
    implements MacUIListener {
        @Override
        public void handleAbout() {
            MainController.incomingHelpShowAbout();
        }

        @Override
        public void handlePreferences() {
            MainController.incomingExtrasGlobalSettings();
        }

        @Override
        public void handleQuit() {
            MainController.incomingFileExit();
        }
    }

    private class IMainWindowListener
    extends WindowAdapter {
        @Override
        public void windowOpened(WindowEvent windowEvent) {
            SplashScreen.closeSplashScreen((int)0);
        }
    }
}

