/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.labels.LabelsCore;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CEffortExportCSVSettings {
    private IExportDurationFormat m_oExportDurationFormat = null;
    private static List<IExportDurationFormat> s_oExportDurationFormats = new ArrayList<IExportDurationFormat>(3);
    private static final int SAMPLE_DURATION = 1570;

    public IExportDurationFormat getExportDurationFormat() {
        return this.m_oExportDurationFormat;
    }

    public void setExportDurationFormat(IExportDurationFormat iExportDurationFormat) {
        this.m_oExportDurationFormat = iExportDurationFormat;
    }

    public static List<IExportDurationFormat> getAvailableExportDurationFormats() {
        return Collections.unmodifiableList(s_oExportDurationFormats);
    }

    static {
        s_oExportDurationFormats.add(new CExportDurationHHMM());
        s_oExportDurationFormats.add(new CExportDurationDDHHMM());
        s_oExportDurationFormats.add(new CExportDurationHHFloating());
        s_oExportDurationFormats.add(new CExportDurationHHFloatingQuarters());
    }

    private static class CExportDurationHHFloatingQuarters
    extends AExportDurationFormat {
        private NumberFormat hhFloatingFormatter;

        CExportDurationHHFloatingQuarters() {
            this.reInitNumberFormat();
            LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)new LabelsCore.ILabelsChangeListener(){

                public void labelsChanged(boolean bl) {
                    if (bl) {
                        CExportDurationHHFloatingQuarters.this.reInitNumberFormat();
                    }
                }
            }, (BaseEventManager.ERefType)BaseEventManager.ERefType.REGULAR);
        }

        private void reInitNumberFormat() {
            Locale locale = LabelsCore.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.hhFloatingFormatter = new DecimalFormat("0.00", new DecimalFormatSymbols(locale));
        }

        @Override
        public String formatDuration(int n) {
            double d = this.calculateDurationInHours(n);
            return this.hhFloatingFormatter.format(d);
        }

        private double calculateDurationInHours(int n) {
            return (double)Math.round((double)n / 15.0) / 4.0;
        }

        @Override
        public String getName() {
            return String.format("HH.HH (%s \u2192 %s)", DateTime.getDurationString(1570, false), this.hhFloatingFormatter.format(this.calculateDurationInHours(1570)));
        }
    }

    private static class CExportDurationHHFloating
    extends AExportDurationFormat {
        private NumberFormat hhFloatingFormatter;

        CExportDurationHHFloating() {
            this.reInitNumberFormat();
            LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)new LabelsCore.ILabelsChangeListener(){

                public void labelsChanged(boolean bl) {
                    if (bl) {
                        CExportDurationHHFloating.this.reInitNumberFormat();
                    }
                }
            }, (BaseEventManager.ERefType)BaseEventManager.ERefType.REGULAR);
        }

        private void reInitNumberFormat() {
            Locale locale = LabelsCore.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.hhFloatingFormatter = new DecimalFormat("0.00", new DecimalFormatSymbols(locale));
        }

        @Override
        public String formatDuration(int n) {
            double d = this.calculateDurationInHours(n);
            return this.hhFloatingFormatter.format(d);
        }

        private double calculateDurationInHours(int n) {
            return (double)n / 60.0;
        }

        @Override
        public String getName() {
            return String.format("HH.HH (%s \u2192 %s)", DateTime.getDurationString(1570, false), this.hhFloatingFormatter.format(this.calculateDurationInHours(1570)));
        }
    }

    private static class CExportDurationDDHHMM
    extends AExportDurationFormat {
        private CExportDurationDDHHMM() {
        }

        @Override
        public String formatDuration(int n) {
            return DateTime.getDurationString(n, true);
        }

        @Override
        public String getName() {
            return String.format("DDd HH:MM (%s \u2192 %s)", DateTime.getDurationString(1570, false), DateTime.getDurationString(1570, true));
        }
    }

    private static class CExportDurationHHMM
    extends AExportDurationFormat {
        private CExportDurationHHMM() {
        }

        @Override
        public String formatDuration(int n) {
            return DateTime.getDurationString(n, false);
        }

        @Override
        public String getName() {
            return String.format("HH:MM (%s \u2192 %s)", DateTime.getDurationString(1570, false), DateTime.getDurationString(1570, false));
        }
    }

    private static abstract class AExportDurationFormat
    implements IExportDurationFormat {
        private AExportDurationFormat() {
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface IExportDurationFormat {
        public String formatDuration(int var1);

        public String getName();
    }
}

