/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class COutputFile {
    private RandomAccessFile m_oFile;
    private CPositionedFileOutputStream m_oOutputStream;

    public COutputFile(String string, long l) throws IOException {
        this(string != null ? new File(string) : null, l);
    }

    public COutputFile(File file, long l) throws IOException {
        this.m_oFile = new RandomAccessFile(file, "rw");
        this.m_oFile.seek(l);
        this.m_oOutputStream = new CPositionedFileOutputStream(this.m_oFile, l);
    }

    public OutputStream getOutputStream() {
        return this.m_oOutputStream;
    }

    public long getFilePosition() {
        return this.m_oOutputStream.m_lCurFilePosition;
    }

    private static class CPositionedFileOutputStream
    extends OutputStream {
        private RandomAccessFile m_oRandomAcessFile;
        long m_lCurFilePosition;

        CPositionedFileOutputStream(RandomAccessFile randomAccessFile, long l) {
            this.m_oRandomAcessFile = randomAccessFile;
            this.m_lCurFilePosition = l;
        }

        @Override
        public void write(int n) throws IOException {
            this.m_oRandomAcessFile.write(n);
            ++this.m_lCurFilePosition;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_oRandomAcessFile.write(byArray, n, n2);
            this.m_lCurFilePosition += (long)n2;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.m_oRandomAcessFile.write(byArray);
            this.m_lCurFilePosition += (long)byArray.length;
        }

        @Override
        public void close() throws IOException {
            this.m_oRandomAcessFile.setLength(this.m_lCurFilePosition);
            this.m_oRandomAcessFile.close();
        }
    }
}

