/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.resources.configfile.XmlConfigFile;
import com.mayastudios.systeminfo.MacOSInfo;
import com.mayastudios.systeminfo.SystemInfo;
import com.mayastudios.systeminfo.WindowsInfo;
import java.io.File;
import java.io.IOException;

public class UserMode {
    public static final String USERMODE_SPECIFY_PROPKEY = "UserMode";
    private static final String USERMODE_FILE_NAME = "UserMode.xml";
    private static final File USERMODE_FILE_PATH;
    private static final String USER_MODE_KEY = "userMode";
    private static final String USER_MODE_SINGLE = "Single";
    private static final String USER_MODE_MULTI = "Multi";
    private static final UserMode INSTANCE;
    private final XmlConfigFile m_userModeFile;
    private final boolean m_isMultiUserMode;

    private UserMode() {
        String string = null;
        if (System.getProperty(USERMODE_SPECIFY_PROPKEY) != null) {
            this.m_userModeFile = null;
            string = System.getProperty(USERMODE_SPECIFY_PROPKEY);
        } else if (USERMODE_FILE_PATH != null) {
            this.m_userModeFile = new XmlConfigFile(USERMODE_FILE_PATH);
            string = this.m_userModeFile.getAsString(USER_MODE_KEY);
        } else {
            this.m_userModeFile = null;
        }
        this.m_isMultiUserMode = UserMode.isMultiUserModeSupported() && (string == null || string.equals(USER_MODE_MULTI));
        if (string == null && this.m_userModeFile != null) {
            try {
                this.saveUserMode(this.m_isMultiUserMode);
            }
            catch (IOException iOException) {
                MainController.LOGGER.warn("", (Throwable)iOException);
            }
        }
    }

    public static boolean isMultiUserModeSupported() {
        switch (SystemInfo.OSTYPE) {
            case Linux: 
            case Solaris: {
                return true;
            }
            case MacOS: {
                return ((MacOSInfo)SystemInfo.INFO).isMacOSX();
            }
            case Windows: {
                return ((WindowsInfo)SystemInfo.INFO).isNTBased();
            }
        }
        return false;
    }

    public static boolean isMultiUserMode() {
        return UserMode.INSTANCE.m_isMultiUserMode;
    }

    private void saveUserMode(boolean bl) throws IOException {
        if (this.m_userModeFile == null) {
            throw new IllegalStateException();
        }
        if (bl) {
            this.m_userModeFile.set(USER_MODE_KEY, USER_MODE_MULTI);
        } else {
            this.m_userModeFile.set(USER_MODE_KEY, USER_MODE_SINGLE);
        }
        this.m_userModeFile.storeToXML();
    }

    static {
        File file = DirectoryUtil.getAppConfigDir();
        USERMODE_FILE_PATH = file == null ? null : new File(file, USERMODE_FILE_NAME);
        INSTANCE = new UserMode();
    }
}

