/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling.xml;

import com.mayastudios.fred.client.exceptions.CFredAbortException;
import com.mayastudios.fred.client.exceptions.CXMLException;
import com.mayastudios.fred.client.filehandling.COutputFile;
import com.mayastudios.fred.client.filehandling.xml.CSimpleDefaultHandler;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.mscl.CExecutionTime;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileHandling {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final int BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLFileHandling.class);

    public static void processXML(File file, CSimpleDefaultHandler cSimpleDefaultHandler) throws IOException, FileNotFoundException, CXMLException {
        XMLFileHandling.processXML(file, (URL)null, cSimpleDefaultHandler);
    }

    public static void processXML(File file, URL uRL, CSimpleDefaultHandler cSimpleDefaultHandler) throws IOException, FileNotFoundException, CXMLException {
        LOGGER.info("[Parsen][{}] {}", (Object)file.getName(), (Object)file.getAbsolutePath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Datei ist nicht lesbar: " + file.getAbsolutePath());
        }
        XMLFileHandling.processXML(file.getName(), new FileInputStream(file), uRL, cSimpleDefaultHandler);
    }

    public static void processXML(String string, InputStream inputStream, CSimpleDefaultHandler cSimpleDefaultHandler) throws IOException, FileNotFoundException, CXMLException {
        XMLFileHandling.processXML(string, inputStream, null, cSimpleDefaultHandler);
    }

    public static void processXML(String string, InputStream inputStream, URL uRL, CSimpleDefaultHandler cSimpleDefaultHandler) throws IOException, FileNotFoundException, CXMLException {
        LOGGER.info("[Parsen][{}] Start", (Object)string);
        boolean bl = false;
        SAXParser sAXParser = null;
        try {
            CExecutionTime cExecutionTime = new CExecutionTime();
            cExecutionTime.startTimer();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            if (uRL != null) {
                LOGGER.info("[Parsen][{}][Schema] {}", (Object)string, (Object)uRL.toString());
                try {
                    SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    sAXParserFactory.setSchema(schemaFactory.newSchema(uRL));
                    LOGGER.info("[Parsen][{}][Schema] SchemaFactory", (Object)string);
                }
                catch (SAXException sAXException) {
                    throw new CXMLException("Ung\u00fcltige Schema-Datei", sAXException);
                }
                catch (Exception exception) {
                    sAXParserFactory.setValidating(true);
                    bl = true;
                    LOGGER.info("[Parsen][{}][Schema] AlternativeSchemaWay", (Object)string);
                }
            } else {
                LOGGER.info("[Parsen][{}][Schema] Kein Schema", (Object)string);
            }
            sAXParser = sAXParserFactory.newSAXParser();
            if (uRL != null && bl) {
                sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
                sAXParser.setProperty(JAXP_SCHEMA_SOURCE, uRL.toString());
            }
            sAXParser.parse(inputStream, (DefaultHandler)cSimpleDefaultHandler);
            cExecutionTime.stopTimer();
            LOGGER.info("[Parsen][{}] Beendet nach {}", (Object)string, (Object)cExecutionTime.toString());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalStateException(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalStateException(sAXNotSupportedException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new CXMLException("SAXException:\n" + sAXException.getMessage(), sAXException);
        }
        catch (CFredAbortException cFredAbortException) {
            throw new CXMLException("CFredAbortException:\n" + cFredAbortException.getMessage(), cFredAbortException);
        }
        catch (NullPointerException nullPointerException) {
            throw new CXMLException("NullPointerException:\n" + nullPointerException.getMessage(), nullPointerException);
        }
        finally {
            inputStream.close();
        }
    }

    public static void writeXMLComplete(File file, IXMLizable iXMLizable, boolean bl) throws IOException, FileNotFoundException, CXMLException {
        class CCompleteWriter
        implements IWriterCallback {
            final /* synthetic */ IXMLizable val$p_oRootElement;

            CCompleteWriter(IXMLizable iXMLizable) {
                this.val$p_oRootElement = iXMLizable;
            }

            @Override
            public void doWriting(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
                cSimpleXMLStream.startDocument();
                this.val$p_oRootElement.xmlize(cSimpleXMLStream);
                cSimpleXMLStream.endDocument();
            }
        }
        XMLFileHandling._writeXMLInternal(file, new CCompleteWriter(iXMLizable), bl, 0L);
    }

    public static void writeXMLPartial(File file, final IXMLizable iXMLizable, long l, final int n) throws IOException, FileNotFoundException, CXMLException {
        class CPartiallyWriter
        implements IWriterCallback {
            CPartiallyWriter() {
            }

            @Override
            public void doWriting(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
                try {
                    cSimpleXMLStream.getWriter().append('\n');
                    for (int i = 0; i < n; ++i) {
                        cSimpleXMLStream.getWriter().append(' ');
                    }
                }
                catch (IOException iOException) {
                    throw new CSimpleXMLStream.XmlWriteException(iOException.getMessage(), iOException);
                }
                cSimpleXMLStream.indent(n);
                iXMLizable.xmlize(cSimpleXMLStream);
                cSimpleXMLStream.endDocument();
            }
        }
        XMLFileHandling._writeXMLInternal(file, new CPartiallyWriter(), false, l);
    }

    private static void _writeXMLInternal(File file, IWriterCallback iWriterCallback, boolean bl, long l) throws IOException, FileNotFoundException, CXMLException {
        Object object;
        String string = null;
        String string2 = null;
        BufferedWriter bufferedWriter = null;
        if (!file.exists()) {
            if (l > 0L) {
                throw new IOException("Can't start writing beyond the 0th byte, if the file doesn't exist.");
            }
            bl = false;
        }
        if (l > 0L) {
            bl = false;
        }
        if (bl) {
            string = file.getAbsolutePath() + ".bak";
        }
        string2 = l > 0L ? file.getAbsolutePath() : file + ".tmp";
        try {
            object = new COutputFile(string2, l);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(((COutputFile)object).getOutputStream(), Charset.forName("UTF-8"));
            bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
            CSimpleXMLStream cSimpleXMLStream = new CSimpleXMLStream((COutputFile)object, 1, bufferedWriter);
            iWriterCallback.doWriting(cSimpleXMLStream);
        }
        catch (CSimpleXMLStream.XmlWriteException xmlWriteException) {
            throw new CXMLException("JiBXException:\n" + xmlWriteException.getMessage(), xmlWriteException);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        if (l > 0L) {
            return;
        }
        if (bl) {
            object = new File(string);
            if (((File)object).exists() && !((File)object).delete()) {
                throw new IOException("Die alte Backup-Datei \"" + file + "\" konnte nicht gel\u00f6scht werden!");
            }
            if (!file.renameTo((File)object)) {
                throw new IOException("Konnte kein Backup der Datei \"" + file + "\" erstellen.");
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Die alte Version der Datei \"" + file + "\" konnte nicht gel\u00f6scht werden!");
        }
        object = new File(string2);
        if (!((File)object).renameTo(file)) {
            throw new IOException("Konnte die Datei \"" + string2 + "\" nicht in \"" + file + "\" umbennen.");
        }
    }

    public static String attributesToString(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributes.getLength(); ++i) {
            stringBuffer.append("QName: " + attributes.getQName(i) + " | ");
            stringBuffer.append("Value: " + attributes.getValue(i) + " | ");
            stringBuffer.append("Type: " + attributes.getType(i) + "\n");
        }
        return stringBuffer.toString();
    }

    private static interface IWriterCallback {
        public void doWriting(CSimpleXMLStream var1) throws CSimpleXMLStream.XmlWriteException;
    }
}

